/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import junit.framework.TestCase;
import org.apache.flink.core.fs.FSDataInputStream;
import org.apache.flink.runtime.state.ChangelogTestUtils;
import org.apache.flink.runtime.state.SharedStateRegistry;
import org.apache.flink.runtime.state.SharedStateRegistryImpl;
import org.apache.flink.runtime.state.SharedStateRegistryKey;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.state.changelog.ChangelogStateBackendHandle;
import org.junit.Assert;
import org.junit.Test;

public class SharedStateRegistryTest {
    @Test
    public void testRegistryNormal() {
        TestSharedState firstState = new TestSharedState("first");
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl();
        StreamStateHandle result = sharedStateRegistry.registerReference(firstState.getRegistrationKey(), (StreamStateHandle)firstState, 0L);
        Assert.assertTrue((firstState == result ? 1 : 0) != 0);
        TestCase.assertFalse((boolean)firstState.isDiscarded());
        TestSharedState secondState = new TestSharedState("second");
        result = sharedStateRegistry.registerReference(secondState.getRegistrationKey(), (StreamStateHandle)secondState, 0L);
        Assert.assertTrue((secondState == result ? 1 : 0) != 0);
        TestCase.assertFalse((boolean)firstState.isDiscarded());
        TestCase.assertFalse((boolean)secondState.isDiscarded());
        TestSharedState firstStatePrime = new TestSharedState(firstState.getRegistrationKey().getKeyString());
        result = sharedStateRegistry.registerReference(firstState.getRegistrationKey(), (StreamStateHandle)firstStatePrime, 0L);
        Assert.assertTrue((firstStatePrime == result ? 1 : 0) != 0);
        TestCase.assertFalse((boolean)firstStatePrime.isDiscarded());
        TestCase.assertFalse((firstState == result ? 1 : 0) != 0);
        Assert.assertTrue((boolean)firstState.isDiscarded());
        sharedStateRegistry.checkpointCompleted(0L);
        TestSharedState firstStateDPrime = new TestSharedState(firstState.getRegistrationKey().getKeyString());
        result = sharedStateRegistry.registerReference(firstState.getRegistrationKey(), (StreamStateHandle)firstStateDPrime, 0L);
        TestCase.assertFalse((firstStateDPrime == result ? 1 : 0) != 0);
        Assert.assertTrue((boolean)firstStateDPrime.isDiscarded());
        Assert.assertTrue((firstStatePrime == result ? 1 : 0) != 0);
        TestCase.assertFalse((boolean)firstStatePrime.isDiscarded());
        result = sharedStateRegistry.registerReference(firstState.getRegistrationKey(), (StreamStateHandle)firstState, 0L);
        Assert.assertTrue((firstStatePrime == result ? 1 : 0) != 0);
        TestCase.assertFalse((boolean)firstStatePrime.isDiscarded());
        sharedStateRegistry.unregisterUnusedState(1L);
        Assert.assertTrue((boolean)secondState.isDiscarded());
        Assert.assertTrue((boolean)firstState.isDiscarded());
    }

    @Test
    public void testUnregisterWithUnexistedKey() {
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl();
        sharedStateRegistry.unregisterUnusedState(-1L);
        sharedStateRegistry.unregisterUnusedState(Long.MAX_VALUE);
    }

    @Test
    public void testRegisterChangelogStateBackendHandles() throws InterruptedException {
        SharedStateRegistryImpl sharedStateRegistry = new SharedStateRegistryImpl();
        long materializationId1 = 1L;
        ChangelogTestUtils.IncrementalStateHandleWrapper materializedStateBase1 = ChangelogTestUtils.createDummyIncrementalStateHandle(materializationId1);
        ChangelogTestUtils.IncrementalStateHandleWrapper materializedState1 = materializedStateBase1.deserialize();
        ChangelogTestUtils.ChangelogStateHandleWrapper nonMaterializedState1 = ChangelogTestUtils.createDummyChangelogStateHandle(1L, 2L);
        long materializationId = 1L;
        long checkpointId1 = 41L;
        ChangelogStateBackendHandle.ChangelogStateBackendHandleImpl changelogStateBackendHandle1 = new ChangelogStateBackendHandle.ChangelogStateBackendHandleImpl(Collections.singletonList(materializedState1), Collections.singletonList(nonMaterializedState1), materializedStateBase1.getKeyGroupRange(), materializationId, nonMaterializedState1.getStateSize());
        changelogStateBackendHandle1.registerSharedStates((SharedStateRegistry)sharedStateRegistry, checkpointId1);
        sharedStateRegistry.checkpointCompleted(checkpointId1);
        sharedStateRegistry.unregisterUnusedState(checkpointId1);
        ChangelogTestUtils.IncrementalStateHandleWrapper materializedState2 = materializedStateBase1.deserialize();
        ChangelogTestUtils.ChangelogStateHandleWrapper nonMaterializedState2 = ChangelogTestUtils.createDummyChangelogStateHandle(2L, 3L);
        long checkpointId2 = 42L;
        ChangelogStateBackendHandle.ChangelogStateBackendHandleImpl changelogStateBackendHandle2 = new ChangelogStateBackendHandle.ChangelogStateBackendHandleImpl(Collections.singletonList(materializedState2), Collections.singletonList(nonMaterializedState2), materializedStateBase1.getKeyGroupRange(), materializationId, nonMaterializedState2.getStateSize());
        changelogStateBackendHandle2.registerSharedStates((SharedStateRegistry)sharedStateRegistry, checkpointId2);
        sharedStateRegistry.checkpointCompleted(checkpointId2);
        sharedStateRegistry.unregisterUnusedState(checkpointId2);
        TestCase.assertFalse((boolean)materializedState1.isDiscarded());
        TestCase.assertFalse((boolean)materializedState2.isDiscarded());
        Assert.assertTrue((boolean)nonMaterializedState1.isDiscarded());
        long materializationId2 = 2L;
        ChangelogTestUtils.IncrementalStateHandleWrapper materializedStateBase2 = ChangelogTestUtils.createDummyIncrementalStateHandle(materializationId2);
        ChangelogTestUtils.IncrementalStateHandleWrapper materializedState3 = materializedStateBase2.deserialize();
        long checkpointId3 = 43L;
        ChangelogStateBackendHandle.ChangelogStateBackendHandleImpl changelogStateBackendHandle3 = new ChangelogStateBackendHandle.ChangelogStateBackendHandleImpl(Collections.singletonList(materializedState3), Collections.singletonList(nonMaterializedState2), materializedState3.getKeyGroupRange(), materializationId2, 0L);
        changelogStateBackendHandle3.registerSharedStates((SharedStateRegistry)sharedStateRegistry, checkpointId3);
        sharedStateRegistry.checkpointCompleted(checkpointId3);
        sharedStateRegistry.unregisterUnusedState(checkpointId3);
        Assert.assertTrue((boolean)materializedState1.isDiscarded());
        TestCase.assertFalse((boolean)nonMaterializedState2.isDiscarded());
    }

    private static class TestSharedState
    implements StreamStateHandle {
        private static final long serialVersionUID = 4468635881465159780L;
        private SharedStateRegistryKey key;
        private boolean discarded;

        TestSharedState(String key) {
            this.key = new SharedStateRegistryKey(key);
            this.discarded = false;
        }

        public SharedStateRegistryKey getRegistrationKey() {
            return this.key;
        }

        public void discardState() throws Exception {
            this.discarded = true;
        }

        public long getStateSize() {
            return this.key.toString().length();
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public FSDataInputStream openInputStream() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Optional<byte[]> asBytesIfInMemory() {
            return Optional.empty();
        }

        public boolean isDiscarded() {
            return this.discarded;
        }
    }
}

