/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.util.MutableObjectIterator;

public class UnionIterator<E>
implements MutableObjectIterator<E> {
    private MutableObjectIterator<E> currentSource;
    private List<MutableObjectIterator<E>> nextSources;

    public UnionIterator(MutableObjectIterator<E> ... iterators) {
        this(new ArrayList<MutableObjectIterator<E>>(Arrays.asList(iterators)));
    }

    public UnionIterator(List<MutableObjectIterator<E>> sources) {
        this.currentSource = sources.remove(0);
        this.nextSources = sources;
    }

    public E next(E target) throws IOException {
        Object targetStaging = this.currentSource.next(target);
        if (targetStaging != null) {
            return (E)targetStaging;
        }
        if (this.nextSources.size() > 0) {
            this.currentSource = this.nextSources.remove(0);
            return this.next(target);
        }
        return null;
    }

    public E next() throws IOException {
        Object targetStaging = this.currentSource.next();
        if (targetStaging != null) {
            return (E)targetStaging;
        }
        if (this.nextSources.size() > 0) {
            this.currentSource = this.nextSources.remove(0);
            return this.next();
        }
        return null;
    }
}

