/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.util.UUID;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.leaderelection.LeaderElectionDriver;
import org.apache.flink.runtime.leaderelection.LeaderElectionEventHandler;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.TestingLeaderBase;
import org.apache.flink.util.Preconditions;

public class TestingLeaderElectionEventHandler
extends TestingLeaderBase
implements LeaderElectionEventHandler {
    private final Object lock = new Object();
    private final String leaderAddress;
    private final OneShotLatch initializationLatch;
    private final Consumer<LeaderInformation> leaderInformationConsumer;
    @Nullable
    private LeaderElectionDriver initializedLeaderElectionDriver = null;
    private LeaderInformation confirmedLeaderInformation = LeaderInformation.empty();
    private boolean running = true;

    public TestingLeaderElectionEventHandler(String leaderAddress) {
        this.leaderAddress = leaderAddress;
        this.initializationLatch = new OneShotLatch();
        this.leaderInformationConsumer = ignore -> {};
    }

    public TestingLeaderElectionEventHandler(String leaderAddress, Consumer<LeaderInformation> leaderInformationConsumer) {
        this.leaderAddress = leaderAddress;
        this.initializationLatch = new OneShotLatch();
        this.leaderInformationConsumer = leaderInformationConsumer;
    }

    public void init(LeaderElectionDriver leaderElectionDriver) {
        Preconditions.checkState((this.initializedLeaderElectionDriver == null ? 1 : 0) != 0);
        this.initializedLeaderElectionDriver = leaderElectionDriver;
        this.initializationLatch.trigger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ifRunning(Runnable action) {
        Object object = this.lock;
        synchronized (object) {
            if (this.running) {
                action.run();
            }
        }
    }

    public void onGrantLeadership(UUID newLeaderSessionId) {
        this.ifRunning(() -> this.waitForInitialization(leaderElectionDriver -> {
            this.confirmedLeaderInformation = LeaderInformation.known((UUID)newLeaderSessionId, (String)this.leaderAddress);
            leaderElectionDriver.writeLeaderInformation(this.confirmedLeaderInformation);
            this.leaderEventQueue.offer(this.confirmedLeaderInformation);
        }));
    }

    public void onRevokeLeadership() {
        this.ifRunning(() -> this.waitForInitialization(leaderElectionDriver -> {
            this.confirmedLeaderInformation = LeaderInformation.empty();
            leaderElectionDriver.writeLeaderInformation(this.confirmedLeaderInformation);
            this.leaderEventQueue.offer(this.confirmedLeaderInformation);
        }));
    }

    public void onLeaderInformationChange(LeaderInformation leaderInformation) {
        this.ifRunning(() -> this.waitForInitialization(leaderElectionDriver -> {
            this.leaderInformationConsumer.accept(leaderInformation);
            if (this.confirmedLeaderInformation.getLeaderSessionID() != null && !this.confirmedLeaderInformation.equals((Object)leaderInformation)) {
                leaderElectionDriver.writeLeaderInformation(this.confirmedLeaderInformation);
            }
        }));
    }

    private void waitForInitialization(Consumer<? super LeaderElectionDriver> operation) {
        try {
            this.initializationLatch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        Preconditions.checkState((this.initializedLeaderElectionDriver != null ? 1 : 0) != 0);
        operation.accept((LeaderElectionDriver)this.initializedLeaderElectionDriver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LeaderInformation getConfirmedLeaderInformation() {
        Object object = this.lock;
        synchronized (object) {
            return this.confirmedLeaderInformation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
        }
    }
}

