/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.factories;

import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobmaster.JobMasterServiceProcess;
import org.apache.flink.runtime.jobmaster.TestingJobMasterServiceProcess;
import org.apache.flink.runtime.jobmaster.factories.JobMasterServiceProcessFactory;

public class TestingJobMasterServiceProcessFactory
implements JobMasterServiceProcessFactory {
    private final Function<UUID, JobMasterServiceProcess> jobMasterServiceProcessFunction;
    private final JobID jobId;
    private final String jobName;
    private final long initializationTimestamp;

    private TestingJobMasterServiceProcessFactory(Function<UUID, JobMasterServiceProcess> jobMasterServiceProcessFunction, JobID jobId, String jobName, long initializationTimestamp) {
        this.jobMasterServiceProcessFunction = jobMasterServiceProcessFunction;
        this.jobId = jobId;
        this.jobName = jobName;
        this.initializationTimestamp = initializationTimestamp;
    }

    public JobMasterServiceProcess create(UUID leaderSessionId) {
        return this.jobMasterServiceProcessFunction.apply(leaderSessionId);
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public ArchivedExecutionGraph createArchivedExecutionGraph(JobStatus jobStatus, @Nullable Throwable cause) {
        return ArchivedExecutionGraph.createSparseArchivedExecutionGraph((JobID)this.jobId, (String)this.jobName, (JobStatus)jobStatus, (Throwable)cause, null, (long)this.initializationTimestamp);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private Function<UUID, JobMasterServiceProcess> jobMasterServiceProcessFunction = ignored -> TestingJobMasterServiceProcess.newBuilder().build();
        private JobID jobId = new JobID();
        private String jobName = "foobar";
        private long initializationTimestamp = 1337L;

        public Builder setJobMasterServiceProcessFunction(Function<UUID, JobMasterServiceProcess> jobMasterServiceProcessFunction) {
            this.jobMasterServiceProcessFunction = jobMasterServiceProcessFunction;
            return this;
        }

        public Builder setJobId(JobID jobId) {
            this.jobId = jobId;
            return this;
        }

        public Builder setJobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public Builder setInitializationTimestamp(long initializationTimestamp) {
            this.initializationTimestamp = initializationTimestamp;
            return this;
        }

        public TestingJobMasterServiceProcessFactory build() {
            return new TestingJobMasterServiceProcessFactory(this.jobMasterServiceProcessFunction, this.jobId, this.jobName, this.initializationTimestamp);
        }
    }
}

