/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster;

import java.io.File;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.functions.AggregateFunction;
import org.apache.flink.api.common.io.DefaultInputSplitAssigner;
import org.apache.flink.api.common.restartstrategy.RestartStrategies;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.ClosureCleaner;
import org.apache.flink.api.java.tuple.Tuple3;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.JobManagerOptions;
import org.apache.flink.configuration.RestartStrategyOptions;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.core.io.InputSplit;
import org.apache.flink.core.io.InputSplitAssigner;
import org.apache.flink.core.io.InputSplitSource;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.checkpoint.CheckpointProperties;
import org.apache.flink.runtime.checkpoint.CheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpoint;
import org.apache.flink.runtime.checkpoint.PerJobCheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointRecoveryFactory;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptor;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.AccessExecution;
import org.apache.flink.runtime.executiongraph.AccessExecutionVertex;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.heartbeat.TestingHeartbeatServices;
import org.apache.flink.runtime.highavailability.TestingHighAvailabilityServices;
import org.apache.flink.runtime.instance.SimpleSlotContext;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.io.network.partition.TestingJobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.runtime.jobgraph.tasks.AbstractInvokable;
import org.apache.flink.runtime.jobmanager.PartitionProducerDisposedException;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.AllocatedSlotInfo;
import org.apache.flink.runtime.jobmaster.AllocatedSlotReport;
import org.apache.flink.runtime.jobmaster.DefaultSlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.JMTMRegistrationRejection;
import org.apache.flink.runtime.jobmaster.JMTMRegistrationSuccess;
import org.apache.flink.runtime.jobmaster.JobManagerSharedServices;
import org.apache.flink.runtime.jobmaster.JobMaster;
import org.apache.flink.runtime.jobmaster.JobMasterGateway;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.JobMasterTestUtils;
import org.apache.flink.runtime.jobmaster.SerializedInputSplit;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.SlotPoolServiceSchedulerFactory;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.TaskManagerRegistrationInformation;
import org.apache.flink.runtime.jobmaster.TestUtils;
import org.apache.flink.runtime.jobmaster.TestingJobManagerSharedServicesBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotInfoWithUtilization;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolService;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPoolServiceFactory;
import org.apache.flink.runtime.jobmaster.slotpool.TestingSlotPoolServiceBuilder;
import org.apache.flink.runtime.jobmaster.utils.JobMasterBuilder;
import org.apache.flink.runtime.leaderretrieval.SettableLeaderRetrievalService;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.registration.RegistrationResponse;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.utils.TestingResourceManagerGateway;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.runtime.rpc.TestingRpcService;
import org.apache.flink.runtime.rpc.exceptions.RecipientUnreachableException;
import org.apache.flink.runtime.scheduler.DefaultSchedulerFactory;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.scheduler.SchedulerNGFactory;
import org.apache.flink.runtime.scheduler.TestingSchedulerNG;
import org.apache.flink.runtime.scheduler.TestingSchedulerNGFactory;
import org.apache.flink.runtime.state.CompletedCheckpointStorageLocation;
import org.apache.flink.runtime.state.StreamStateHandle;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.LocalUnresolvedTaskManagerLocation;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.runtime.taskmanager.UnresolvedTaskManagerLocation;
import org.apache.flink.runtime.testtasks.NoOpInvokable;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.TestingFatalErrorHandler;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.testutils.junit.FailsWithAdaptiveScheduler;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.QuadFunction;
import org.apache.flink.util.function.SupplierWithException;
import org.apache.flink.util.function.TriFunction;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TemporaryFolder;

public class JobMasterTest
extends TestLogger {
    private static final TestingInputSplit[] EMPTY_TESTING_INPUT_SPLITS = new TestingInputSplit[0];
    @ClassRule
    public static TemporaryFolder temporaryFolder = new TemporaryFolder();
    private static final Time testingTimeout = Time.seconds((long)10L);
    private static final long fastHeartbeatInterval = 1L;
    private static final long fastHeartbeatTimeout = 10L;
    private static final long heartbeatInterval = 1000L;
    private static final long heartbeatTimeout = 5000000L;
    private static final JobGraph jobGraph = JobGraphTestUtils.singleNoOpJobGraph();
    private static TestingRpcService rpcService;
    private static HeartbeatServices fastHeartbeatServices;
    private static HeartbeatServices heartbeatServices;
    private Configuration configuration;
    private ResourceID jmResourceId;
    private JobMasterId jobMasterId;
    private TestingHighAvailabilityServices haServices;
    private SettableLeaderRetrievalService rmLeaderRetrievalService;
    private TestingFatalErrorHandler testingFatalErrorHandler;

    @BeforeClass
    public static void setupClass() {
        rpcService = new TestingRpcService();
        fastHeartbeatServices = new HeartbeatServices(1L, 10L, -1);
        heartbeatServices = new HeartbeatServices(1000L, 5000000L, 1);
    }

    @Before
    public void setup() throws IOException {
        this.configuration = new Configuration();
        this.haServices = new TestingHighAvailabilityServices();
        this.jobMasterId = JobMasterId.generate();
        this.jmResourceId = ResourceID.generate();
        this.testingFatalErrorHandler = new TestingFatalErrorHandler();
        this.haServices.setCheckpointRecoveryFactory((CheckpointRecoveryFactory)new StandaloneCheckpointRecoveryFactory());
        this.rmLeaderRetrievalService = new SettableLeaderRetrievalService(null, null);
        this.haServices.setResourceManagerLeaderRetriever(this.rmLeaderRetrievalService);
        this.configuration.setString(BlobServerOptions.STORAGE_DIRECTORY, temporaryFolder.newFolder().getAbsolutePath());
    }

    @After
    public void teardown() throws Exception {
        if (this.testingFatalErrorHandler != null) {
            this.testingFatalErrorHandler.rethrowError();
        }
        rpcService.clearGateways();
    }

    @AfterClass
    public static void teardownClass() {
        if (rpcService != null) {
            rpcService.stopService();
            rpcService = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskManagerRegistrationTriggersHeartbeating() throws Exception {
        CompletableFuture heartbeatResourceIdFuture = new CompletableFuture();
        LocalUnresolvedTaskManagerLocation unresolvedTaskManagerLocation = new LocalUnresolvedTaskManagerLocation();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setHeartbeatJobManagerFunction((taskManagerId, ignored) -> {
            heartbeatResourceIdFuture.complete(taskManagerId);
            return FutureUtils.completedVoidFuture();
        }).createTestingTaskExecutorGateway();
        rpcService.registerGateway(taskExecutorGateway.getAddress(), (RpcGateway)taskExecutorGateway);
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withResourceId(this.jmResourceId).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).withHeartbeatServices(new HeartbeatServices(1L, 10000L)).createJobMaster();
        jobMaster.start();
        try {
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            CompletableFuture registrationResponse = jobMasterGateway.registerTaskManager(jobGraph.getJobID(), TaskManagerRegistrationInformation.create((String)taskExecutorGateway.getAddress(), (UnresolvedTaskManagerLocation)unresolvedTaskManagerLocation, (UUID)TestingUtils.zeroUUID()), testingTimeout);
            registrationResponse.get();
            MatcherAssert.assertThat(heartbeatResourceIdFuture.join(), (Matcher)Matchers.anyOf((Matcher)Matchers.nullValue(), (Matcher)Matchers.equalTo((Object)this.jmResourceId)));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    @Test
    public void testHeartbeatTimeoutWithTaskManager() throws Exception {
        this.runHeartbeatTest(new TestingTaskExecutorGatewayBuilder().setHeartbeatJobManagerFunction((taskManagerId, ignored) -> FutureUtils.completedVoidFuture()), fastHeartbeatServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runHeartbeatTest(TestingTaskExecutorGatewayBuilder testingTaskExecutorGatewayBuilder, HeartbeatServices heartbeatServices) throws Exception {
        CompletableFuture disconnectedJobManagerFuture = new CompletableFuture();
        LocalUnresolvedTaskManagerLocation unresolvedTaskManagerLocation = new LocalUnresolvedTaskManagerLocation();
        TestingTaskExecutorGateway taskExecutorGateway = testingTaskExecutorGatewayBuilder.setDisconnectJobManagerConsumer((jobId, throwable) -> disconnectedJobManagerFuture.complete(jobId)).createTestingTaskExecutorGateway();
        rpcService.registerGateway(taskExecutorGateway.getAddress(), (RpcGateway)taskExecutorGateway);
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withResourceId(this.jmResourceId).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).withHeartbeatServices(heartbeatServices).createJobMaster();
        jobMaster.start();
        try {
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            CompletableFuture registrationResponse = jobMasterGateway.registerTaskManager(jobGraph.getJobID(), TaskManagerRegistrationInformation.create((String)taskExecutorGateway.getAddress(), (UnresolvedTaskManagerLocation)unresolvedTaskManagerLocation, (UUID)TestingUtils.zeroUUID()), testingTimeout);
            registrationResponse.get();
            JobID disconnectedJobManager = (JobID)disconnectedJobManagerFuture.get(testingTimeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)disconnectedJobManager, (Matcher)Matchers.equalTo((Object)jobGraph.getJobID()));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    @Test
    public void testTaskManagerBecomesUnreachableTriggersDisconnect() throws Exception {
        this.runHeartbeatTest(new TestingTaskExecutorGatewayBuilder().setHeartbeatJobManagerFunction((taskManagerId, ignored) -> FutureUtils.completedExceptionally((Throwable)new RecipientUnreachableException("sender", "recipient", "test heartbeat target is unreachable"))), heartbeatServices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAllocatedSlotReportDoesNotContainStaleInformation() throws Exception {
        CompletableFuture assertionFuture = new CompletableFuture();
        LocalUnresolvedTaskManagerLocation unresolvedTaskManagerLocation = new LocalUnresolvedTaskManagerLocation();
        AtomicBoolean terminateHeartbeatVerification = new AtomicBoolean(false);
        OneShotLatch hasReceivedSlotOffers = new OneShotLatch();
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setHeartbeatJobManagerFunction((taskManagerId, allocatedSlotReport) -> {
            try {
                if (hasReceivedSlotOffers.isTriggered()) {
                    MatcherAssert.assertThat((Object)allocatedSlotReport.getAllocatedSlotInfos(), (Matcher)Matchers.hasSize((int)1));
                } else {
                    MatcherAssert.assertThat((Object)allocatedSlotReport.getAllocatedSlotInfos(), (Matcher)Matchers.empty());
                }
            }
            catch (AssertionError e) {
                assertionFuture.completeExceptionally((Throwable)((Object)e));
            }
            if (terminateHeartbeatVerification.get()) {
                assertionFuture.complete(null);
            }
            return FutureUtils.completedVoidFuture();
        }).createTestingTaskExecutorGateway();
        rpcService.registerGateway(taskExecutorGateway.getAddress(), (RpcGateway)taskExecutorGateway);
        JobManagerSharedServices jobManagerSharedServices = new TestingJobManagerSharedServicesBuilder().build();
        JobGraph jobGraph = JobGraphTestUtils.singleNoOpJobGraph();
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withHeartbeatServices(new HeartbeatServices(5L, 1000L)).withSlotPoolServiceSchedulerFactory((SlotPoolServiceSchedulerFactory)DefaultSlotPoolServiceSchedulerFactory.create((SlotPoolServiceFactory)new TestingSlotPoolFactory(hasReceivedSlotOffers), (SchedulerNGFactory)new DefaultSchedulerFactory())).createJobMaster();
        jobMaster.start();
        try {
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            CompletableFuture registrationResponse = jobMasterGateway.registerTaskManager(jobGraph.getJobID(), TaskManagerRegistrationInformation.create((String)taskExecutorGateway.getAddress(), (UnresolvedTaskManagerLocation)unresolvedTaskManagerLocation, (UUID)TestingUtils.zeroUUID()), testingTimeout);
            registrationResponse.get();
            SlotOffer slotOffer = new SlotOffer(new AllocationID(), 0, ResourceProfile.ANY);
            CompletableFuture slotOfferFuture = jobMasterGateway.offerSlots(unresolvedTaskManagerLocation.getResourceID(), Collections.singleton(slotOffer), testingTimeout);
            MatcherAssert.assertThat(slotOfferFuture.get(), (Matcher)Matchers.containsInAnyOrder((Object[])new SlotOffer[]{slotOffer}));
            terminateHeartbeatVerification.set(true);
            assertionFuture.get();
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
            jobManagerSharedServices.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHeartbeatTimeoutWithResourceManager() throws Exception {
        String resourceManagerAddress = "rm";
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        ResourceID rmResourceId = new ResourceID("rm");
        TestingResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway(resourceManagerId, rmResourceId, "rm", "localhost");
        CompletableFuture jobManagerRegistrationFuture = new CompletableFuture();
        CompletableFuture disconnectedJobManagerFuture = new CompletableFuture();
        CountDownLatch registrationAttempts = new CountDownLatch(2);
        resourceManagerGateway.setRegisterJobManagerFunction((QuadFunction<JobMasterId, ResourceID, String, JobID, CompletableFuture<RegistrationResponse>>)((QuadFunction)(jobMasterId, resourceID, s, jobID) -> {
            jobManagerRegistrationFuture.complete(Tuple3.of((Object)jobMasterId, (Object)resourceID, (Object)jobID));
            registrationAttempts.countDown();
            return CompletableFuture.completedFuture(resourceManagerGateway.getJobMasterRegistrationSuccess());
        }));
        resourceManagerGateway.setDisconnectJobManagerConsumer(tuple -> disconnectedJobManagerFuture.complete(tuple.f0));
        rpcService.registerGateway("rm", (RpcGateway)resourceManagerGateway);
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withJobMasterId(this.jobMasterId).withResourceId(this.jmResourceId).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).withHeartbeatServices(fastHeartbeatServices).createJobMaster();
        jobMaster.start();
        try {
            this.rmLeaderRetrievalService.notifyListener("rm", resourceManagerId.toUUID());
            Tuple3 registrationInformation = (Tuple3)jobManagerRegistrationFuture.get(testingTimeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)registrationInformation.f0, (Matcher)Matchers.equalTo((Object)this.jobMasterId));
            MatcherAssert.assertThat((Object)registrationInformation.f1, (Matcher)Matchers.equalTo((Object)this.jmResourceId));
            MatcherAssert.assertThat((Object)registrationInformation.f2, (Matcher)Matchers.equalTo((Object)jobGraph.getJobID()));
            JobID disconnectedJobManager = (JobID)disconnectedJobManagerFuture.get(testingTimeout.toMilliseconds(), TimeUnit.MILLISECONDS);
            MatcherAssert.assertThat((Object)disconnectedJobManager, (Matcher)Matchers.equalTo((Object)jobGraph.getJobID()));
            registrationAttempts.await();
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceManagerBecomesUnreachableTriggersDisconnect() throws Exception {
        String resourceManagerAddress = "rm";
        ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        ResourceID rmResourceId = new ResourceID("rm");
        TestingResourceManagerGateway resourceManagerGateway = new TestingResourceManagerGateway(resourceManagerId, rmResourceId, "rm", "localhost");
        CompletableFuture disconnectedJobManagerFuture = new CompletableFuture();
        CountDownLatch registrationAttempts = new CountDownLatch(2);
        ArrayDeque connectionResponses = new ArrayDeque(2);
        connectionResponses.add(CompletableFuture.completedFuture(resourceManagerGateway.getJobMasterRegistrationSuccess()));
        connectionResponses.add(new CompletableFuture());
        resourceManagerGateway.setRegisterJobManagerFunction((QuadFunction<JobMasterId, ResourceID, String, JobID, CompletableFuture<RegistrationResponse>>)((QuadFunction)(jobMasterId, resourceID, s, jobID) -> {
            registrationAttempts.countDown();
            return (CompletableFuture)connectionResponses.poll();
        }));
        resourceManagerGateway.setDisconnectJobManagerConsumer(tuple -> disconnectedJobManagerFuture.complete(tuple.f0));
        resourceManagerGateway.setJobMasterHeartbeatFunction(ignored -> FutureUtils.completedExceptionally((Throwable)new RecipientUnreachableException("sender", "recipient", "resource manager is unreachable")));
        rpcService.registerGateway("rm", (RpcGateway)resourceManagerGateway);
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withJobMasterId(this.jobMasterId).withResourceId(this.jmResourceId).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).withHeartbeatServices(heartbeatServices).createJobMaster();
        jobMaster.start();
        try {
            this.rmLeaderRetrievalService.notifyListener("rm", resourceManagerId.toUUID());
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
                jobMasterGateway.heartbeatFromResourceManager(rmResourceId);
                return disconnectedJobManagerFuture.isDone();
            }), 50L);
            MatcherAssert.assertThat(disconnectedJobManagerFuture.join(), (Matcher)Matchers.equalTo((Object)jobGraph.getJobID()));
            registrationAttempts.await();
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRestoringFromSavepoint() throws Exception {
        long savepointId = 42L;
        File savepointFile = this.createSavepoint(42L);
        SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.forPath((String)savepointFile.getAbsolutePath(), (boolean)true);
        JobGraph jobGraph = this.createJobGraphWithCheckpointing(savepointRestoreSettings);
        StandaloneCompletedCheckpointStore completedCheckpointStore = new StandaloneCompletedCheckpointStore(1);
        CheckpointRecoveryFactory testingCheckpointRecoveryFactory = PerJobCheckpointRecoveryFactory.withoutCheckpointStoreRecovery(maxCheckpoints -> completedCheckpointStore);
        this.haServices.setCheckpointRecoveryFactory(testingCheckpointRecoveryFactory);
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withHighAvailabilityServices(this.haServices).createJobMaster();
        try {
            jobMaster.start();
            OneShotLatch taskSubmitLatch = new OneShotLatch();
            this.registerSlotsAtJobMaster(1, (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class), jobGraph.getJobID(), new TestingTaskExecutorGatewayBuilder().setSubmitTaskConsumer((taskDeploymentDescriptor, jobMasterId) -> {
                taskSubmitLatch.trigger();
                return CompletableFuture.completedFuture(Acknowledge.get());
            }).createTestingTaskExecutorGateway(), new LocalUnresolvedTaskManagerLocation());
            taskSubmitLatch.await();
            CompletedCheckpoint savepointCheckpoint = completedCheckpointStore.getLatestCheckpoint();
            MatcherAssert.assertThat((Object)savepointCheckpoint, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)savepointCheckpoint.getCheckpointID(), (Matcher)Matchers.is((Object)42L));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCheckpointPrecedesSavepointRecovery() throws Exception {
        long savepointId = 42L;
        File savepointFile = this.createSavepoint(42L);
        SavepointRestoreSettings savepointRestoreSettings = SavepointRestoreSettings.forPath((String)("" + savepointFile.getAbsolutePath()), (boolean)true);
        JobGraph jobGraph = this.createJobGraphWithCheckpointing(savepointRestoreSettings);
        long checkpointId = 1L;
        CompletedCheckpoint completedCheckpoint = new CompletedCheckpoint(jobGraph.getJobID(), 1L, 1L, 1L, Collections.emptyMap(), null, CheckpointProperties.forCheckpoint((CheckpointRetentionPolicy)CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION), (CompletedCheckpointStorageLocation)new DummyCheckpointStorageLocation(), null);
        StandaloneCompletedCheckpointStore completedCheckpointStore = new StandaloneCompletedCheckpointStore(1);
        completedCheckpointStore.addCheckpointAndSubsumeOldestOne(completedCheckpoint, new CheckpointsCleaner(), () -> {});
        CheckpointRecoveryFactory testingCheckpointRecoveryFactory = PerJobCheckpointRecoveryFactory.withoutCheckpointStoreRecovery(maxCheckpoints -> completedCheckpointStore);
        this.haServices.setCheckpointRecoveryFactory(testingCheckpointRecoveryFactory);
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).createJobMaster();
        try {
            CompletedCheckpoint savepointCheckpoint = completedCheckpointStore.getLatestCheckpoint();
            MatcherAssert.assertThat((Object)savepointCheckpoint, (Matcher)Matchers.notNullValue());
            MatcherAssert.assertThat((Object)savepointCheckpoint.getCheckpointID(), (Matcher)Matchers.is((Object)1L));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCloseUnestablishedResourceManagerConnection() throws Exception {
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).createJobMaster();
        try {
            jobMaster.start();
            TestingResourceManagerGateway firstResourceManagerGateway = this.createAndRegisterTestingResourceManagerGateway();
            TestingResourceManagerGateway secondResourceManagerGateway = this.createAndRegisterTestingResourceManagerGateway();
            OneShotLatch firstJobManagerRegistration = new OneShotLatch();
            OneShotLatch secondJobManagerRegistration = new OneShotLatch();
            firstResourceManagerGateway.setRegisterJobManagerFunction((QuadFunction<JobMasterId, ResourceID, String, JobID, CompletableFuture<RegistrationResponse>>)((QuadFunction)(jobMasterId, resourceID, s, jobID) -> {
                firstJobManagerRegistration.trigger();
                return CompletableFuture.completedFuture(firstResourceManagerGateway.getJobMasterRegistrationSuccess());
            }));
            secondResourceManagerGateway.setRegisterJobManagerFunction((QuadFunction<JobMasterId, ResourceID, String, JobID, CompletableFuture<RegistrationResponse>>)((QuadFunction)(jobMasterId, resourceID, s, jobID) -> {
                secondJobManagerRegistration.trigger();
                return CompletableFuture.completedFuture(secondResourceManagerGateway.getJobMasterRegistrationSuccess());
            }));
            this.notifyResourceManagerLeaderListeners(firstResourceManagerGateway);
            firstJobManagerRegistration.await();
            this.notifyResourceManagerLeaderListeners(secondResourceManagerGateway);
            secondJobManagerRegistration.await();
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReconnectionAfterDisconnect() throws Exception {
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withJobMasterId(this.jobMasterId).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).withHeartbeatServices(heartbeatServices).createJobMaster();
        jobMaster.start();
        JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
        try {
            TestingResourceManagerGateway testingResourceManagerGateway = this.createAndRegisterTestingResourceManagerGateway();
            ArrayBlockingQueue registrationsQueue = new ArrayBlockingQueue(1);
            testingResourceManagerGateway.setRegisterJobManagerFunction((QuadFunction<JobMasterId, ResourceID, String, JobID, CompletableFuture<RegistrationResponse>>)((QuadFunction)(jobMasterId, resourceID, s, jobID) -> {
                registrationsQueue.offer(jobMasterId);
                return CompletableFuture.completedFuture(testingResourceManagerGateway.getJobMasterRegistrationSuccess());
            }));
            ResourceManagerId resourceManagerId = testingResourceManagerGateway.getFencingToken();
            this.notifyResourceManagerLeaderListeners(testingResourceManagerGateway);
            JobMasterId firstRegistrationAttempt = (JobMasterId)registrationsQueue.take();
            MatcherAssert.assertThat((Object)firstRegistrationAttempt, (Matcher)Matchers.equalTo((Object)this.jobMasterId));
            MatcherAssert.assertThat((Object)registrationsQueue.isEmpty(), (Matcher)Matchers.is((Object)true));
            jobMasterGateway.disconnectResourceManager(resourceManagerId, (Exception)new FlinkException("Test exception"));
            MatcherAssert.assertThat(registrationsQueue.take(), (Matcher)Matchers.equalTo((Object)this.jobMasterId));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testResourceManagerConnectionAfterStart() throws Exception {
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withJobMasterId(this.jobMasterId).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).withHeartbeatServices(heartbeatServices).createJobMaster();
        try {
            TestingResourceManagerGateway testingResourceManagerGateway = this.createAndRegisterTestingResourceManagerGateway();
            ArrayBlockingQueue registrationQueue = new ArrayBlockingQueue(1);
            testingResourceManagerGateway.setRegisterJobManagerFunction((QuadFunction<JobMasterId, ResourceID, String, JobID, CompletableFuture<RegistrationResponse>>)((QuadFunction)(jobMasterId, resourceID, s, jobID) -> {
                registrationQueue.offer(jobMasterId);
                return CompletableFuture.completedFuture(testingResourceManagerGateway.getJobMasterRegistrationSuccess());
            }));
            this.notifyResourceManagerLeaderListeners(testingResourceManagerGateway);
            jobMaster.start();
            JobMasterId firstRegistrationAttempt = (JobMasterId)registrationQueue.take();
            MatcherAssert.assertThat((Object)firstRegistrationAttempt, (Matcher)Matchers.equalTo((Object)this.jobMasterId));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    @Test
    @Category(value={FailsWithAdaptiveScheduler.class})
    public void testRequestNextInputSplitWithLocalFailover() throws Exception {
        this.configuration.setString(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY, "region");
        Function<List<List<InputSplit>>, Collection<InputSplit>> expectFailedExecutionInputSplits = inputSplitsPerTask -> (List)inputSplitsPerTask.get(0);
        this.runRequestNextInputSplitTest(expectFailedExecutionInputSplits);
    }

    @Test
    public void testRequestNextInputSplitWithGlobalFailover() throws Exception {
        this.configuration.setInteger(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_ATTEMPTS, 1);
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)Duration.ofSeconds(0L));
        this.configuration.setString(JobManagerOptions.EXECUTION_FAILOVER_STRATEGY, "full");
        Function<List<List<InputSplit>>, Collection<InputSplit>> expectAllRemainingInputSplits = this::flattenCollection;
        this.runRequestNextInputSplitTest(expectAllRemainingInputSplits);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runRequestNextInputSplitTest(Function<List<List<InputSplit>>, Collection<InputSplit>> expectedRemainingInputSplits) throws Exception {
        int parallelism = 2;
        int splitsPerTask = 2;
        int totalSplits = 4;
        ArrayList<TestingInputSplit> allInputSplits = new ArrayList<TestingInputSplit>(4);
        for (int i = 0; i < 4; ++i) {
            allInputSplits.add(new TestingInputSplit(i));
        }
        TestingInputSplitSource inputSplitSource = new TestingInputSplitSource(allInputSplits);
        JobVertex source = new JobVertex("source");
        source.setParallelism(2);
        source.setInputSplitSource((InputSplitSource)inputSplitSource);
        source.setInvokableClass(AbstractInvokable.class);
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)100, (long)0L));
        JobGraph inputSplitJobGraph = JobGraphBuilder.newStreamingJobGraphBuilder().addJobVertex(source).setExecutionConfig(executionConfig).build();
        JobMaster jobMaster = new JobMasterBuilder(inputSplitJobGraph, rpcService).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).withHeartbeatServices(heartbeatServices).createJobMaster();
        jobMaster.start();
        try {
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            JobMasterTest.registerSlotsRequiredForJobExecution(jobMasterGateway, inputSplitJobGraph.getJobID(), 2);
            this.waitUntilAllExecutionsAreScheduledOrDeployed(jobMasterGateway);
            JobVertexID sourceId = source.getID();
            List<AccessExecution> executions = JobMasterTest.getExecutions(jobMasterGateway, sourceId);
            ExecutionAttemptID initialAttemptId = executions.get(0).getAttemptId();
            ArrayList<List<InputSplit>> inputSplitsPerTask = new ArrayList<List<InputSplit>>(2);
            for (AccessExecution execution : executions) {
                inputSplitsPerTask.add(JobMasterTest.getInputSplits(2, this.getInputSplitSupplier(sourceId, jobMasterGateway, execution.getAttemptId())));
            }
            List<InputSplit> allRequestedInputSplits = this.flattenCollection(inputSplitsPerTask);
            MatcherAssert.assertThat(allRequestedInputSplits, (Matcher)Matchers.containsInAnyOrder((Object[])allInputSplits.toArray(EMPTY_TESTING_INPUT_SPLITS)));
            jobMasterGateway.updateTaskExecutionState(new TaskExecutionState(initialAttemptId, ExecutionState.FAILED)).get();
            this.waitUntilAllExecutionsAreScheduledOrDeployed(jobMasterGateway);
            ExecutionAttemptID restartedAttemptId = JobMasterTest.getFirstExecution(jobMasterGateway, sourceId).getAttemptId();
            List<InputSplit> inputSplits = this.getRemainingInputSplits(this.getInputSplitSupplier(sourceId, jobMasterGateway, restartedAttemptId));
            MatcherAssert.assertThat(inputSplits, (Matcher)Matchers.containsInAnyOrder((Object[])expectedRemainingInputSplits.apply(inputSplitsPerTask).toArray(EMPTY_TESTING_INPUT_SPLITS)));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    @Nonnull
    private List<InputSplit> flattenCollection(List<List<InputSplit>> inputSplitsPerTask) {
        return inputSplitsPerTask.stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Nonnull
    private Supplier<SerializedInputSplit> getInputSplitSupplier(JobVertexID jobVertexID, JobMasterGateway jobMasterGateway, ExecutionAttemptID initialAttemptId) {
        return () -> JobMasterTest.getInputSplit(jobMasterGateway, jobVertexID, initialAttemptId);
    }

    private void waitUntilAllExecutionsAreScheduledOrDeployed(JobMasterGateway jobMasterGateway) throws Exception {
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            Collection<AccessExecution> executions = JobMasterTest.getExecutions(jobMasterGateway);
            return !executions.isEmpty() && executions.stream().allMatch(execution -> execution.getState() == ExecutionState.SCHEDULED || execution.getState() == ExecutionState.DEPLOYING);
        }));
    }

    private static AccessExecution getFirstExecution(JobMasterGateway jobMasterGateway, JobVertexID jobVertexId) {
        List<AccessExecution> executions = JobMasterTest.getExecutions(jobMasterGateway, jobVertexId);
        MatcherAssert.assertThat(executions, (Matcher)Matchers.hasSize((Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(1))));
        return executions.get(0);
    }

    private static Collection<AccessExecution> getExecutions(JobMasterGateway jobMasterGateway) {
        ArchivedExecutionGraph archivedExecutionGraph = JobMasterTest.requestExecutionGraph(jobMasterGateway).getArchivedExecutionGraph();
        return archivedExecutionGraph.getAllVertices().values().stream().flatMap(vertex -> Arrays.stream(vertex.getTaskVertices())).map(AccessExecutionVertex::getCurrentExecutionAttempt).collect(Collectors.toList());
    }

    private static List<AccessExecution> getExecutions(JobMasterGateway jobMasterGateway, JobVertexID jobVertexId) {
        ArchivedExecutionGraph archivedExecutionGraph = JobMasterTest.requestExecutionGraph(jobMasterGateway).getArchivedExecutionGraph();
        return Optional.ofNullable(archivedExecutionGraph.getAllVertices().get(jobVertexId)).map(accessExecutionJobVertex -> Arrays.asList(accessExecutionJobVertex.getTaskVertices())).orElse(Collections.emptyList()).stream().map(AccessExecutionVertex::getCurrentExecutionAttempt).collect(Collectors.toList());
    }

    private static ExecutionGraphInfo requestExecutionGraph(JobMasterGateway jobMasterGateway) {
        try {
            return (ExecutionGraphInfo)jobMasterGateway.requestJob(testingTimeout).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    private static List<InputSplit> getInputSplits(int numberInputSplits, Supplier<SerializedInputSplit> nextInputSplit) throws Exception {
        ArrayList<InputSplit> actualInputSplits = new ArrayList<InputSplit>(numberInputSplits);
        for (int i = 0; i < numberInputSplits; ++i) {
            SerializedInputSplit serializedInputSplit = nextInputSplit.get();
            MatcherAssert.assertThat((Object)serializedInputSplit.isEmpty(), (Matcher)Matchers.is((Object)false));
            actualInputSplits.add((InputSplit)InstantiationUtil.deserializeObject((byte[])serializedInputSplit.getInputSplitData(), (ClassLoader)ClassLoader.getSystemClassLoader()));
        }
        return actualInputSplits;
    }

    private List<InputSplit> getRemainingInputSplits(Supplier<SerializedInputSplit> nextInputSplit) throws Exception {
        ArrayList<InputSplit> actualInputSplits = new ArrayList<InputSplit>(16);
        boolean hasMoreInputSplits = true;
        while (hasMoreInputSplits) {
            SerializedInputSplit serializedInputSplit = nextInputSplit.get();
            if (serializedInputSplit.isEmpty()) {
                hasMoreInputSplits = false;
                continue;
            }
            InputSplit inputSplit = (InputSplit)InstantiationUtil.deserializeObject((byte[])serializedInputSplit.getInputSplitData(), (ClassLoader)ClassLoader.getSystemClassLoader());
            if (inputSplit == null) {
                hasMoreInputSplits = false;
                continue;
            }
            actualInputSplits.add(inputSplit);
        }
        return actualInputSplits;
    }

    private static SerializedInputSplit getInputSplit(JobMasterGateway jobMasterGateway, JobVertexID jobVertexId, ExecutionAttemptID attemptId) {
        try {
            return (SerializedInputSplit)jobMasterGateway.requestNextInputSplit(jobVertexId, attemptId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRequestPartitionState() throws Exception {
        JobGraph producerConsumerJobGraph = this.producerConsumerJobGraph();
        JobMaster jobMaster = new JobMasterBuilder(producerConsumerJobGraph, rpcService).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).withHeartbeatServices(heartbeatServices).createJobMaster();
        jobMaster.start();
        try {
            CompletableFuture tddFuture = new CompletableFuture();
            TestingTaskExecutorGateway testingTaskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setSubmitTaskConsumer((taskDeploymentDescriptor, jobMasterId) -> {
                tddFuture.complete(taskDeploymentDescriptor);
                return CompletableFuture.completedFuture(Acknowledge.get());
            }).createTestingTaskExecutorGateway();
            LocalUnresolvedTaskManagerLocation taskManagerLocation = new LocalUnresolvedTaskManagerLocation();
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            Collection<SlotOffer> slotOffers = this.registerSlotsAtJobMaster(1, jobMasterGateway, producerConsumerJobGraph.getJobID(), testingTaskExecutorGateway, taskManagerLocation);
            MatcherAssert.assertThat(slotOffers, (Matcher)Matchers.hasSize((int)1));
            TaskDeploymentDescriptor tdd = (TaskDeploymentDescriptor)tddFuture.get();
            MatcherAssert.assertThat((Object)tdd.getProducedPartitions(), (Matcher)Matchers.hasSize((int)1));
            ResultPartitionDeploymentDescriptor partition = (ResultPartitionDeploymentDescriptor)tdd.getProducedPartitions().iterator().next();
            ExecutionAttemptID executionAttemptId = tdd.getExecutionAttemptId();
            ExecutionAttemptID copiedExecutionAttemptId = new ExecutionAttemptID(executionAttemptId);
            jobMasterGateway.updateTaskExecutionState(new TaskExecutionState(executionAttemptId, ExecutionState.FINISHED)).get();
            ResultPartitionID partitionId = new ResultPartitionID(partition.getPartitionId(), copiedExecutionAttemptId);
            CompletableFuture partitionStateFuture = jobMasterGateway.requestPartitionState(partition.getResultId(), partitionId);
            MatcherAssert.assertThat(partitionStateFuture.get(), (Matcher)Matchers.equalTo((Object)ExecutionState.FINISHED));
            partitionStateFuture = jobMasterGateway.requestPartitionState(partition.getResultId(), new ResultPartitionID());
            try {
                partitionStateFuture.get();
                Assert.fail((String)"Expected failure.");
            }
            catch (ExecutionException e) {
                MatcherAssert.assertThat((Object)ExceptionUtils.findThrowable((Throwable)e, IllegalArgumentException.class).isPresent(), (Matcher)Matchers.is((Object)true));
            }
            partitionStateFuture = jobMasterGateway.requestPartitionState(new IntermediateDataSetID(), partitionId);
            try {
                partitionStateFuture.get();
                Assert.fail((String)"Expected failure.");
            }
            catch (ExecutionException e) {
                MatcherAssert.assertThat((Object)ExceptionUtils.findThrowable((Throwable)e, IllegalArgumentException.class).isPresent(), (Matcher)Matchers.is((Object)true));
            }
            partitionStateFuture = jobMasterGateway.requestPartitionState(partition.getResultId(), new ResultPartitionID(partition.getPartitionId(), new ExecutionAttemptID()));
            try {
                partitionStateFuture.get();
                Assert.fail((String)"Expected failure.");
            }
            catch (ExecutionException e) {
                MatcherAssert.assertThat((Object)ExceptionUtils.findThrowable((Throwable)e, PartitionProducerDisposedException.class).isPresent(), (Matcher)Matchers.is((Object)true));
            }
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    private void notifyResourceManagerLeaderListeners(TestingResourceManagerGateway testingResourceManagerGateway) {
        this.rmLeaderRetrievalService.notifyListener(testingResourceManagerGateway.getAddress(), testingResourceManagerGateway.getFencingToken().toUUID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTriggerSavepointTimeout() throws Exception {
        TestingSchedulerNG testingSchedulerNG = TestingSchedulerNG.newBuilder().setTriggerSavepointFunction((TriFunction<String, Boolean, SavepointFormatType, CompletableFuture<String>>)((TriFunction)(ignoredA, ignoredB, formatType) -> new CompletableFuture())).build();
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withFatalErrorHandler(this.testingFatalErrorHandler).withSlotPoolServiceSchedulerFactory((SlotPoolServiceSchedulerFactory)DefaultSlotPoolServiceSchedulerFactory.create((SlotPoolServiceFactory)TestingSlotPoolServiceBuilder.newBuilder(), (SchedulerNGFactory)new TestingSchedulerNGFactory(testingSchedulerNG))).createJobMaster();
        try {
            jobMaster.start();
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            CompletableFuture savepointFutureLowTimeout = jobMasterGateway.triggerSavepoint("/tmp", false, SavepointFormatType.CANONICAL, Time.milliseconds((long)1L));
            CompletableFuture savepointFutureHighTimeout = jobMasterGateway.triggerSavepoint("/tmp", false, SavepointFormatType.CANONICAL, RpcUtils.INF_TIMEOUT);
            try {
                savepointFutureLowTimeout.get(testingTimeout.getSize(), testingTimeout.getUnit());
                Assert.fail();
            }
            catch (ExecutionException e) {
                Throwable cause = ExceptionUtils.stripExecutionException((Throwable)e);
                MatcherAssert.assertThat((Object)cause, (Matcher)Matchers.instanceOf(TimeoutException.class));
            }
            MatcherAssert.assertThat((Object)savepointFutureHighTimeout.isDone(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)false)));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReleasingTaskExecutorIfNoMoreSlotsRegistered() throws Exception {
        JobGraph jobGraph = this.createSingleVertexJobWithRestartStrategy();
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).withHeartbeatServices(heartbeatServices).createJobMaster();
        CompletableFuture disconnectTaskExecutorFuture = new CompletableFuture();
        CompletableFuture freedSlotFuture = new CompletableFuture();
        TestingTaskExecutorGateway testingTaskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setFreeSlotFunction((allocationID, throwable) -> {
            freedSlotFuture.complete(allocationID);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).setDisconnectJobManagerConsumer((jobID, throwable) -> disconnectTaskExecutorFuture.complete(jobID)).createTestingTaskExecutorGateway();
        LocalUnresolvedTaskManagerLocation taskManagerLocation = new LocalUnresolvedTaskManagerLocation();
        try {
            jobMaster.start();
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            Collection<SlotOffer> slotOffers = this.registerSlotsAtJobMaster(1, jobMasterGateway, jobGraph.getJobID(), testingTaskExecutorGateway, taskManagerLocation);
            MatcherAssert.assertThat(slotOffers, (Matcher)Matchers.hasSize((int)1));
            AllocationID allocationId = slotOffers.iterator().next().getAllocationId();
            jobMasterGateway.failSlot(taskManagerLocation.getResourceID(), allocationId, (Exception)new FlinkException("Fail allocation test exception"));
            MatcherAssert.assertThat(freedSlotFuture.get(), (Matcher)Matchers.equalTo((Object)allocationId));
            MatcherAssert.assertThat(disconnectTaskExecutorFuture.get(), (Matcher)Matchers.equalTo((Object)jobGraph.getJobID()));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testTaskExecutorNotReleasedOnFailedAllocationIfPartitionIsAllocated() throws Exception {
        JobManagerSharedServices jobManagerSharedServices = new TestingJobManagerSharedServicesBuilder().build();
        JobGraph jobGraph = JobGraphTestUtils.singleNoOpJobGraph();
        LocalUnresolvedTaskManagerLocation taskManagerUnresolvedLocation = new LocalUnresolvedTaskManagerLocation();
        AtomicBoolean isTrackingPartitions = new AtomicBoolean(true);
        TestingJobMasterPartitionTracker partitionTracker = new TestingJobMasterPartitionTracker();
        partitionTracker.setIsTrackingPartitionsForFunction(ignored -> isTrackingPartitions.get());
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).withJobManagerSharedServices(jobManagerSharedServices).withHeartbeatServices(heartbeatServices).withPartitionTrackerFactory(ignored -> partitionTracker).createJobMaster();
        CompletableFuture disconnectTaskExecutorFuture = new CompletableFuture();
        CompletableFuture freedSlotFuture = new CompletableFuture();
        TestingTaskExecutorGateway testingTaskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setFreeSlotFunction((allocationID, throwable) -> {
            freedSlotFuture.complete(allocationID);
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).setDisconnectJobManagerConsumer((jobID, throwable) -> disconnectTaskExecutorFuture.complete(jobID)).createTestingTaskExecutorGateway();
        try {
            jobMaster.start();
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            Collection<SlotOffer> slotOffers = this.registerSlotsAtJobMaster(1, jobMasterGateway, jobGraph.getJobID(), testingTaskExecutorGateway, taskManagerUnresolvedLocation);
            MatcherAssert.assertThat(slotOffers, (Matcher)Matchers.hasSize((int)1));
            AllocationID allocationId = slotOffers.iterator().next().getAllocationId();
            jobMasterGateway.failSlot(taskManagerUnresolvedLocation.getResourceID(), allocationId, (Exception)new FlinkException("Fail allocation test exception"));
            MatcherAssert.assertThat(freedSlotFuture.get(), (Matcher)Matchers.equalTo((Object)allocationId));
            jobMasterGateway.requestJobStatus(Time.seconds((long)5L)).get();
            MatcherAssert.assertThat((Object)disconnectTaskExecutorFuture.isDone(), (Matcher)Matchers.is((Object)false));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobMasterAggregatesValuesCorrectly() throws Exception {
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withConfiguration(this.configuration).withHighAvailabilityServices(this.haServices).withHeartbeatServices(heartbeatServices).createJobMaster();
        jobMaster.start();
        JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
        try {
            AggregateFunction<Integer, Integer, Integer> aggregateFunction = this.createAggregateFunction();
            ClosureCleaner.clean(aggregateFunction, (ExecutionConfig.ClosureCleanerLevel)ExecutionConfig.ClosureCleanerLevel.RECURSIVE, (boolean)true);
            byte[] serializedAggregateFunction = InstantiationUtil.serializeObject(aggregateFunction);
            CompletableFuture updateAggregateFuture = jobMasterGateway.updateGlobalAggregate("agg1", (Object)1, serializedAggregateFunction);
            MatcherAssert.assertThat(updateAggregateFuture.get(), (Matcher)Matchers.equalTo((Object)1));
            updateAggregateFuture = jobMasterGateway.updateGlobalAggregate("agg1", (Object)2, serializedAggregateFunction);
            MatcherAssert.assertThat(updateAggregateFuture.get(), (Matcher)Matchers.equalTo((Object)3));
            updateAggregateFuture = jobMasterGateway.updateGlobalAggregate("agg1", (Object)3, serializedAggregateFunction);
            MatcherAssert.assertThat(updateAggregateFuture.get(), (Matcher)Matchers.equalTo((Object)6));
            updateAggregateFuture = jobMasterGateway.updateGlobalAggregate("agg1", (Object)4, serializedAggregateFunction);
            MatcherAssert.assertThat(updateAggregateFuture.get(), (Matcher)Matchers.equalTo((Object)10));
            updateAggregateFuture = jobMasterGateway.updateGlobalAggregate("agg2", (Object)10, serializedAggregateFunction);
            MatcherAssert.assertThat(updateAggregateFuture.get(), (Matcher)Matchers.equalTo((Object)10));
            updateAggregateFuture = jobMasterGateway.updateGlobalAggregate("agg2", (Object)23, serializedAggregateFunction);
            MatcherAssert.assertThat(updateAggregateFuture.get(), (Matcher)Matchers.equalTo((Object)33));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    private AggregateFunction<Integer, Integer, Integer> createAggregateFunction() {
        return new AggregateFunction<Integer, Integer, Integer>(){

            public Integer createAccumulator() {
                return 0;
            }

            public Integer add(Integer value, Integer accumulator) {
                return accumulator + value;
            }

            public Integer getResult(Integer accumulator) {
                return accumulator;
            }

            public Integer merge(Integer a, Integer b) {
                return this.add(a, b);
            }
        };
    }

    @Nonnull
    private TestingResourceManagerGateway createAndRegisterTestingResourceManagerGateway() {
        TestingResourceManagerGateway testingResourceManagerGateway = new TestingResourceManagerGateway();
        rpcService.registerGateway(testingResourceManagerGateway.getAddress(), (RpcGateway)testingResourceManagerGateway);
        return testingResourceManagerGateway;
    }

    @Test
    public void testJobFailureWhenGracefulTaskExecutorTermination() throws Exception {
        this.runJobFailureWhenTaskExecutorTerminatesTest(heartbeatServices, (localTaskManagerLocation, jobMasterGateway) -> jobMasterGateway.disconnectTaskManager(localTaskManagerLocation.getResourceID(), (Exception)new FlinkException("Test disconnectTaskManager exception.")));
    }

    @Test
    public void testJobFailureWhenTaskExecutorHeartbeatTimeout() throws Exception {
        TestingHeartbeatServices testingHeartbeatService = new TestingHeartbeatServices(1000L, 5000000L);
        this.runJobFailureWhenTaskExecutorTerminatesTest(testingHeartbeatService, (localTaskManagerLocation, jobMasterGateway) -> testingHeartbeatService.triggerHeartbeatTimeout(this.jmResourceId, localTaskManagerLocation.getResourceID()));
    }

    @Test
    public void testJobMasterRejectsTaskExecutorRegistrationIfJobIdsAreNotEqual() throws Exception {
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).createJobMaster();
        try {
            jobMaster.start();
            CompletableFuture registrationResponse = jobMaster.registerTaskManager(new JobID(), TaskManagerRegistrationInformation.create((String)"foobar", (UnresolvedTaskManagerLocation)new LocalUnresolvedTaskManagerLocation(), (UUID)TestingUtils.zeroUUID()), testingTimeout);
            MatcherAssert.assertThat(registrationResponse.get(), (Matcher)Matchers.instanceOf(JMTMRegistrationRejection.class));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobMasterAcknowledgesDuplicateTaskExecutorRegistrations() throws Exception {
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).createJobMaster();
        TestingTaskExecutorGateway testingTaskExecutorGateway = new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway();
        rpcService.registerGateway(testingTaskExecutorGateway.getAddress(), (RpcGateway)testingTaskExecutorGateway);
        try {
            jobMaster.start();
            TaskManagerRegistrationInformation taskManagerRegistrationInformation = TaskManagerRegistrationInformation.create((String)testingTaskExecutorGateway.getAddress(), (UnresolvedTaskManagerLocation)new LocalUnresolvedTaskManagerLocation(), (UUID)UUID.randomUUID());
            CompletableFuture firstRegistrationResponse = jobMaster.registerTaskManager(jobGraph.getJobID(), taskManagerRegistrationInformation, testingTimeout);
            CompletableFuture secondRegistrationResponse = jobMaster.registerTaskManager(jobGraph.getJobID(), taskManagerRegistrationInformation, testingTimeout);
            MatcherAssert.assertThat(firstRegistrationResponse.get(), (Matcher)Matchers.instanceOf(JMTMRegistrationSuccess.class));
            MatcherAssert.assertThat(secondRegistrationResponse.get(), (Matcher)Matchers.instanceOf(JMTMRegistrationSuccess.class));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobMasterDisconnectsOldTaskExecutorIfNewSessionIsSeen() throws Exception {
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).createJobMaster();
        CompletableFuture firstTaskExecutorDisconnectedFuture = new CompletableFuture();
        TestingTaskExecutorGateway firstTaskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setAddress("firstTaskExecutor").setDisconnectJobManagerConsumer((jobID, throwable) -> firstTaskExecutorDisconnectedFuture.complete(null)).createTestingTaskExecutorGateway();
        TestingTaskExecutorGateway secondTaskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setAddress("secondTaskExecutor").createTestingTaskExecutorGateway();
        rpcService.registerGateway(firstTaskExecutorGateway.getAddress(), (RpcGateway)firstTaskExecutorGateway);
        rpcService.registerGateway(secondTaskExecutorGateway.getAddress(), (RpcGateway)secondTaskExecutorGateway);
        try {
            jobMaster.start();
            LocalUnresolvedTaskManagerLocation taskManagerLocation = new LocalUnresolvedTaskManagerLocation();
            UUID firstTaskManagerSessionId = UUID.randomUUID();
            CompletableFuture firstRegistrationResponse = jobMaster.registerTaskManager(jobGraph.getJobID(), TaskManagerRegistrationInformation.create((String)firstTaskExecutorGateway.getAddress(), (UnresolvedTaskManagerLocation)taskManagerLocation, (UUID)firstTaskManagerSessionId), testingTimeout);
            MatcherAssert.assertThat(firstRegistrationResponse.get(), (Matcher)Matchers.instanceOf(JMTMRegistrationSuccess.class));
            UUID secondTaskManagerSessionId = UUID.randomUUID();
            CompletableFuture secondRegistrationResponse = jobMaster.registerTaskManager(jobGraph.getJobID(), TaskManagerRegistrationInformation.create((String)secondTaskExecutorGateway.getAddress(), (UnresolvedTaskManagerLocation)taskManagerLocation, (UUID)secondTaskManagerSessionId), testingTimeout);
            MatcherAssert.assertThat(secondRegistrationResponse.get(), (Matcher)Matchers.instanceOf(JMTMRegistrationSuccess.class));
            firstTaskExecutorDisconnectedFuture.get();
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    @Test
    public void testJobMasterOnlyTerminatesAfterTheSchedulerHasClosed() throws Exception {
        CompletableFuture<Object> schedulerTerminationFuture = new CompletableFuture<Object>();
        TestingSchedulerNG testingSchedulerNG = TestingSchedulerNG.newBuilder().setCloseAsyncSupplier(() -> schedulerTerminationFuture).build();
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withSlotPoolServiceSchedulerFactory((SlotPoolServiceSchedulerFactory)DefaultSlotPoolServiceSchedulerFactory.create((SlotPoolServiceFactory)TestingSlotPoolServiceBuilder.newBuilder(), (SchedulerNGFactory)new TestingSchedulerNGFactory(testingSchedulerNG))).createJobMaster();
        jobMaster.start();
        CompletableFuture jobMasterTerminationFuture = jobMaster.closeAsync();
        try {
            jobMasterTerminationFuture.get(10L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected TimeoutException because the JobMaster should not terminate.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        schedulerTerminationFuture.complete(null);
        jobMasterTerminationFuture.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJobMasterAcceptsSlotsWhenJobIsRestarting() throws Exception {
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY, (Object)"fixed-delay");
        this.configuration.set(RestartStrategyOptions.RESTART_STRATEGY_FIXED_DELAY_DELAY, (Object)Duration.ofDays(1L));
        boolean numberSlots = true;
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withConfiguration(this.configuration).createJobMaster();
        try {
            jobMaster.start();
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            LocalUnresolvedTaskManagerLocation unresolvedTaskManagerLocation = new LocalUnresolvedTaskManagerLocation();
            this.registerSlotsAtJobMaster(1, jobMasterGateway, jobGraph.getJobID(), new TestingTaskExecutorGatewayBuilder().setAddress("firstTaskManager").createTestingTaskExecutorGateway(), unresolvedTaskManagerLocation);
            CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> jobMasterGateway.requestJobStatus(testingTimeout).get() == JobStatus.RUNNING));
            jobMasterGateway.disconnectTaskManager(unresolvedTaskManagerLocation.getResourceID(), (Exception)new FlinkException("Test exception."));
            CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> jobMasterGateway.requestJobStatus(testingTimeout).get() == JobStatus.RESTARTING));
            MatcherAssert.assertThat(this.registerSlotsAtJobMaster(1, jobMasterGateway, jobGraph.getJobID(), new TestingTaskExecutorGatewayBuilder().setAddress("secondTaskManager").createTestingTaskExecutorGateway(), new LocalUnresolvedTaskManagerLocation()), (Matcher)Matchers.hasSize((int)1));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJobFailureWhenTaskExecutorTerminatesTest(HeartbeatServices heartbeatServices, BiConsumer<LocalUnresolvedTaskManagerLocation, JobMasterGateway> jobReachedRunningState) throws Exception {
        JobGraph jobGraph = JobGraphTestUtils.singleNoOpJobGraph();
        JobMasterBuilder.TestingOnCompletionActions onCompletionActions = new JobMasterBuilder.TestingOnCompletionActions();
        JobMaster jobMaster = new JobMasterBuilder(jobGraph, rpcService).withResourceId(this.jmResourceId).withHighAvailabilityServices(this.haServices).withHeartbeatServices(heartbeatServices).withOnCompletionActions(onCompletionActions).createJobMaster();
        try {
            jobMaster.start();
            JobMasterGateway jobMasterGateway = (JobMasterGateway)jobMaster.getSelfGateway(JobMasterGateway.class);
            LocalUnresolvedTaskManagerLocation taskManagerUnresolvedLocation = new LocalUnresolvedTaskManagerLocation();
            CompletableFuture taskDeploymentFuture = new CompletableFuture();
            TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setSubmitTaskConsumer((taskDeploymentDescriptor, jobMasterId) -> {
                taskDeploymentFuture.complete(taskDeploymentDescriptor.getExecutionAttemptId());
                return CompletableFuture.completedFuture(Acknowledge.get());
            }).createTestingTaskExecutorGateway();
            Collection<SlotOffer> slotOffers = this.registerSlotsAtJobMaster(1, jobMasterGateway, jobGraph.getJobID(), taskExecutorGateway, taskManagerUnresolvedLocation);
            MatcherAssert.assertThat(slotOffers, (Matcher)Matchers.hasSize((int)1));
            ExecutionAttemptID executionAttemptId = (ExecutionAttemptID)taskDeploymentFuture.get();
            jobMasterGateway.updateTaskExecutionState(new TaskExecutionState(executionAttemptId, ExecutionState.INITIALIZING)).get();
            jobMasterGateway.updateTaskExecutionState(new TaskExecutionState(executionAttemptId, ExecutionState.RUNNING)).get();
            jobReachedRunningState.accept(taskManagerUnresolvedLocation, jobMasterGateway);
            ArchivedExecutionGraph archivedExecutionGraph = onCompletionActions.getJobReachedGloballyTerminalStateFuture().get().getArchivedExecutionGraph();
            MatcherAssert.assertThat((Object)archivedExecutionGraph.getState(), (Matcher)Matchers.is((Object)JobStatus.FAILED));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)jobMaster, (Time)testingTimeout);
        }
    }

    private Collection<SlotOffer> registerSlotsAtJobMaster(int numberSlots, JobMasterGateway jobMasterGateway, JobID jobId, TaskExecutorGateway taskExecutorGateway, UnresolvedTaskManagerLocation unresolvedTaskManagerLocation) throws ExecutionException, InterruptedException {
        rpcService.registerGateway(taskExecutorGateway.getAddress(), (RpcGateway)taskExecutorGateway);
        jobMasterGateway.registerTaskManager(jobId, TaskManagerRegistrationInformation.create((String)taskExecutorGateway.getAddress(), (UnresolvedTaskManagerLocation)unresolvedTaskManagerLocation, (UUID)TestingUtils.zeroUUID()), testingTimeout).get();
        Collection slotOffers = IntStream.range(0, numberSlots).mapToObj(index -> new SlotOffer(new AllocationID(), index, ResourceProfile.ANY)).collect(Collectors.toList());
        return (Collection)jobMasterGateway.offerSlots(unresolvedTaskManagerLocation.getResourceID(), slotOffers, testingTimeout).get();
    }

    private JobGraph producerConsumerJobGraph() {
        JobVertex producer = new JobVertex("Producer");
        producer.setInvokableClass(NoOpInvokable.class);
        JobVertex consumer = new JobVertex("Consumer");
        consumer.setInvokableClass(NoOpInvokable.class);
        consumer.connectNewDataSetAsInput(producer, DistributionPattern.POINTWISE, ResultPartitionType.BLOCKING);
        return JobGraphTestUtils.batchJobGraph(producer, consumer);
    }

    private File createSavepoint(long savepointId) throws IOException {
        return TestUtils.createSavepointWithOperatorState(temporaryFolder.newFile(), savepointId, new OperatorID[0]);
    }

    @Nonnull
    private JobGraph createJobGraphWithCheckpointing(SavepointRestoreSettings savepointRestoreSettings) {
        JobVertex source = new JobVertex("source");
        source.setInvokableClass(NoOpInvokable.class);
        source.setParallelism(1);
        return TestUtils.createJobGraphFromJobVerticesWithCheckpointing(savepointRestoreSettings, source);
    }

    private JobGraph createSingleVertexJobWithRestartStrategy() throws IOException {
        JobGraph jobGraph = JobGraphTestUtils.singleNoOpJobGraph();
        ExecutionConfig executionConfig = new ExecutionConfig();
        executionConfig.setRestartStrategy(RestartStrategies.fixedDelayRestart((int)Integer.MAX_VALUE, (long)0L));
        jobGraph.setExecutionConfig(executionConfig);
        return jobGraph;
    }

    private static void registerSlotsRequiredForJobExecution(JobMasterGateway jobMasterGateway, JobID jobId, int numSlots) throws ExecutionException, InterruptedException {
        TestingTaskExecutorGateway taskExecutorGateway = new TestingTaskExecutorGatewayBuilder().setCancelTaskFunction(executionAttemptId -> {
            jobMasterGateway.updateTaskExecutionState(new TaskExecutionState(executionAttemptId, ExecutionState.CANCELED));
            return CompletableFuture.completedFuture(Acknowledge.get());
        }).createTestingTaskExecutorGateway();
        JobMasterTestUtils.registerTaskExecutorAndOfferSlots(rpcService, jobMasterGateway, jobId, numSlots, taskExecutorGateway, testingTimeout);
    }

    private static final class DummyCheckpointStorageLocation
    implements CompletedCheckpointStorageLocation {
        private static final long serialVersionUID = 164095949572620688L;

        private DummyCheckpointStorageLocation() {
        }

        public String getExternalPointer() {
            return null;
        }

        public StreamStateHandle getMetadataHandle() {
            return null;
        }

        public void disposeStorageLocation() throws IOException {
        }
    }

    private static final class TestingInputSplit
    implements InputSplit {
        private static final long serialVersionUID = -5404803705463116083L;
        private final int splitNumber;

        TestingInputSplit(int number) {
            this.splitNumber = number;
        }

        public int getSplitNumber() {
            return this.splitNumber;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TestingInputSplit that = (TestingInputSplit)o;
            return this.splitNumber == that.splitNumber;
        }

        public int hashCode() {
            return Objects.hash(this.splitNumber);
        }
    }

    private static final class TestingInputSplitSource
    implements InputSplitSource<TestingInputSplit> {
        private static final long serialVersionUID = -2344684048759139086L;
        private final List<TestingInputSplit> inputSplits;

        private TestingInputSplitSource(List<TestingInputSplit> inputSplits) {
            this.inputSplits = inputSplits;
        }

        public TestingInputSplit[] createInputSplits(int minNumSplits) {
            return this.inputSplits.toArray(EMPTY_TESTING_INPUT_SPLITS);
        }

        public InputSplitAssigner getInputSplitAssigner(TestingInputSplit[] inputSplits) {
            return new DefaultInputSplitAssigner((InputSplit[])inputSplits);
        }
    }

    private static final class TestingSlotPool
    implements SlotPool,
    SlotPoolService {
        private final JobID jobId;
        private final OneShotLatch hasReceivedSlotOffers;
        private final Map<ResourceID, Collection<SlotInfo>> registeredSlots;

        private TestingSlotPool(JobID jobId, OneShotLatch hasReceivedSlotOffers) {
            this.jobId = jobId;
            this.hasReceivedSlotOffers = hasReceivedSlotOffers;
            this.registeredSlots = new HashMap<ResourceID, Collection<SlotInfo>>(16);
        }

        public void start(JobMasterId jobMasterId, String newJobManagerAddress, ComponentMainThreadExecutor jmMainThreadScheduledExecutor) {
        }

        public void close() {
            this.clear();
        }

        private void clear() {
            this.registeredSlots.clear();
        }

        public void connectToResourceManager(ResourceManagerGateway resourceManagerGateway) {
            throw new UnsupportedOperationException("TestingSlotPool does not support this operation.");
        }

        public void disconnectResourceManager() {
            throw new UnsupportedOperationException("TestingSlotPool does not support this operation.");
        }

        public boolean registerTaskManager(ResourceID resourceID) {
            this.registeredSlots.computeIfAbsent(resourceID, ignored -> new ArrayList(16));
            return true;
        }

        public boolean releaseTaskManager(ResourceID resourceId, Exception cause) {
            this.registeredSlots.remove(resourceId);
            return true;
        }

        public Collection<SlotOffer> offerSlots(TaskManagerLocation taskManagerLocation, TaskManagerGateway taskManagerGateway, Collection<SlotOffer> offers) {
            this.hasReceivedSlotOffers.trigger();
            Collection<SlotInfo> slotInfos = Optional.ofNullable(this.registeredSlots.get(taskManagerLocation.getResourceID())).orElseThrow(() -> new FlinkRuntimeException("TaskManager not registered."));
            int slotIndex = slotInfos.size();
            for (SlotOffer offer : offers) {
                slotInfos.add((SlotInfo)new SimpleSlotContext(offer.getAllocationId(), taskManagerLocation, slotIndex, taskManagerGateway));
                ++slotIndex;
            }
            return offers;
        }

        public Optional<ResourceID> failAllocation(@Nullable ResourceID resourceID, AllocationID allocationId, Exception cause) {
            throw new UnsupportedOperationException("TestingSlotPool does not support this operation.");
        }

        @Nonnull
        public Collection<SlotInfoWithUtilization> getAvailableSlotsInformation() {
            Collection allSlotInfos = this.registeredSlots.values().stream().flatMap(Collection::stream).map(slot -> SlotInfoWithUtilization.from((SlotInfo)slot, (double)0.0)).collect(Collectors.toList());
            return Collections.unmodifiableCollection(allSlotInfos);
        }

        public Collection<SlotInfo> getAllocatedSlotsInformation() {
            return Collections.emptyList();
        }

        public Optional<PhysicalSlot> allocateAvailableSlot(@Nonnull SlotRequestId slotRequestId, @Nonnull AllocationID allocationID, @Nonnull ResourceProfile requirementProfile) {
            throw new UnsupportedOperationException("TestingSlotPool does not support this operation.");
        }

        @Nonnull
        public CompletableFuture<PhysicalSlot> requestNewAllocatedSlot(@Nonnull SlotRequestId slotRequestId, @Nonnull ResourceProfile resourceProfile, @Nonnull Collection<AllocationID> preferredAllocations, @Nullable Time timeout) {
            return new CompletableFuture<PhysicalSlot>();
        }

        @Nonnull
        public CompletableFuture<PhysicalSlot> requestNewAllocatedBatchSlot(@Nonnull SlotRequestId slotRequestId, @Nonnull ResourceProfile resourceProfile, @Nonnull Collection<AllocationID> preferredAllocations) {
            return new CompletableFuture<PhysicalSlot>();
        }

        public void disableBatchSlotRequestTimeoutCheck() {
        }

        public AllocatedSlotReport createAllocatedSlotReport(ResourceID taskManagerId) {
            Collection slotInfos = this.registeredSlots.getOrDefault(taskManagerId, Collections.emptyList());
            List allocatedSlotInfos = slotInfos.stream().map(slotInfo -> new AllocatedSlotInfo(slotInfo.getPhysicalSlotNumber(), slotInfo.getAllocationId())).collect(Collectors.toList());
            return new AllocatedSlotReport(this.jobId, allocatedSlotInfos);
        }

        public void setIsJobRestarting(boolean isJobRestarting) {
        }

        public void releaseSlot(@Nonnull SlotRequestId slotRequestId, @Nullable Throwable cause) {
            throw new UnsupportedOperationException("TestingSlotPool does not support this operation.");
        }
    }

    private static final class TestingSlotPoolFactory
    implements SlotPoolServiceFactory {
        private final OneShotLatch hasReceivedSlotOffers;

        public TestingSlotPoolFactory(OneShotLatch hasReceivedSlotOffers) {
            this.hasReceivedSlotOffers = hasReceivedSlotOffers;
        }

        @Nonnull
        public SlotPoolService createSlotPoolService(@Nonnull JobID jobId) {
            return new TestingSlotPool(jobId, this.hasReceivedSlotOffers);
        }
    }
}

