/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph.failover.flip1;

import java.util.concurrent.TimeUnit;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailureRateRestartBackoffTimeStrategy;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.junit.Assert;
import org.junit.Test;

public class FailureRateRestartBackoffTimeStrategyTest
extends TestLogger {
    private final Exception failure = new Exception();

    @Test
    public void testManyFailuresWithinRate() {
        int numFailures = 3;
        long intervalMS = 1L;
        ManualClock clock = new ManualClock();
        FailureRateRestartBackoffTimeStrategy restartStrategy = new FailureRateRestartBackoffTimeStrategy((Clock)clock, 1, 1L, 0L);
        for (int failuresLeft = 3; failuresLeft > 0; --failuresLeft) {
            restartStrategy.notifyFailure((Throwable)this.failure);
            Assert.assertTrue((boolean)restartStrategy.canRestart());
            clock.advanceTime(2L, TimeUnit.MILLISECONDS);
        }
        Assert.assertTrue((boolean)restartStrategy.canRestart());
    }

    @Test
    public void testFailuresExceedingRate() {
        int numFailures = 3;
        long intervalMS = 10000L;
        FailureRateRestartBackoffTimeStrategy restartStrategy = new FailureRateRestartBackoffTimeStrategy((Clock)new ManualClock(), 3, 10000L, 0L);
        for (int failuresLeft = 3; failuresLeft > 0; --failuresLeft) {
            restartStrategy.notifyFailure((Throwable)this.failure);
            Assert.assertTrue((boolean)restartStrategy.canRestart());
        }
        restartStrategy.notifyFailure((Throwable)this.failure);
        Assert.assertFalse((boolean)restartStrategy.canRestart());
    }

    @Test
    public void testBackoffTime() {
        long backoffTimeMS = 10000L;
        FailureRateRestartBackoffTimeStrategy restartStrategy = new FailureRateRestartBackoffTimeStrategy((Clock)new ManualClock(), 1, 1L, 10000L);
        Assert.assertEquals((long)10000L, (long)restartStrategy.getBackoffTime());
    }
}

