/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.dispatcher;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple4;
import org.apache.flink.configuration.RestOptions;
import org.apache.flink.core.execution.SavepointFormatType;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.dispatcher.DispatcherCachedOperationsHandler;
import org.apache.flink.runtime.dispatcher.TriggerSavepointFunction;
import org.apache.flink.runtime.dispatcher.TriggerSavepointMode;
import org.apache.flink.runtime.dispatcher.UnknownOperationKeyException;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.rest.handler.async.CompletedOperationCache;
import org.apache.flink.runtime.rest.handler.async.OperationResult;
import org.apache.flink.runtime.rest.handler.job.AsynchronousJobOperationKey;
import org.apache.flink.runtime.rest.messages.TriggerId;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DispatcherCachedOperationsHandlerTest
extends TestLogger {
    private static final Time TIMEOUT = Time.minutes((long)10L);
    private CompletedOperationCache<AsynchronousJobOperationKey, String> cache;
    private DispatcherCachedOperationsHandler handler;
    private TriggerSavepointSpyFunction triggerSavepointFunction;
    private TriggerSavepointSpyFunction stopWithSavepointFunction;
    private CompletableFuture<String> savepointLocationFuture = new CompletableFuture();
    private final JobID jobID = new JobID();
    private final String targetDirectory = "dummyDirectory";
    private AsynchronousJobOperationKey operationKey;

    @BeforeEach
    public void setup() {
        this.savepointLocationFuture = new CompletableFuture();
        this.triggerSavepointFunction = TriggerSavepointSpyFunction.wrap((jobID, targetDirectory, formatType, savepointMode, timeout) -> this.savepointLocationFuture);
        this.stopWithSavepointFunction = TriggerSavepointSpyFunction.wrap((jobID, targetDirectory, formatType, savepointMode, timeout) -> this.savepointLocationFuture);
        this.cache = new CompletedOperationCache((Duration)RestOptions.ASYNC_OPERATION_STORE_DURATION.defaultValue());
        this.handler = new DispatcherCachedOperationsHandler((TriggerSavepointFunction)this.triggerSavepointFunction, (TriggerSavepointFunction)this.stopWithSavepointFunction, this.cache);
        this.operationKey = AsynchronousJobOperationKey.of((TriggerId)new TriggerId(), (JobID)this.jobID);
    }

    @Test
    public void triggerSavepointRepeatedly() throws ExecutionException, InterruptedException {
        CompletableFuture firstAcknowledge = this.handler.triggerSavepoint(this.operationKey, "dummyDirectory", SavepointFormatType.CANONICAL, TriggerSavepointMode.SAVEPOINT, TIMEOUT);
        CompletableFuture secondAcknowledge = this.handler.triggerSavepoint(this.operationKey, "dummyDirectory", SavepointFormatType.CANONICAL, TriggerSavepointMode.SAVEPOINT, TIMEOUT);
        MatcherAssert.assertThat((Object)this.triggerSavepointFunction.getNumberOfInvocations(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.triggerSavepointFunction.getInvocationParameters().get(0), (Matcher)Is.is((Object)new Tuple4((Object)this.jobID, (Object)"dummyDirectory", (Object)SavepointFormatType.CANONICAL, (Object)TriggerSavepointMode.SAVEPOINT)));
        MatcherAssert.assertThat(firstAcknowledge.get(), (Matcher)Is.is((Object)Acknowledge.get()));
        MatcherAssert.assertThat(secondAcknowledge.get(), (Matcher)Is.is((Object)Acknowledge.get()));
    }

    @Test
    public void stopWithSavepointRepeatedly() throws ExecutionException, InterruptedException {
        CompletableFuture firstAcknowledge = this.handler.stopWithSavepoint(this.operationKey, "dummyDirectory", SavepointFormatType.CANONICAL, TriggerSavepointMode.TERMINATE_WITH_SAVEPOINT, TIMEOUT);
        CompletableFuture secondAcknowledge = this.handler.stopWithSavepoint(this.operationKey, "dummyDirectory", SavepointFormatType.CANONICAL, TriggerSavepointMode.TERMINATE_WITH_SAVEPOINT, TIMEOUT);
        MatcherAssert.assertThat((Object)this.stopWithSavepointFunction.getNumberOfInvocations(), (Matcher)Is.is((Object)1));
        MatcherAssert.assertThat(this.stopWithSavepointFunction.getInvocationParameters().get(0), (Matcher)Is.is((Object)new Tuple4((Object)this.jobID, (Object)"dummyDirectory", (Object)SavepointFormatType.CANONICAL, (Object)TriggerSavepointMode.TERMINATE_WITH_SAVEPOINT)));
        MatcherAssert.assertThat(firstAcknowledge.get(), (Matcher)Is.is((Object)Acknowledge.get()));
        MatcherAssert.assertThat(secondAcknowledge.get(), (Matcher)Is.is((Object)Acknowledge.get()));
    }

    @Test
    public void retryingCompletedOperationDoesNotMarkCacheEntryAsAccessed() throws ExecutionException, InterruptedException {
        this.handler.triggerSavepoint(this.operationKey, "dummyDirectory", SavepointFormatType.CANONICAL, TriggerSavepointMode.SAVEPOINT, TIMEOUT).get();
        this.savepointLocationFuture.complete("");
        this.handler.triggerSavepoint(this.operationKey, "dummyDirectory", SavepointFormatType.CANONICAL, TriggerSavepointMode.SAVEPOINT, TIMEOUT).get();
        MatcherAssert.assertThat((Object)this.cache.closeAsync(), (Matcher)FlinkMatchers.willNotComplete((Duration)Duration.ofMillis(10L)));
    }

    @Test
    public void throwsIfCacheIsShuttingDown() {
        this.cache.closeAsync();
        Assertions.assertThrows(IllegalStateException.class, () -> this.handler.triggerSavepoint(this.operationKey, "dummyDirectory", SavepointFormatType.CANONICAL, TriggerSavepointMode.SAVEPOINT, TIMEOUT));
    }

    @Test
    public void getStatus() throws ExecutionException, InterruptedException {
        this.handler.triggerSavepoint(this.operationKey, "dummyDirectory", SavepointFormatType.CANONICAL, TriggerSavepointMode.SAVEPOINT, TIMEOUT);
        String savepointLocation = "location";
        this.savepointLocationFuture.complete(savepointLocation);
        CompletableFuture statusFuture = this.handler.getSavepointStatus(this.operationKey);
        Assertions.assertEquals(statusFuture.get(), (Object)OperationResult.success((Object)savepointLocation));
    }

    @Test
    public void getStatusFailsIfKeyUnknown() throws InterruptedException {
        CompletableFuture statusFuture = this.handler.getSavepointStatus(this.operationKey);
        MatcherAssert.assertThat((Object)statusFuture, (Matcher)FlinkMatchers.futureFailedWith(UnknownOperationKeyException.class));
    }

    private static abstract class TriggerSavepointSpyFunction
    implements TriggerSavepointFunction {
        private final List<Tuple4<JobID, String, SavepointFormatType, TriggerSavepointMode>> invocations = new ArrayList<Tuple4<JobID, String, SavepointFormatType, TriggerSavepointMode>>();

        private TriggerSavepointSpyFunction() {
        }

        public CompletableFuture<String> apply(JobID jobID, String targetDirectory, SavepointFormatType formatType, TriggerSavepointMode savepointMode, Time timeout) {
            this.invocations.add((Tuple4<JobID, String, SavepointFormatType, TriggerSavepointMode>)new Tuple4((Object)jobID, (Object)targetDirectory, (Object)formatType, (Object)savepointMode));
            return this.applyWrappedFunction(jobID, targetDirectory, formatType, savepointMode, timeout);
        }

        abstract CompletableFuture<String> applyWrappedFunction(JobID var1, String var2, SavepointFormatType var3, TriggerSavepointMode var4, Time var5);

        public List<Tuple4<JobID, String, SavepointFormatType, TriggerSavepointMode>> getInvocationParameters() {
            return this.invocations;
        }

        public int getNumberOfInvocations() {
            return this.invocations.size();
        }

        public static TriggerSavepointSpyFunction wrap(final TriggerSavepointFunction wrappedFunction) {
            return new TriggerSavepointSpyFunction(){

                @Override
                CompletableFuture<String> applyWrappedFunction(JobID jobID, String targetDirectory, SavepointFormatType formatType, TriggerSavepointMode savepointMode, Time timeout) {
                    return wrappedFunction.apply(jobID, targetDirectory, formatType, savepointMode, timeout);
                }
            };
        }
    }
}

