/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.io.Serializable;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.testutils.ClassLoaderUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.SerializedThrowable;
import org.junit.Assert;
import org.junit.Test;

public class SerializedThrowableTest {
    @Test
    public void testIdenticalMessageAndStack() {
        try {
            IllegalArgumentException original = new IllegalArgumentException("test message");
            SerializedThrowable serialized = new SerializedThrowable((Throwable)original);
            Assert.assertEquals((Object)original.getMessage(), (Object)serialized.getMessage());
            Assert.assertEquals((Object)original.toString(), (Object)serialized.toString());
            Assert.assertEquals((Object)ExceptionUtils.stringifyException((Throwable)original), (Object)ExceptionUtils.stringifyException((Throwable)serialized));
            Assert.assertArrayEquals((Object[])original.getStackTrace(), (Object[])serialized.getStackTrace());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSerialization() {
        try {
            Object serialized2;
            ClassLoaderUtils.ObjectAndClassLoader outsideClassLoading = ClassLoaderUtils.createExceptionObjectFromNewClassLoader();
            ClassLoader loader = outsideClassLoading.getClassLoader();
            Exception userException = (Exception)outsideClassLoading.getObject();
            Class<?> clazz = userException.getClass();
            try {
                serialized2 = InstantiationUtil.serializeObject((Object)userException);
                InstantiationUtil.deserializeObject((byte[])serialized2, (ClassLoader)this.getClass().getClassLoader());
                Assert.fail((String)"should fail with a class not found exception");
            }
            catch (ClassNotFoundException serialized2) {
                // empty catch block
            }
            serialized2 = new SerializedThrowable((Throwable)userException);
            Assert.assertEquals((Object)userException.getMessage(), (Object)serialized2.getMessage());
            Assert.assertEquals((Object)userException.toString(), (Object)serialized2.toString());
            Assert.assertEquals((Object)ExceptionUtils.stringifyException((Throwable)userException), (Object)ExceptionUtils.stringifyException((Throwable)serialized2));
            Assert.assertArrayEquals((Object[])userException.getStackTrace(), (Object[])serialized2.getStackTrace());
            SerializedThrowable copy = (SerializedThrowable)CommonTestUtils.createCopySerializable((Serializable)serialized2);
            Assert.assertEquals((Object)userException.getMessage(), (Object)copy.getMessage());
            Assert.assertEquals((Object)userException.toString(), (Object)copy.toString());
            Assert.assertEquals((Object)ExceptionUtils.stringifyException((Throwable)userException), (Object)ExceptionUtils.stringifyException((Throwable)copy));
            Assert.assertArrayEquals((Object[])userException.getStackTrace(), (Object[])copy.getStackTrace());
            Throwable deserialized = copy.deserializeError(loader);
            Assert.assertEquals(clazz, deserialized.getClass());
            Throwable wronglyDeserialized = copy.deserializeError(this.getClass().getClassLoader());
            Assert.assertEquals((Object)ExceptionUtils.stringifyException((Throwable)userException), (Object)ExceptionUtils.stringifyException((Throwable)wronglyDeserialized));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCauseChaining() {
        Exception cause2 = new Exception("level2");
        Exception cause1 = new Exception("level1", cause2);
        Exception root = new Exception("level0", cause1);
        SerializedThrowable st = new SerializedThrowable((Throwable)root);
        Assert.assertEquals((Object)"level0", (Object)st.getMessage());
        Assert.assertNotNull((Object)st.getCause());
        Assert.assertEquals((Object)"level1", (Object)st.getCause().getMessage());
        Assert.assertNotNull((Object)st.getCause().getCause());
        Assert.assertEquals((Object)"level2", (Object)st.getCause().getCause().getMessage());
    }

    @Test
    public void testCyclicCauseChaining() {
        Exception cause3 = new Exception("level3");
        Exception cause2 = new Exception("level2", cause3);
        Exception cause1 = new Exception("level1", cause2);
        Exception root = new Exception("level0", cause1);
        cause3.initCause(cause1);
        SerializedThrowable st = new SerializedThrowable((Throwable)root);
        Assert.assertArrayEquals((Object[])root.getStackTrace(), (Object[])st.getStackTrace());
        Assert.assertEquals((Object)ExceptionUtils.stringifyException((Throwable)root), (Object)ExceptionUtils.stringifyException((Throwable)st));
    }

    @Test
    public void testCopyPreservesCause() {
        Exception original = new Exception("original message");
        Exception parent = new Exception("parent message", original);
        SerializedThrowable serialized = new SerializedThrowable((Throwable)parent);
        Assert.assertNotNull((Object)serialized.getCause());
        SerializedThrowable copy = new SerializedThrowable((Throwable)serialized);
        Assert.assertEquals((Object)"parent message", (Object)copy.getMessage());
        Assert.assertNotNull((Object)copy.getCause());
        Assert.assertEquals((Object)"original message", (Object)copy.getCause().getMessage());
    }

    @Test
    public void testSuppressedTransferring() {
        Exception root = new Exception("root");
        Exception suppressed = new Exception("suppressed");
        root.addSuppressed(suppressed);
        SerializedThrowable serializedThrowable = new SerializedThrowable((Throwable)root);
        Assert.assertEquals((long)1L, (long)serializedThrowable.getSuppressed().length);
        Throwable actualSuppressed = serializedThrowable.getSuppressed()[0];
        Assert.assertTrue((boolean)(actualSuppressed instanceof SerializedThrowable));
        Assert.assertEquals((Object)"suppressed", (Object)actualSuppressed.getMessage());
    }

    @Test
    public void testCopySuppressed() {
        Exception root = new Exception("root");
        Exception suppressed = new Exception("suppressed");
        root.addSuppressed(suppressed);
        SerializedThrowable serializedThrowable = new SerializedThrowable((Throwable)root);
        SerializedThrowable copy = new SerializedThrowable((Throwable)serializedThrowable);
        Assert.assertEquals((long)1L, (long)copy.getSuppressed().length);
        Throwable actualSuppressed = copy.getSuppressed()[0];
        Assert.assertTrue((boolean)(actualSuppressed instanceof SerializedThrowable));
        Assert.assertEquals((Object)"suppressed", (Object)actualSuppressed.getMessage());
    }
}

