/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import java.util.HashSet;
import java.util.Random;
import java.util.stream.Collectors;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.util.DualKeyLinkedMap;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class DualKeyLinkedMapTest
extends TestLogger {
    @Test
    public void testKeySets() {
        Random random = new Random();
        int capacity = 10;
        HashSet<Tuple2> keys = new HashSet<Tuple2>(10);
        for (int i = 0; i < 10; ++i) {
            int keyA = random.nextInt();
            int keyB = random.nextInt();
            keys.add(Tuple2.of((Object)keyA, (Object)keyB));
        }
        DualKeyLinkedMap dualKeyMap = new DualKeyLinkedMap(10);
        for (Tuple2 key : keys) {
            dualKeyMap.put(key.f0, key.f1, (Object)"foobar");
        }
        MatcherAssert.assertThat((Object)dualKeyMap.keySetA(), (Matcher)Matchers.equalTo(keys.stream().map(t -> (Integer)t.f0).collect(Collectors.toSet())));
        MatcherAssert.assertThat((Object)dualKeyMap.keySetB(), (Matcher)Matchers.equalTo(keys.stream().map(t -> (Integer)t.f1).collect(Collectors.toSet())));
    }

    @Test
    public void ensuresOneToOneMappingBetweenKeysSamePrimaryKey() {
        DualKeyLinkedMap map = new DualKeyLinkedMap(2);
        String secondValue = "barfoo";
        map.put((Object)1, (Object)1, (Object)"foobar");
        map.put((Object)1, (Object)2, (Object)"barfoo");
        MatcherAssert.assertThat((Object)map.getValueByKeyB((Object)1), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)map.getValueByKeyA((Object)1), (Matcher)CoreMatchers.is((Object)"barfoo"));
        MatcherAssert.assertThat((Object)map.getValueByKeyB((Object)2), (Matcher)CoreMatchers.is((Object)"barfoo"));
    }

    @Test
    public void ensuresOneToOneMappingBetweenKeysSameSecondaryKey() {
        DualKeyLinkedMap map = new DualKeyLinkedMap(2);
        String secondValue = "barfoo";
        map.put((Object)1, (Object)1, (Object)"foobar");
        map.put((Object)2, (Object)1, (Object)"barfoo");
        MatcherAssert.assertThat((Object)map.getValueByKeyA((Object)1), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)map.getValueByKeyB((Object)1), (Matcher)CoreMatchers.is((Object)"barfoo"));
        MatcherAssert.assertThat((Object)map.getValueByKeyA((Object)2), (Matcher)CoreMatchers.is((Object)"barfoo"));
    }

    @Test
    public void testPrimaryKeyOrderIsNotAffectedIfReInsertedWithSameSecondaryKey() {
        DualKeyLinkedMap map = new DualKeyLinkedMap(2);
        String value1 = "1";
        map.put((Object)1, (Object)1, (Object)"1");
        String value2 = "2";
        map.put((Object)2, (Object)2, (Object)"2");
        String value3 = "3";
        map.put((Object)1, (Object)1, (Object)"3");
        MatcherAssert.assertThat(map.keySetA().iterator().next(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(map.values().iterator().next(), (Matcher)CoreMatchers.is((Object)"3"));
    }

    @Test
    public void testPrimaryKeyOrderIsNotAffectedIfReInsertedWithDifferentSecondaryKey() {
        DualKeyLinkedMap map = new DualKeyLinkedMap(2);
        String value1 = "1";
        map.put((Object)1, (Object)1, (Object)"1");
        String value2 = "2";
        map.put((Object)2, (Object)2, (Object)"2");
        String value3 = "3";
        map.put((Object)1, (Object)3, (Object)"3");
        MatcherAssert.assertThat(map.keySetA().iterator().next(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat(map.values().iterator().next(), (Matcher)CoreMatchers.is((Object)"3"));
    }
}

