/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.strategy;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.flink.runtime.scheduler.ExecutionVertexDeploymentOption;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulerOperations;
import org.apache.flink.runtime.scheduler.strategy.TestingSchedulingExecutionVertex;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class StrategyTestUtil {
    static List<ExecutionVertexID> getExecutionVertexIdsFromDeployOptions(List<ExecutionVertexDeploymentOption> deploymentOptions) {
        return deploymentOptions.stream().map(ExecutionVertexDeploymentOption::getExecutionVertexId).collect(Collectors.toList());
    }

    static void assertLatestScheduledVerticesAreEqualTo(List<List<TestingSchedulingExecutionVertex>> expected, TestingSchedulerOperations testingSchedulerOperation) {
        List<List<ExecutionVertexDeploymentOption>> deploymentOptions = testingSchedulerOperation.getScheduledVertices();
        int expectedScheduledBulks = expected.size();
        MatcherAssert.assertThat((Object)expectedScheduledBulks, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Integer.valueOf(deploymentOptions.size())));
        for (int i = 0; i < expectedScheduledBulks; ++i) {
            Assert.assertEquals(StrategyTestUtil.idsFromVertices(expected.get(expectedScheduledBulks - i - 1)), StrategyTestUtil.idsFromDeploymentOptions(deploymentOptions.get(deploymentOptions.size() - i - 1)));
        }
    }

    static List<ExecutionVertexID> idsFromVertices(List<TestingSchedulingExecutionVertex> vertices) {
        return vertices.stream().map(TestingSchedulingExecutionVertex::getId).collect(Collectors.toList());
    }

    static List<ExecutionVertexID> idsFromDeploymentOptions(List<ExecutionVertexDeploymentOption> deploymentOptions) {
        return deploymentOptions.stream().map(ExecutionVertexDeploymentOption::getExecutionVertexId).collect(Collectors.toList());
    }
}

