/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.exceptionhistory;

import java.util.Collections;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.flink.core.testutils.FlinkMatchers;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.executiongraph.Execution;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionJobVertex;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.TaskExecutionStateTransition;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.executiongraph.failover.flip1.FailureHandlingResult;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobmaster.LogicalSlot;
import org.apache.flink.runtime.jobmaster.TestingLogicalSlotBuilder;
import org.apache.flink.runtime.scheduler.exceptionhistory.FailureHandlingResultSnapshot;
import org.apache.flink.runtime.scheduler.strategy.ExecutionVertexID;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.SerializedThrowable;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInAnyOrder;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FailureHandlingResultSnapshotTest
extends TestLogger {
    private ExecutionGraph executionGraph;

    @Before
    public void setup() throws JobException, JobExecutionException {
        JobGraph jobGraph = JobGraphTestUtils.singleNoOpJobGraph();
        jobGraph.getVertices().forEach(v -> v.setParallelism(3));
        this.executionGraph = TestingDefaultExecutionGraphBuilder.newBuilder().setJobGraph(jobGraph).build();
        this.executionGraph.start(ComponentMainThreadExecutorServiceAdapter.forMainThread());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRootCauseVertexNotFailed() {
        ExecutionVertex rootCauseExecutionVertex = this.extractExecutionVertex(0);
        FailureHandlingResult failureHandlingResult = FailureHandlingResult.restartable((ExecutionVertexID)rootCauseExecutionVertex.getID(), (Throwable)new RuntimeException("Expected exception: root cause"), (long)System.currentTimeMillis(), StreamSupport.stream(this.executionGraph.getAllExecutionVertices().spliterator(), false).map(ExecutionVertex::getID).collect(Collectors.toSet()), (long)0L, (boolean)false);
        FailureHandlingResultSnapshot.create((FailureHandlingResult)failureHandlingResult, this::getLatestExecution);
    }

    @Test
    public void testMissingThrowableHandling() {
        ExecutionVertex rootCauseExecutionVertex = this.extractExecutionVertex(0);
        long rootCauseTimestamp = this.triggerFailure(rootCauseExecutionVertex, null);
        FailureHandlingResult failureHandlingResult = FailureHandlingResult.restartable((ExecutionVertexID)rootCauseExecutionVertex.getID(), null, (long)rootCauseTimestamp, StreamSupport.stream(this.executionGraph.getAllExecutionVertices().spliterator(), false).map(ExecutionVertex::getID).collect(Collectors.toSet()), (long)0L, (boolean)false);
        FailureHandlingResultSnapshot testInstance = FailureHandlingResultSnapshot.create((FailureHandlingResult)failureHandlingResult, this::getLatestExecution);
        Throwable actualException = new SerializedThrowable(testInstance.getRootCause()).deserializeError(ClassLoader.getSystemClassLoader());
        Assert.assertThat((Object)actualException, (Matcher)IsInstanceOf.instanceOf(FlinkException.class));
        Assert.assertThat((Object)actualException, (Matcher)FlinkMatchers.containsMessage((String)ErrorInfo.handleMissingThrowable(null).getMessage()));
        Assert.assertThat((Object)testInstance.getTimestamp(), (Matcher)CoreMatchers.is((Object)rootCauseTimestamp));
        Assert.assertThat((Object)testInstance.getRootCauseExecution().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(testInstance.getRootCauseExecution().get(), (Matcher)CoreMatchers.is((Object)rootCauseExecutionVertex.getCurrentExecutionAttempt()));
    }

    @Test
    public void testLocalFailureHandlingResultSnapshotCreation() {
        ExecutionVertex rootCauseExecutionVertex = this.extractExecutionVertex(0);
        RuntimeException rootCause = new RuntimeException("Expected exception: root cause");
        ExecutionVertex otherFailedExecutionVertex = this.extractExecutionVertex(1);
        IllegalStateException otherFailure = new IllegalStateException("Expected exception: other failure");
        long rootCauseTimestamp = this.triggerFailure(rootCauseExecutionVertex, rootCause);
        this.triggerFailure(otherFailedExecutionVertex, otherFailure);
        FailureHandlingResult failureHandlingResult = FailureHandlingResult.restartable((ExecutionVertexID)rootCauseExecutionVertex.getID(), (Throwable)rootCause, (long)rootCauseTimestamp, StreamSupport.stream(this.executionGraph.getAllExecutionVertices().spliterator(), false).map(ExecutionVertex::getID).collect(Collectors.toSet()), (long)0L, (boolean)false);
        FailureHandlingResultSnapshot testInstance = FailureHandlingResultSnapshot.create((FailureHandlingResult)failureHandlingResult, this::getLatestExecution);
        Assert.assertThat((Object)testInstance.getRootCause(), (Matcher)CoreMatchers.is((Object)rootCause));
        Assert.assertThat((Object)testInstance.getTimestamp(), (Matcher)CoreMatchers.is((Object)rootCauseTimestamp));
        Assert.assertThat((Object)testInstance.getRootCauseExecution().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat(testInstance.getRootCauseExecution().get(), (Matcher)CoreMatchers.is((Object)rootCauseExecutionVertex.getCurrentExecutionAttempt()));
        Assert.assertThat((Object)testInstance.getConcurrentlyFailedExecution(), (Matcher)IsIterableContainingInOrder.contains((Object[])new Execution[]{otherFailedExecutionVertex.getCurrentExecutionAttempt()}));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFailureHandlingWithRootCauseExecutionBeingPartOfConcurrentlyFailedExecutions() {
        Execution rootCauseExecution = this.extractExecutionVertex(0).getCurrentExecutionAttempt();
        new FailureHandlingResultSnapshot(rootCauseExecution, (Throwable)new RuntimeException("Expected exception"), System.currentTimeMillis(), Collections.singleton(rootCauseExecution));
    }

    @Test
    public void testGlobalFailureHandlingResultSnapshotCreation() {
        FlinkException rootCause = new FlinkException("Expected exception: root cause");
        long timestamp = System.currentTimeMillis();
        ExecutionVertex failedExecutionVertex0 = this.extractExecutionVertex(0);
        RuntimeException failure0 = new RuntimeException("Expected exception: failure #0");
        ExecutionVertex failedExecutionVertex1 = this.extractExecutionVertex(1);
        IllegalStateException failure1 = new IllegalStateException("Expected exception: failure #1");
        this.triggerFailure(failedExecutionVertex0, failure0);
        this.triggerFailure(failedExecutionVertex1, failure1);
        FailureHandlingResult failureHandlingResult = FailureHandlingResult.restartable(null, (Throwable)rootCause, (long)timestamp, StreamSupport.stream(this.executionGraph.getAllExecutionVertices().spliterator(), false).map(ExecutionVertex::getID).collect(Collectors.toSet()), (long)0L, (boolean)true);
        FailureHandlingResultSnapshot testInstance = FailureHandlingResultSnapshot.create((FailureHandlingResult)failureHandlingResult, this::getLatestExecution);
        Assert.assertThat((Object)testInstance.getRootCause(), (Matcher)CoreMatchers.is((Object)((Object)rootCause)));
        Assert.assertThat((Object)testInstance.getTimestamp(), (Matcher)CoreMatchers.is((Object)timestamp));
        Assert.assertThat((Object)testInstance.getRootCauseExecution().isPresent(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)testInstance.getConcurrentlyFailedExecution(), (Matcher)IsIterableContainingInAnyOrder.containsInAnyOrder((Object[])new Execution[]{failedExecutionVertex0.getCurrentExecutionAttempt(), failedExecutionVertex1.getCurrentExecutionAttempt()}));
    }

    private Execution getLatestExecution(ExecutionVertexID executionVertexId) {
        if (!this.executionGraph.getAllVertices().containsKey(executionVertexId.getJobVertexId())) {
            throw new IllegalArgumentException("The ExecutionJobVertex having the ID " + executionVertexId.getJobVertexId() + " does not exist.");
        }
        ExecutionVertex[] executions = ((ExecutionJobVertex)this.executionGraph.getAllVertices().get(executionVertexId.getJobVertexId())).getTaskVertices();
        if (executions.length <= executionVertexId.getSubtaskIndex()) {
            throw new IllegalArgumentException("The ExecutionVertex having the subtask ID " + executionVertexId.getSubtaskIndex() + " for ExecutionJobVertex " + executionVertexId.getJobVertexId() + " does not exist.");
        }
        return executions[executionVertexId.getSubtaskIndex()].getCurrentExecutionAttempt();
    }

    private long triggerFailure(ExecutionVertex executionVertex, Throwable throwable) {
        this.executionGraph.updateState(new TaskExecutionStateTransition(new TaskExecutionState(executionVertex.getCurrentExecutionAttempt().getAttemptId(), ExecutionState.FAILED, throwable)));
        return ((ErrorInfo)executionVertex.getFailureInfo().orElseThrow(() -> new IllegalArgumentException("The transition into failed state didn't succeed for ExecutionVertex " + executionVertex.getID() + "."))).getTimestamp();
    }

    private ExecutionVertex extractExecutionVertex(int pos) {
        ExecutionVertex executionVertex = (ExecutionVertex)Iterables.get((Iterable)this.executionGraph.getAllExecutionVertices(), (int)pos);
        executionVertex.tryAssignResource((LogicalSlot)new TestingLogicalSlotBuilder().createTestingLogicalSlot());
        return executionVertex;
    }
}

