/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler.benchmark.topology;

import java.util.List;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.TestingDefaultExecutionGraphBuilder;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobVertex;
import org.apache.flink.runtime.scheduler.SchedulerBase;
import org.apache.flink.runtime.scheduler.VertexParallelismStore;
import org.apache.flink.runtime.scheduler.benchmark.JobConfiguration;
import org.apache.flink.runtime.scheduler.benchmark.SchedulerBenchmarkBase;
import org.apache.flink.runtime.scheduler.benchmark.SchedulerBenchmarkUtils;

public class BuildExecutionGraphBenchmark
extends SchedulerBenchmarkBase {
    private List<JobVertex> jobVertices;
    private ExecutionGraph executionGraph;

    public void setup(JobConfiguration jobConfiguration) throws Exception {
        super.setup();
        this.jobVertices = SchedulerBenchmarkUtils.createDefaultJobVertices(jobConfiguration);
        JobGraph jobGraph = SchedulerBenchmarkUtils.createJobGraph(jobConfiguration);
        VertexParallelismStore parallelismStore = SchedulerBase.computeVertexParallelismStore(this.jobVertices);
        this.executionGraph = TestingDefaultExecutionGraphBuilder.newBuilder().setVertexParallelismStore(parallelismStore).setJobGraph(jobGraph).setFutureExecutor(this.scheduledExecutorService).setIoExecutor(this.scheduledExecutorService).build();
    }

    public void buildTopology() throws Exception {
        this.executionGraph.attachJobGraph(this.jobVertices);
    }
}

