/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rest;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.flink.runtime.io.network.netty.NettyLeakDetectionResource;
import org.apache.flink.runtime.rest.MultipartUploadResource;
import org.apache.flink.runtime.rest.handler.HandlerRequest;
import org.apache.flink.runtime.rest.messages.MessageHeaders;
import org.apache.flink.runtime.rest.messages.RequestBody;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.runtime.webmonitor.RestfulGateway;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.netty4.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.flink.util.FileUtils;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.function.BiConsumerWithException;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;

public class FileUploadHandlerTest
extends TestLogger {
    @Rule
    public final MultipartUploadResource multipartUpdateResource = new MultipartUploadResource();
    private static final ObjectMapper OBJECT_MAPPER = RestMapperUtils.getStrictObjectMapper();
    @ClassRule
    public static final NettyLeakDetectionResource LEAK_DETECTION = new NettyLeakDetectionResource();

    private Request buildMalformedRequest(String headerUrl) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = this.addFilePart(builder);
        builder = builder.addPart(okhttp3.RequestBody.create((MediaType)MediaType.parse((String)"text/plain"), (String)"crash"));
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request buildMixedRequestWithUnknownAttribute(String headerUrl) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerTest.addJsonPart(builder, new MultipartUploadResource.TestRequestBody(), "hello");
        builder = this.addFilePart(builder);
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request buildRequestWithCustomFilenames(String headerUrl, String filename1, String filename2) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerTest.addFilePart(builder, this.multipartUpdateResource.file1, filename1);
        builder = FileUploadHandlerTest.addFilePart(builder, this.multipartUpdateResource.file2, filename2);
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request buildFileRequest(String headerUrl) {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = this.addFilePart(builder);
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request buildJsonRequest(String headerUrl, MultipartUploadResource.TestRequestBody json) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerTest.addJsonPart(builder, json, "request");
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request buildMixedRequest(String headerUrl, MultipartUploadResource.TestRequestBody json) throws IOException {
        MultipartBody.Builder builder = new MultipartBody.Builder();
        builder = FileUploadHandlerTest.addJsonPart(builder, json, "request");
        builder = this.addFilePart(builder);
        return this.finalizeRequest(builder, headerUrl);
    }

    private Request finalizeRequest(MultipartBody.Builder builder, String headerUrl) {
        MultipartBody multipartBody = builder.setType(MultipartBody.FORM).build();
        return new Request.Builder().url(this.multipartUpdateResource.serverAddress + headerUrl).post((okhttp3.RequestBody)multipartBody).build();
    }

    private MultipartBody.Builder addFilePart(MultipartBody.Builder builder) {
        this.multipartUpdateResource.getFilesToUpload().forEach(f -> FileUploadHandlerTest.addFilePart(builder, f, f.getName()));
        return builder;
    }

    private static MultipartBody.Builder addFilePart(MultipartBody.Builder builder, File file, String filename) {
        okhttp3.RequestBody filePayload = okhttp3.RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file);
        builder = builder.addFormDataPart(file.getName(), filename, filePayload);
        return builder;
    }

    private static MultipartBody.Builder addJsonPart(MultipartBody.Builder builder, MultipartUploadResource.TestRequestBody jsonRequestBody, String attribute) throws IOException {
        StringWriter sw = new StringWriter();
        OBJECT_MAPPER.writeValue((Writer)sw, (Object)jsonRequestBody);
        String jsonPayload = sw.toString();
        return builder.addFormDataPart(attribute, jsonPayload);
    }

    @Test
    public void testUploadDirectoryRegeneration() throws Exception {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        MultipartUploadResource.MultipartFileHandler fileHandler = this.multipartUpdateResource.getFileHandler();
        FileUtils.deleteDirectory((File)this.multipartUpdateResource.getUploadDirectory().toFile());
        Request fileRequest = this.buildFileRequest(fileHandler.getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(fileRequest).execute();){
            Assert.assertEquals((long)fileHandler.getMessageHeaders().getResponseStatusCode().code(), (long)response.code());
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    public void testMixedMultipart() throws Exception {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        MultipartUploadResource.MultipartMixedHandler mixedHandler = this.multipartUpdateResource.getMixedHandler();
        Request jsonRequest = this.buildJsonRequest(mixedHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadResource.TestRequestBody());
        try (Response response = client.newCall(jsonRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), (long)response.code());
        }
        Request fileRequest = this.buildFileRequest(mixedHandler.getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(fileRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
        MultipartUploadResource.TestRequestBody json = new MultipartUploadResource.TestRequestBody();
        Request mixedRequest = this.buildMixedRequest(mixedHandler.getMessageHeaders().getTargetRestEndpointURL(), json);
        try (Response response = client.newCall(mixedRequest).execute();){
            Assert.assertEquals((long)mixedHandler.getMessageHeaders().getResponseStatusCode().code(), (long)response.code());
            Assert.assertEquals((Object)json, (Object)mixedHandler.lastReceivedRequest);
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    public void testJsonMultipart() throws Exception {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        MultipartUploadResource.MultipartJsonHandler jsonHandler = this.multipartUpdateResource.getJsonHandler();
        MultipartUploadResource.TestRequestBody json = new MultipartUploadResource.TestRequestBody();
        Request jsonRequest = this.buildJsonRequest(jsonHandler.getMessageHeaders().getTargetRestEndpointURL(), json);
        try (Response response = client.newCall(jsonRequest).execute();){
            Assert.assertEquals((long)jsonHandler.getMessageHeaders().getResponseStatusCode().code(), (long)response.code());
            Assert.assertEquals((Object)json, (Object)jsonHandler.lastReceivedRequest);
        }
        Request fileRequest = this.buildFileRequest(jsonHandler.getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(fileRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
        Request mixedRequest = this.buildMixedRequest(jsonHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadResource.TestRequestBody());
        try (Response response = client.newCall(mixedRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    public void testFileMultipart() throws Exception {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        MultipartUploadResource.MultipartFileHandler fileHandler = this.multipartUpdateResource.getFileHandler();
        Request jsonRequest = this.buildJsonRequest(fileHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadResource.TestRequestBody());
        try (Response response = client.newCall(jsonRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
        Request fileRequest = this.buildFileRequest(fileHandler.getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(fileRequest).execute();){
            Assert.assertEquals((long)fileHandler.getMessageHeaders().getResponseStatusCode().code(), (long)response.code());
        }
        Request mixedRequest = this.buildMixedRequest(fileHandler.getMessageHeaders().getTargetRestEndpointURL(), new MultipartUploadResource.TestRequestBody());
        try (Response response = client.newCall(mixedRequest).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    public void testUploadCleanupOnUnknownAttribute() throws IOException {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        Request request = this.buildMixedRequestWithUnknownAttribute(this.multipartUpdateResource.getMixedHandler().getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((long)HttpResponseStatus.BAD_REQUEST.code(), (long)response.code());
        }
        this.multipartUpdateResource.assertUploadDirectoryIsEmpty();
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    public void testUploadCleanupOnFailure() throws IOException {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        Request request = this.buildMalformedRequest(this.multipartUpdateResource.getMixedHandler().getMessageHeaders().getTargetRestEndpointURL());
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((long)HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), (long)response.code());
        }
        this.multipartUpdateResource.assertUploadDirectoryIsEmpty();
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    public void testFileUploadUsingCustomFilename() throws IOException {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        String customFilename1 = "different-name-1.jar";
        String customFilename2 = "different-name-2.jar";
        this.multipartUpdateResource.setFileUploadVerifier(new CustomFilenameVerifier(customFilename1, this.multipartUpdateResource.file1.toPath(), customFilename2, this.multipartUpdateResource.file2.toPath()));
        MessageHeaders messageHeaders = this.multipartUpdateResource.getFileHandler().getMessageHeaders();
        Request request = this.buildRequestWithCustomFilenames(messageHeaders.getTargetRestEndpointURL(), customFilename1, customFilename2);
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((long)messageHeaders.getResponseStatusCode().code(), (long)response.code());
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    @Test
    public void testFileUploadUsingCustomFilenameWithParentFolderPath() throws IOException {
        OkHttpClient client = this.createOkHttpClientWithNoTimeouts();
        String customFilename1 = "different-name-1.jar";
        String customFilename2 = "different-name-2.jar";
        this.multipartUpdateResource.setFileUploadVerifier(new CustomFilenameVerifier(customFilename1, this.multipartUpdateResource.file1.toPath(), customFilename2, this.multipartUpdateResource.file2.toPath()));
        MessageHeaders messageHeaders = this.multipartUpdateResource.getFileHandler().getMessageHeaders();
        Request request = this.buildRequestWithCustomFilenames(this.multipartUpdateResource.getFileHandler().getMessageHeaders().getTargetRestEndpointURL(), String.format("../%s", customFilename1), String.format("../%s", customFilename2));
        try (Response response = client.newCall(request).execute();){
            Assert.assertEquals((long)messageHeaders.getResponseStatusCode().code(), (long)response.code());
        }
        this.verifyNoFileIsRegisteredToDeleteOnExitHook();
    }

    private OkHttpClient createOkHttpClientWithNoTimeouts() {
        return new OkHttpClient.Builder().connectTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).build();
    }

    private void verifyNoFileIsRegisteredToDeleteOnExitHook() {
        try {
            Class<?> clazz = Class.forName("java.io.DeleteOnExitHook");
            Field field = clazz.getDeclaredField("files");
            field.setAccessible(true);
            LinkedHashSet files = (LinkedHashSet)field.get(null);
            Assert.assertTrue((boolean)files.isEmpty());
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchFieldException e) {
            Assert.fail((String)"This should never happen.");
        }
    }

    private static class CustomFilenameVerifier
    implements BiConsumerWithException<HandlerRequest<? extends RequestBody>, RestfulGateway, Exception> {
        private final String customFilename1;
        private final Path fileContent1;
        private final String customFilename2;
        private final Path fileContent2;

        public CustomFilenameVerifier(String customFilename1, Path fileContent1, String customFilename2, Path fileContent2) {
            this.customFilename1 = customFilename1;
            this.fileContent1 = fileContent1;
            this.customFilename2 = customFilename2;
            this.fileContent2 = fileContent2;
        }

        public void accept(HandlerRequest<? extends RequestBody> request, RestfulGateway restfulGateway) throws Exception {
            List uploadedFiles = request.getUploadedFiles().stream().map(File::toPath).collect(Collectors.toList());
            ArrayList actualList = new ArrayList(uploadedFiles);
            actualList.sort(Comparator.comparing(Path::toString));
            TreeMap<String, Path> expectedFilenamesAndContent = new TreeMap<String, Path>();
            expectedFilenamesAndContent.put(this.customFilename1, this.fileContent1);
            expectedFilenamesAndContent.put(this.customFilename2, this.fileContent2);
            Assert.assertEquals((long)expectedFilenamesAndContent.size(), (long)uploadedFiles.size());
            Iterator uploadedFileIterator = actualList.iterator();
            for (Map.Entry expectedFilenameAndContent : expectedFilenamesAndContent.entrySet()) {
                String expectedFilename = (String)expectedFilenameAndContent.getKey();
                Path expectedContent = (Path)expectedFilenameAndContent.getValue();
                Assert.assertTrue((boolean)uploadedFileIterator.hasNext());
                Path actual = (Path)uploadedFileIterator.next();
                Assert.assertEquals((Object)expectedFilename, (Object)actual.getFileName().toString());
                byte[] originalContent = Files.readAllBytes(expectedContent);
                byte[] receivedContent = Files.readAllBytes(actual);
                Assert.assertArrayEquals((byte[])originalContent, (byte[])receivedContent);
            }
        }
    }
}

