/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager.slotmanager;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.core.testutils.OneShotLatch;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotID;
import org.apache.flink.runtime.metrics.groups.SlotManagerMetricGroup;
import org.apache.flink.runtime.metrics.groups.UnregisteredMetricGroups;
import org.apache.flink.runtime.resourcemanager.ResourceManagerId;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.runtime.resourcemanager.registration.TaskExecutorConnection;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultResourceTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.DefaultSlotStatusSyncer;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedSlotManager;
import org.apache.flink.runtime.resourcemanager.slotmanager.FineGrainedTaskManagerTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceActions;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceAllocationStrategy;
import org.apache.flink.runtime.resourcemanager.slotmanager.ResourceTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerConfigurationBuilder;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotManagerUtils;
import org.apache.flink.runtime.resourcemanager.slotmanager.SlotStatusSyncer;
import org.apache.flink.runtime.resourcemanager.slotmanager.TaskManagerTracker;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceActionsBuilder;
import org.apache.flink.runtime.resourcemanager.slotmanager.TestingResourceAllocationStrategy;
import org.apache.flink.runtime.slots.ResourceRequirement;
import org.apache.flink.runtime.slots.ResourceRequirements;
import org.apache.flink.runtime.taskexecutor.SlotStatus;
import org.apache.flink.runtime.taskexecutor.TaskExecutorGateway;
import org.apache.flink.runtime.taskexecutor.TestingTaskExecutorGatewayBuilder;
import org.apache.flink.testutils.TestingUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.apache.flink.util.function.RunnableWithException;
import org.junit.Assert;

public abstract class FineGrainedSlotManagerTestBase
extends TestLogger {
    private static final Executor MAIN_THREAD_EXECUTOR = Executors.newSingleThreadExecutor();
    private static final long FUTURE_TIMEOUT_SECOND = 5L;
    private static final long FUTURE_EXPECT_TIMEOUT_MS = 50L;
    static final FlinkException TEST_EXCEPTION = new FlinkException("Test exception");
    static final WorkerResourceSpec DEFAULT_WORKER_RESOURCE_SPEC = new WorkerResourceSpec.Builder().setCpuCores(10.0).setTaskHeapMemoryMB(1000).setTaskOffHeapMemoryMB(1000).setNetworkMemoryMB(1000).setManagedMemoryMB(1000).build();
    static final int DEFAULT_NUM_SLOTS_PER_WORKER = 2;
    static final ResourceProfile DEFAULT_TOTAL_RESOURCE_PROFILE = SlotManagerUtils.generateTaskManagerTotalResourceProfile((WorkerResourceSpec)DEFAULT_WORKER_RESOURCE_SPEC);
    static final ResourceProfile DEFAULT_SLOT_RESOURCE_PROFILE = SlotManagerUtils.generateDefaultSlotResourceProfile((WorkerResourceSpec)DEFAULT_WORKER_RESOURCE_SPEC, (int)2);

    protected abstract Optional<ResourceAllocationStrategy> getResourceAllocationStrategy();

    static SlotStatus createAllocatedSlotStatus(AllocationID allocationID, ResourceProfile resourceProfile) {
        return new SlotStatus(new SlotID(ResourceID.generate(), 0), resourceProfile, new JobID(), allocationID);
    }

    static int getTotalResourceCount(Collection<ResourceRequirement> resources) {
        if (resources == null) {
            return 0;
        }
        return resources.stream().map(ResourceRequirement::getNumberOfRequiredSlots).reduce(0, Integer::sum);
    }

    static ResourceRequirements createResourceRequirementsForSingleSlot() {
        return FineGrainedSlotManagerTestBase.createResourceRequirementsForSingleSlot(new JobID());
    }

    static ResourceRequirements createResourceRequirementsForSingleSlot(JobID jobId) {
        return FineGrainedSlotManagerTestBase.createResourceRequirements(jobId, 1);
    }

    static ResourceRequirements createResourceRequirements(JobID jobId, int numRequiredSlots) {
        return FineGrainedSlotManagerTestBase.createResourceRequirements(jobId, numRequiredSlots, ResourceProfile.UNKNOWN);
    }

    static ResourceRequirements createResourceRequirements(JobID jobId, int numRequiredSlots, ResourceProfile resourceProfile) {
        return ResourceRequirements.create((JobID)jobId, (String)"foobar", Collections.singleton(ResourceRequirement.create((ResourceProfile)resourceProfile, (int)numRequiredSlots)));
    }

    static TaskExecutorConnection createTaskExecutorConnection() {
        return new TaskExecutorConnection(ResourceID.generate(), (TaskExecutorGateway)new TestingTaskExecutorGatewayBuilder().createTestingTaskExecutorGateway());
    }

    static <T> T assertFutureCompleteAndReturn(CompletableFuture<T> completableFuture) throws Exception {
        return completableFuture.get(5L, TimeUnit.SECONDS);
    }

    static void assertFutureNotComplete(CompletableFuture<?> completableFuture) throws Exception {
        try {
            completableFuture.get(50L, TimeUnit.MILLISECONDS);
            Assert.fail((String)"Expected to fail with a timeout.");
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
    }

    static /* synthetic */ Executor access$000() {
        return MAIN_THREAD_EXECUTOR;
    }

    protected class Context {
        private final ResourceManagerId resourceManagerId = ResourceManagerId.generate();
        private final ResourceTracker resourceTracker = new DefaultResourceTracker();
        private final TaskManagerTracker taskManagerTracker = new FineGrainedTaskManagerTracker();
        private final SlotStatusSyncer slotStatusSyncer = new DefaultSlotStatusSyncer(Time.seconds((long)10L));
        private SlotManagerMetricGroup slotManagerMetricGroup = UnregisteredMetricGroups.createUnregisteredSlotManagerMetricGroup();
        private final ScheduledExecutor scheduledExecutor = TestingUtils.defaultScheduledExecutor();
        private final Executor mainThreadExecutor = FineGrainedSlotManagerTestBase.access$000();
        private FineGrainedSlotManager slotManager;
        private long requirementCheckDelay = 0L;
        final TestingResourceAllocationStrategy.Builder resourceAllocationStrategyBuilder = TestingResourceAllocationStrategy.newBuilder();
        final TestingResourceActionsBuilder resourceActionsBuilder = new TestingResourceActionsBuilder();
        final SlotManagerConfigurationBuilder slotManagerConfigurationBuilder = SlotManagerConfigurationBuilder.newBuilder();

        protected Context() {
        }

        FineGrainedSlotManager getSlotManager() {
            return this.slotManager;
        }

        ResourceTracker getResourceTracker() {
            return this.resourceTracker;
        }

        TaskManagerTracker getTaskManagerTracker() {
            return this.taskManagerTracker;
        }

        ResourceManagerId getResourceManagerId() {
            return this.resourceManagerId;
        }

        public void setRequirementCheckDelay(long requirementCheckDelay) {
            this.requirementCheckDelay = requirementCheckDelay;
        }

        public void setSlotManagerMetricGroup(SlotManagerMetricGroup slotManagerMetricGroup) {
            this.slotManagerMetricGroup = slotManagerMetricGroup;
        }

        void runInMainThread(Runnable runnable) {
            this.mainThreadExecutor.execute(runnable);
        }

        void runInMainThreadAndWait(Runnable runnable) throws InterruptedException {
            OneShotLatch latch = new OneShotLatch();
            this.mainThreadExecutor.execute(() -> {
                runnable.run();
                latch.trigger();
            });
            latch.await();
        }

        protected final void runTest(RunnableWithException testMethod) throws Exception {
            this.slotManager = new FineGrainedSlotManager(this.scheduledExecutor, this.slotManagerConfigurationBuilder.build(), this.slotManagerMetricGroup, this.resourceTracker, this.taskManagerTracker, this.slotStatusSyncer, FineGrainedSlotManagerTestBase.this.getResourceAllocationStrategy().orElse(this.resourceAllocationStrategyBuilder.build()), Time.milliseconds((long)this.requirementCheckDelay));
            this.runInMainThreadAndWait(() -> this.slotManager.start(this.resourceManagerId, this.mainThreadExecutor, (ResourceActions)this.resourceActionsBuilder.build()));
            testMethod.run();
            CompletableFuture closeFuture = new CompletableFuture();
            this.runInMainThread(() -> {
                try {
                    this.slotManager.close();
                }
                catch (Exception e) {
                    closeFuture.completeExceptionally(e);
                }
                closeFuture.complete(null);
            });
            FutureUtils.assertNoException(closeFuture);
        }
    }
}

