/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.resourcemanager;

import org.apache.flink.api.common.resources.ExternalResource;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ExternalResourceOptions;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessSpec;
import org.apache.flink.runtime.clusterframework.TaskExecutorProcessUtils;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.resourcemanager.WorkerResourceSpec;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class WorkerResourceSpecTest
extends TestLogger {
    private static final String EXTERNAL_RESOURCE_NAME = "gpu";

    @Test
    public void testEquals() {
        WorkerResourceSpec spec1 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec2 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec3 = new WorkerResourceSpec.Builder().setCpuCores(1.1).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec4 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(110).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec5 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(110).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec6 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(110).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec7 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(110).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec8 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(2).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec9 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.0)).build();
        WorkerResourceSpec spec10 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).build();
        Assert.assertEquals((Object)spec1, (Object)spec1);
        Assert.assertEquals((Object)spec1, (Object)spec2);
        Assert.assertNotEquals((Object)spec1, (Object)spec3);
        Assert.assertNotEquals((Object)spec1, (Object)spec4);
        Assert.assertNotEquals((Object)spec1, (Object)spec5);
        Assert.assertNotEquals((Object)spec1, (Object)spec6);
        Assert.assertNotEquals((Object)spec1, (Object)spec7);
        Assert.assertNotEquals((Object)spec1, (Object)spec8);
        Assert.assertNotEquals((Object)spec1, (Object)spec9);
        Assert.assertNotEquals((Object)spec1, (Object)spec10);
    }

    @Test
    public void testHashCodeEquals() {
        WorkerResourceSpec spec1 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec2 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec3 = new WorkerResourceSpec.Builder().setCpuCores(1.1).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec4 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(110).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec5 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(110).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec6 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(110).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec7 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(110).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec8 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(2).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec spec9 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 2.0)).build();
        WorkerResourceSpec spec10 = new WorkerResourceSpec.Builder().setCpuCores(1.0).setTaskHeapMemoryMB(100).setTaskOffHeapMemoryMB(100).setNetworkMemoryMB(100).setManagedMemoryMB(100).setNumSlots(1).build();
        Assert.assertEquals((long)spec1.hashCode(), (long)spec1.hashCode());
        Assert.assertEquals((long)spec1.hashCode(), (long)spec2.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec3.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec4.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec5.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec6.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec7.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec8.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec9.hashCode());
        Assert.assertNotEquals((long)spec1.hashCode(), (long)spec10.hashCode());
    }

    @Test
    public void testCreateFromTaskExecutorProcessSpec() {
        Configuration config = new Configuration();
        config.setString(ExternalResourceOptions.EXTERNAL_RESOURCE_LIST.key(), EXTERNAL_RESOURCE_NAME);
        config.setLong(ExternalResourceOptions.getAmountConfigOptionForResource((String)EXTERNAL_RESOURCE_NAME), 1L);
        TaskExecutorProcessSpec taskExecutorProcessSpec = TaskExecutorProcessUtils.newProcessSpecBuilder((Configuration)config).withTotalProcessMemory(MemorySize.ofMebiBytes((long)1024L)).build();
        WorkerResourceSpec workerResourceSpec = WorkerResourceSpec.fromTaskExecutorProcessSpec((TaskExecutorProcessSpec)taskExecutorProcessSpec);
        Assert.assertEquals((Object)workerResourceSpec.getCpuCores(), (Object)taskExecutorProcessSpec.getCpuCores());
        Assert.assertEquals((Object)workerResourceSpec.getTaskHeapSize(), (Object)taskExecutorProcessSpec.getTaskHeapSize());
        Assert.assertEquals((Object)workerResourceSpec.getTaskOffHeapSize(), (Object)taskExecutorProcessSpec.getTaskOffHeapSize());
        Assert.assertEquals((Object)workerResourceSpec.getNetworkMemSize(), (Object)taskExecutorProcessSpec.getNetworkMemSize());
        Assert.assertEquals((Object)workerResourceSpec.getManagedMemSize(), (Object)taskExecutorProcessSpec.getManagedMemorySize());
        Assert.assertEquals((long)workerResourceSpec.getNumSlots(), (long)taskExecutorProcessSpec.getNumSlots());
        Assert.assertEquals((Object)workerResourceSpec.getExtendedResources(), (Object)taskExecutorProcessSpec.getExtendedResources());
    }

    @Test
    public void testCreateFromResourceProfile() {
        int numSlots = 3;
        ResourceProfile resourceProfile = ResourceProfile.newBuilder().setCpuCores(1.0).setManagedMemoryMB(100).setNetworkMemoryMB(100).setTaskOffHeapMemoryMB(10).setTaskHeapMemoryMB(10).setExtendedResource(new ExternalResource(EXTERNAL_RESOURCE_NAME, 1.0)).build();
        WorkerResourceSpec workerResourceSpec = WorkerResourceSpec.fromTotalResourceProfile((ResourceProfile)resourceProfile, (int)3);
        Assert.assertEquals((Object)workerResourceSpec.getCpuCores(), (Object)resourceProfile.getCpuCores());
        Assert.assertEquals((Object)workerResourceSpec.getTaskHeapSize(), (Object)resourceProfile.getTaskHeapMemory());
        Assert.assertEquals((Object)workerResourceSpec.getTaskOffHeapSize(), (Object)resourceProfile.getTaskOffHeapMemory());
        Assert.assertEquals((Object)workerResourceSpec.getNetworkMemSize(), (Object)resourceProfile.getNetworkMemory());
        Assert.assertEquals((Object)workerResourceSpec.getManagedMemSize(), (Object)resourceProfile.getManagedMemory());
        Assert.assertEquals((long)workerResourceSpec.getNumSlots(), (long)3L);
        Assert.assertEquals((Object)workerResourceSpec.getExtendedResources(), (Object)resourceProfile.getExtendedResources());
    }
}

