/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.messages.webmonitor;

import java.io.IOException;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.messages.webmonitor.JobDetails;
import org.apache.flink.runtime.rest.util.RestMapperUtils;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonProcessingException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.TreeNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class JobDetailsTest
extends TestLogger {
    private static final String COMPATIBLE_JOB_DETAILS = "{  \"jid\" : \"7a7c3291accebd10b6be8d4f8c8d8dfc\",  \"name\" : \"foobar\",  \"state\" : \"RUNNING\",  \"start-time\" : 1,  \"end-time\" : 10,  \"duration\" : 9,  \"last-modification\" : 8,  \"tasks\" : {    \"total\" : 42,    \"created\" : 1,    \"scheduled\" : 3,    \"deploying\" : 3,    \"running\" : 4,    \"finished\" : 7,    \"canceling\" : 4,    \"canceled\" : 2,    \"failed\" : 7,    \"reconciling\" : 3  }}";

    @Test
    public void testJobDetailsMarshalling() throws JsonProcessingException {
        JobDetails expected = new JobDetails(new JobID(), "foobar", 1L, 10L, 9L, JobStatus.RUNNING, 8L, new int[]{1, 3, 3, 4, 7, 4, 2, 7, 3, 3}, 42);
        ObjectMapper objectMapper = RestMapperUtils.getStrictObjectMapper();
        JsonNode marshalled = objectMapper.valueToTree((Object)expected);
        JobDetails unmarshalled = (JobDetails)objectMapper.treeToValue((TreeNode)marshalled, JobDetails.class);
        Assert.assertEquals((Object)expected, (Object)unmarshalled);
    }

    @Test
    public void testJobDetailsCompatibleUnmarshalling() throws IOException {
        JobDetails expected = new JobDetails(JobID.fromHexString((String)"7a7c3291accebd10b6be8d4f8c8d8dfc"), "foobar", 1L, 10L, 9L, JobStatus.RUNNING, 8L, new int[]{1, 3, 3, 4, 7, 4, 2, 7, 3, 0}, 42);
        ObjectMapper objectMapper = RestMapperUtils.getStrictObjectMapper();
        JobDetails unmarshalled = (JobDetails)objectMapper.readValue(COMPATIBLE_JOB_DETAILS, JobDetails.class);
        Assert.assertEquals((Object)expected, (Object)unmarshalled);
    }
}

