/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.time.Duration;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.runtime.leaderelection.LeaderElectionEvent;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.leaderelection.LeaderInformationWithComponentId;
import org.apache.flink.runtime.leaderelection.MultipleComponentLeaderElectionDriver;
import org.apache.flink.util.ExceptionUtils;

public final class TestingLeaderElectionListener
implements MultipleComponentLeaderElectionDriver.Listener {
    private final BlockingQueue<LeaderElectionEvent> leaderElectionEvents = new ArrayBlockingQueue<LeaderElectionEvent>(10);

    public void isLeader() {
        this.put(new LeaderElectionEvent.IsLeaderEvent());
    }

    public void notLeader() {
        this.put(new LeaderElectionEvent.NotLeaderEvent());
    }

    public void notifyLeaderInformationChange(String componentId, LeaderInformation leaderInformation) {
        this.put(new LeaderElectionEvent.LeaderInformationChangeEvent(componentId, leaderInformation));
    }

    public void notifyAllKnownLeaderInformation(Collection<LeaderInformationWithComponentId> leaderInformationWithComponentIds) {
        this.put(new LeaderElectionEvent.AllKnownLeaderInformationEvent(leaderInformationWithComponentIds));
    }

    private void put(LeaderElectionEvent leaderElectionEvent) {
        try {
            this.leaderElectionEvents.put(leaderElectionEvent);
        }
        catch (InterruptedException e) {
            ExceptionUtils.rethrow((Throwable)e);
        }
    }

    public <T> T await(Class<T> clazz) throws InterruptedException {
        LeaderElectionEvent leaderElectionEvent;
        while (!clazz.isAssignableFrom((leaderElectionEvent = this.leaderElectionEvents.take()).getClass())) {
        }
        return clazz.cast(leaderElectionEvent);
    }

    public <T> Optional<T> await(Class<T> clazz, Duration timeout) throws InterruptedException {
        block2: {
            Optional<LeaderElectionEvent> optLeaderElectionEvent;
            LeaderElectionEvent leaderElectionEvent;
            Deadline deadline = Deadline.fromNow((Duration)timeout);
            do {
                Duration timeLeft;
                if ((timeLeft = deadline.timeLeft()).isNegative()) {
                    return Optional.empty();
                }
                optLeaderElectionEvent = Optional.ofNullable(this.leaderElectionEvents.poll(timeLeft.toMillis(), TimeUnit.MILLISECONDS));
                if (!optLeaderElectionEvent.isPresent()) break block2;
            } while (!clazz.isAssignableFrom((leaderElectionEvent = optLeaderElectionEvent.get()).getClass()));
            return Optional.of(clazz.cast(optLeaderElectionEvent));
        }
        return Optional.empty();
    }
}

