/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.netty;

import java.io.IOException;
import java.util.Random;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.core.memory.MemorySegmentProvider;
import org.apache.flink.runtime.io.network.NetworkClientHandler;
import org.apache.flink.runtime.io.network.TestingPartitionRequestClient;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferCompressor;
import org.apache.flink.runtime.io.network.buffer.BufferDecompressor;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.buffer.NetworkBufferPool;
import org.apache.flink.runtime.io.network.netty.CreditBasedPartitionRequestClientHandler;
import org.apache.flink.runtime.io.network.netty.NettyMessage;
import org.apache.flink.runtime.io.network.netty.NettyMessageClientDecoderDelegate;
import org.apache.flink.runtime.io.network.netty.NettyTestUtil;
import org.apache.flink.runtime.io.network.partition.InputChannelTestUtils;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.InputChannelID;
import org.apache.flink.runtime.io.network.partition.consumer.RemoteInputChannel;
import org.apache.flink.runtime.io.network.partition.consumer.SingleInputGate;
import org.apache.flink.shaded.netty4.io.netty.channel.ChannelHandler;
import org.apache.flink.shaded.netty4.io.netty.channel.embedded.EmbeddedChannel;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NettyMessageClientSideSerializationTest
extends TestLogger {
    private static final int BUFFER_SIZE = 1024;
    private static final BufferCompressor COMPRESSOR = new BufferCompressor(1024, "LZ4");
    private static final BufferDecompressor DECOMPRESSOR = new BufferDecompressor(1024, "LZ4");
    private final Random random = new Random();
    private EmbeddedChannel channel;
    private NetworkBufferPool networkBufferPool;
    private SingleInputGate inputGate;
    private InputChannelID inputChannelId;

    @Before
    public void setup() throws IOException, InterruptedException {
        this.networkBufferPool = new NetworkBufferPool(8, 1024);
        this.inputGate = InputChannelTestUtils.createSingleInputGate(1, (MemorySegmentProvider)this.networkBufferPool);
        RemoteInputChannel inputChannel = InputChannelTestUtils.createRemoteInputChannel(this.inputGate, new TestingPartitionRequestClient());
        inputChannel.requestSubpartition();
        this.inputGate.setInputChannels(new InputChannel[]{inputChannel});
        this.inputGate.setup();
        CreditBasedPartitionRequestClientHandler handler = new CreditBasedPartitionRequestClientHandler();
        handler.addInputChannel(inputChannel);
        this.channel = new EmbeddedChannel(new ChannelHandler[]{new NettyMessage.NettyMessageEncoder(), new NettyMessageClientDecoderDelegate((NetworkClientHandler)handler)});
        this.inputChannelId = inputChannel.getInputChannelId();
    }

    @After
    public void tearDown() throws IOException {
        if (this.inputGate != null) {
            this.inputGate.close();
        }
        if (this.networkBufferPool != null) {
            this.networkBufferPool.destroyAllBufferPools();
            this.networkBufferPool.destroy();
        }
        if (this.channel != null) {
            this.channel.close();
        }
    }

    @Test
    public void testErrorResponseWithoutErrorMessage() {
        this.testErrorResponse(new NettyMessage.ErrorResponse((Throwable)new IllegalStateException(), this.inputChannelId));
    }

    @Test
    public void testErrorResponseWithErrorMessage() {
        this.testErrorResponse(new NettyMessage.ErrorResponse((Throwable)new IllegalStateException("Illegal illegal illegal"), this.inputChannelId));
    }

    @Test
    public void testErrorResponseWithFatalError() {
        this.testErrorResponse(new NettyMessage.ErrorResponse((Throwable)new IllegalStateException("Illegal illegal illegal")));
    }

    @Test
    public void testOrdinaryBufferResponse() {
        this.testBufferResponse(false, false);
    }

    @Test
    public void testBufferResponseWithReadOnlySlice() {
        this.testBufferResponse(true, false);
    }

    @Test
    public void testCompressedBufferResponse() {
        this.testBufferResponse(false, true);
    }

    @Test
    public void testBacklogAnnouncement() {
        NettyMessage.BacklogAnnouncement expected = new NettyMessage.BacklogAnnouncement(1024, this.inputChannelId);
        NettyMessage.BacklogAnnouncement actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assert.assertEquals((long)expected.backlog, (long)actual.backlog);
        Assert.assertEquals((Object)expected.receiverId, (Object)actual.receiverId);
    }

    private void testErrorResponse(NettyMessage.ErrorResponse expect) {
        NettyMessage.ErrorResponse actual = NettyTestUtil.encodeAndDecode(expect, this.channel);
        NettyTestUtil.verifyErrorResponse(expect, actual);
    }

    private void testBufferResponse(boolean testReadOnlyBuffer, boolean testCompressedBuffer) {
        Preconditions.checkArgument((!(testReadOnlyBuffer & testCompressedBuffer) ? 1 : 0) != 0, (Object)"There are no cases with both readonly slice and compression.");
        NetworkBuffer buffer = new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)1024), FreeingBufferRecycler.INSTANCE);
        for (int i = 0; i < 1024; i += 8) {
            buffer.writeLong((long)i);
        }
        NetworkBuffer testBuffer = buffer;
        if (testReadOnlyBuffer) {
            testBuffer = buffer.readOnlySlice();
        } else if (testCompressedBuffer) {
            testBuffer = COMPRESSOR.compressToOriginalBuffer((Buffer)buffer);
        }
        NettyMessage.BufferResponse expected = new NettyMessage.BufferResponse((Buffer)testBuffer, this.random.nextInt(Integer.MAX_VALUE), this.inputChannelId, this.random.nextInt(Integer.MAX_VALUE));
        NettyMessage.BufferResponse actual = NettyTestUtil.encodeAndDecode(expected, this.channel);
        Assert.assertTrue((boolean)buffer.isRecycled());
        Assert.assertTrue((boolean)testBuffer.isRecycled());
        Assert.assertNotNull((String)"The request input channel should always have available buffers in this test.", (Object)actual.getBuffer());
        Buffer decodedBuffer = actual.getBuffer();
        if (testCompressedBuffer) {
            Assert.assertTrue((boolean)actual.isCompressed);
            decodedBuffer = this.decompress(decodedBuffer);
        }
        NettyTestUtil.verifyBufferResponseHeader(expected, actual);
        Assert.assertEquals((long)1024L, (long)decodedBuffer.readableBytes());
        for (int i = 0; i < 1024; i += 8) {
            Assert.assertEquals((long)i, (long)decodedBuffer.asByteBuf().readLong());
        }
        actual.releaseBuffer();
        if (testCompressedBuffer) {
            decodedBuffer.recycleBuffer();
        }
        Assert.assertTrue((boolean)actual.getBuffer().isRecycled());
    }

    private Buffer decompress(Buffer buffer) {
        MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)1024);
        NetworkBuffer compressedBuffer = new NetworkBuffer(segment, FreeingBufferRecycler.INSTANCE);
        buffer.asByteBuf().readBytes(compressedBuffer.asByteBuf(), buffer.readableBytes());
        compressedBuffer.setCompressed(true);
        return DECOMPRESSOR.decompressToOriginalBuffer((Buffer)compressedBuffer);
    }
}

