/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilder;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;

public class BufferBuilderTestUtils {
    public static final int BUFFER_SIZE = 32768;

    public static BufferBuilder createBufferBuilder() {
        return BufferBuilderTestUtils.createBufferBuilder(32768);
    }

    public static BufferBuilder createBufferBuilder(int size) {
        return BufferBuilderTestUtils.createFilledBufferBuilder(size, 0);
    }

    public static BufferBuilder createBufferBuilder(MemorySegment memorySegment) {
        return BufferBuilderTestUtils.createFilledBufferBuilder(memorySegment, 0);
    }

    public static BufferBuilder createFilledBufferBuilder(int size, int dataSize) {
        Preconditions.checkArgument((size >= dataSize ? 1 : 0) != 0);
        return BufferBuilderTestUtils.createFilledBufferBuilder(MemorySegmentFactory.allocateUnpooledSegment((int)size), dataSize);
    }

    public static BufferBuilder createFilledBufferBuilder(MemorySegment memorySegment, int dataSize) {
        BufferBuilder bufferBuilder = new BufferBuilder(memorySegment, FreeingBufferRecycler.INSTANCE);
        return BufferBuilderTestUtils.fillBufferBuilder(bufferBuilder, dataSize);
    }

    public static BufferBuilder fillBufferBuilder(BufferBuilder bufferBuilder, int dataSize) {
        bufferBuilder.appendAndCommit(ByteBuffer.allocate(dataSize));
        return bufferBuilder;
    }

    public static Buffer buildSingleBuffer(BufferBuilder bufferBuilder) {
        try (BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();){
            Buffer buffer = bufferConsumer.build();
            return buffer;
        }
    }

    public static Buffer buildSingleBuffer(BufferConsumer bufferConsumer) {
        Buffer buffer = bufferConsumer.build();
        bufferConsumer.close();
        return buffer;
    }

    public static BufferConsumer createFilledFinishedBufferConsumer(int dataSize) {
        return BufferBuilderTestUtils.createFilledBufferConsumer(dataSize, dataSize, true);
    }

    public static BufferConsumer createFilledUnfinishedBufferConsumer(int dataSize) {
        return BufferBuilderTestUtils.createFilledBufferConsumer(dataSize, dataSize, false);
    }

    public static BufferConsumer createFilledBufferConsumer(int size, int dataSize, boolean isFinished) {
        Preconditions.checkArgument((size >= dataSize ? 1 : 0) != 0);
        BufferBuilder bufferBuilder = BufferBuilderTestUtils.createBufferBuilder(size);
        BufferConsumer bufferConsumer = bufferBuilder.createBufferConsumer();
        BufferBuilderTestUtils.fillBufferBuilder(bufferBuilder, dataSize);
        if (isFinished) {
            bufferBuilder.finish();
            bufferBuilder.close();
        }
        return bufferConsumer;
    }

    public static BufferConsumer createEventBufferConsumer(int size, Buffer.DataType dataType) {
        return new BufferConsumer((Buffer)new NetworkBuffer(MemorySegmentFactory.allocateUnpooledSegment((int)size), FreeingBufferRecycler.INSTANCE, dataType), size);
    }

    public static Buffer buildBufferWithAscendingInts(int bufferSize, int numInts, int nextValue) {
        MemorySegment seg = MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize);
        for (int i = 0; i < numInts; ++i) {
            seg.putIntLittleEndian(4 * i, nextValue++);
        }
        return new NetworkBuffer(seg, MemorySegment::free, Buffer.DataType.DATA_BUFFER, 4 * numInts);
    }

    public static void validateBufferWithAscendingInts(Buffer buffer, int numInts, int nextValue) {
        ByteBuffer bb = buffer.getNioBufferReadable().order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < numInts; ++i) {
            Assert.assertEquals((long)nextValue++, (long)bb.getInt());
        }
    }

    public static Buffer buildSomeBuffer() {
        return BufferBuilderTestUtils.buildSomeBuffer(1024);
    }

    public static Buffer buildSomeBuffer(int size) {
        MemorySegment seg = MemorySegmentFactory.allocateUnpooledSegment((int)size);
        return new NetworkBuffer(seg, MemorySegment::free, Buffer.DataType.DATA_BUFFER, size);
    }

    public static BufferBuilder createEmptyBufferBuilder(int bufferSize) {
        return new BufferBuilder(MemorySegmentFactory.allocateUnpooledSegment((int)bufferSize), FreeingBufferRecycler.INSTANCE);
    }
}

