/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutorServiceAdapter;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphTestUtils;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.scheduler.DefaultScheduler;
import org.apache.flink.runtime.scheduler.SchedulerTestingUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;

public class ExecutionGraphVariousFailuesTest
extends TestLogger {
    @Test
    public void testFailingNotifyPartitionDataAvailable() throws Exception {
        DefaultScheduler scheduler = SchedulerTestingUtils.newSchedulerBuilder(JobGraphTestUtils.emptyJobGraph(), ComponentMainThreadExecutorServiceAdapter.forMainThread()).build();
        scheduler.startScheduling();
        ExecutionGraph eg = scheduler.getExecutionGraph();
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
        ExecutionGraphTestUtils.switchAllVerticesToRunning(eg);
        IntermediateResultPartitionID intermediateResultPartitionId = new IntermediateResultPartitionID();
        ExecutionAttemptID producerId = new ExecutionAttemptID();
        ResultPartitionID resultPartitionId = new ResultPartitionID(intermediateResultPartitionId, producerId);
        try {
            scheduler.notifyPartitionDataAvailable(resultPartitionId);
            Assert.fail((String)"Error expected.");
        }
        catch (IllegalStateException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)Matchers.containsString((String)"Cannot find execution for execution Id"));
        }
        Assert.assertEquals((Object)JobStatus.RUNNING, (Object)eg.getState());
    }
}

