/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.flink.runtime.checkpoint.StateObjectCollection;
import org.apache.flink.runtime.state.StateObject;
import org.apache.flink.util.MethodForwardingTestUtil;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class StateObjectCollectionTest
extends TestLogger {
    @Test
    public void testEmptyCollection() {
        StateObjectCollection empty = StateObjectCollection.empty();
        Assert.assertEquals((long)0L, (long)empty.getStateSize());
    }

    @Test
    public void testForwardingCollectionMethods() throws Exception {
        MethodForwardingTestUtil.testMethodForwarding(Collection.class, StateObjectCollection::new);
    }

    @Test
    public void testForwardingStateObjectMethods() throws Exception {
        MethodForwardingTestUtil.testMethodForwarding(StateObject.class, object -> new StateObjectCollection(Collections.singletonList(object)));
    }

    @Test
    public void testHasState() {
        StateObjectCollection stateObjects = new StateObjectCollection(new ArrayList());
        Assert.assertFalse((boolean)stateObjects.hasState());
        stateObjects = new StateObjectCollection(Collections.singletonList(null));
        Assert.assertFalse((boolean)stateObjects.hasState());
        stateObjects = new StateObjectCollection(Collections.singletonList(Mockito.mock(StateObject.class)));
        Assert.assertTrue((boolean)stateObjects.hasState());
    }
}

