/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import java.util.Collections;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinator;
import org.apache.flink.runtime.checkpoint.CheckpointCoordinatorTestingUtils;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureManager;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointPlanCalculator;
import org.apache.flink.runtime.checkpoint.CheckpointPlanCalculatorContext;
import org.apache.flink.runtime.checkpoint.CheckpointRetentionPolicy;
import org.apache.flink.runtime.checkpoint.CheckpointStatsTracker;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.DefaultCheckpointPlanCalculator;
import org.apache.flink.runtime.checkpoint.ExecutionAttemptMappingProvider;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.executiongraph.ExecutionGraph;
import org.apache.flink.runtime.executiongraph.ExecutionGraphCheckpointPlanCalculatorContext;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointCoordinatorConfiguration;
import org.apache.flink.runtime.state.CheckpointStorage;
import org.apache.flink.runtime.state.memory.MemoryStateBackend;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.Executors;
import org.apache.flink.util.concurrent.ManuallyTriggeredScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class FailoverStrategyCheckpointCoordinatorTest
extends TestLogger {
    private ManuallyTriggeredScheduledExecutor manualThreadExecutor;

    @Before
    public void setUp() {
        this.manualThreadExecutor = new ManuallyTriggeredScheduledExecutor();
    }

    @Test
    public void testAbortPendingCheckpointsWithTriggerValidation() throws Exception {
        int maxConcurrentCheckpoints = ThreadLocalRandom.current().nextInt(10) + 1;
        ExecutionGraph graph = new CheckpointCoordinatorTestingUtils.CheckpointExecutionGraphBuilder().addJobVertex(new JobVertexID()).setTransitToRunning(false).build();
        CheckpointCoordinatorConfiguration checkpointCoordinatorConfiguration = new CheckpointCoordinatorConfiguration(Integer.MAX_VALUE, Integer.MAX_VALUE, 0L, maxConcurrentCheckpoints, CheckpointRetentionPolicy.NEVER_RETAIN_AFTER_TERMINATION, true, false, 0, 0L);
        CheckpointCoordinator checkpointCoordinator = new CheckpointCoordinator(graph.getJobID(), checkpointCoordinatorConfiguration, Collections.emptyList(), (CheckpointIDCounter)new StandaloneCheckpointIDCounter(), (CompletedCheckpointStore)new StandaloneCompletedCheckpointStore(1), (CheckpointStorage)new MemoryStateBackend(), Executors.directExecutor(), new CheckpointsCleaner(), (ScheduledExecutor)this.manualThreadExecutor, (CheckpointFailureManager)Mockito.mock(CheckpointFailureManager.class), (CheckpointPlanCalculator)new DefaultCheckpointPlanCalculator(graph.getJobID(), (CheckpointPlanCalculatorContext)new ExecutionGraphCheckpointPlanCalculatorContext(graph), graph.getVerticesTopologically(), false), new ExecutionAttemptMappingProvider(graph.getAllExecutionVertices()), (CheckpointStatsTracker)Mockito.mock(CheckpointStatsTracker.class));
        graph.transitionToRunning();
        graph.getAllExecutionVertices().forEach(task -> task.getCurrentExecutionAttempt().transitionState(ExecutionState.RUNNING));
        checkpointCoordinator.startCheckpointScheduler();
        Assert.assertTrue((boolean)checkpointCoordinator.isCurrentPeriodicTriggerAvailable());
        this.manualThreadExecutor.triggerPeriodicScheduledTasks();
        this.manualThreadExecutor.triggerAll();
        Assert.assertEquals((long)1L, (long)checkpointCoordinator.getNumberOfPendingCheckpoints());
        for (int i = 1; i < maxConcurrentCheckpoints; ++i) {
            checkpointCoordinator.triggerCheckpoint(false);
            this.manualThreadExecutor.triggerAll();
            Assert.assertEquals((long)(i + 1), (long)checkpointCoordinator.getNumberOfPendingCheckpoints());
            Assert.assertTrue((boolean)checkpointCoordinator.isCurrentPeriodicTriggerAvailable());
        }
        checkpointCoordinator.triggerCheckpoint(false);
        this.manualThreadExecutor.triggerAll();
        Assert.assertEquals((long)maxConcurrentCheckpoints, (long)checkpointCoordinator.getNumberOfPendingCheckpoints());
        checkpointCoordinator.abortPendingCheckpoints(new CheckpointException(CheckpointFailureReason.JOB_FAILOVER_REGION));
        Assert.assertTrue((boolean)checkpointCoordinator.isCurrentPeriodicTriggerAvailable());
        Assert.assertEquals((long)0L, (long)checkpointCoordinator.getNumberOfPendingCheckpoints());
    }
}

