/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Random;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.core.testutils.FlinkAssertions;
import org.apache.flink.runtime.blob.BlobCacheService;
import org.apache.flink.runtime.blob.BlobKey;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerGetTest;
import org.apache.flink.runtime.blob.BlobServerPutTest;
import org.apache.flink.runtime.blob.BlobService;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.runtime.blob.BlobStoreService;
import org.apache.flink.runtime.blob.BlobUtils;
import org.apache.flink.runtime.blob.BlobView;
import org.apache.flink.runtime.blob.VoidBlobStore;
import org.apache.flink.util.TestLogger;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobCacheCorruptionTest
extends TestLogger {
    @ClassRule
    public static final TemporaryFolder TEMPORARY_FOLDER = new TemporaryFolder();

    @Test
    public void testGetFailsFromCorruptFile1() throws IOException {
        this.testGetFailsFromCorruptFile(null, BlobKey.BlobType.TRANSIENT_BLOB, false);
    }

    @Test
    public void testGetFailsFromCorruptFile2() throws IOException {
        this.testGetFailsFromCorruptFile(new JobID(), BlobKey.BlobType.TRANSIENT_BLOB, false);
    }

    @Test
    public void testGetFailsFromCorruptFile3() throws IOException {
        this.testGetFailsFromCorruptFile(new JobID(), BlobKey.BlobType.PERMANENT_BLOB, false);
    }

    @Test
    public void testGetFailsFromCorruptFile4() throws IOException {
        this.testGetFailsFromCorruptFile(new JobID(), BlobKey.BlobType.PERMANENT_BLOB, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testGetFailsFromCorruptFile(JobID jobId, BlobKey.BlobType blobType, boolean corruptOnHAStore) throws IOException {
        Configuration config = new Configuration();
        config.setString(HighAvailabilityOptions.HA_MODE, "ZOOKEEPER");
        config.setString(HighAvailabilityOptions.HA_STORAGE_PATH, TEMPORARY_FOLDER.newFolder().getPath());
        BlobStoreService blobStoreService = null;
        try {
            blobStoreService = BlobUtils.createBlobStoreFromConfig((Configuration)config);
            BlobCacheCorruptionTest.testGetFailsFromCorruptFile(jobId, blobType, corruptOnHAStore, config, (BlobStore)blobStoreService, TEMPORARY_FOLDER.newFolder());
        }
        finally {
            if (blobStoreService != null) {
                blobStoreService.closeAndCleanupAllData();
            }
        }
    }

    public static void testGetFailsFromCorruptFile(JobID jobId, Configuration config, BlobStore blobStore, File blobStorage) throws IOException {
        BlobCacheCorruptionTest.testGetFailsFromCorruptFile(jobId, BlobKey.BlobType.PERMANENT_BLOB, true, config, blobStore, blobStorage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testGetFailsFromCorruptFile(@Nullable JobID jobId, BlobKey.BlobType blobType, boolean corruptOnHAStore, Configuration config, BlobStore blobStore, File blobStorage) throws IOException {
        Assert.assertTrue((String)"corrupt HA file requires a HA setup", (!corruptOnHAStore || blobType == BlobKey.BlobType.PERMANENT_BLOB ? 1 : 0) != 0);
        Random rnd = new Random();
        try (BlobServer server = new BlobServer(config, new File(blobStorage, "server"), blobStore);
             BlobCacheService cache = new BlobCacheService(config, new File(blobStorage, "cache"), (BlobView)(corruptOnHAStore ? blobStore : new VoidBlobStore()), new InetSocketAddress("localhost", server.getPort()));){
            server.start();
            byte[] data = new byte[2000000];
            rnd.nextBytes(data);
            BlobKey key = BlobServerPutTest.put((BlobService)server, jobId, data, blobType);
            Assert.assertNotNull((Object)key);
            byte[] data2 = Arrays.copyOf(data, data.length);
            data2[0] = (byte)(data2[0] ^ 1);
            if (corruptOnHAStore) {
                File tmpFile = Files.createTempFile("blob", ".jar", new FileAttribute[0]).toFile();
                try {
                    FileUtils.writeByteArrayToFile((File)tmpFile, (byte[])data2);
                    blobStore.put(tmpFile, jobId, key);
                }
                finally {
                    tmpFile.delete();
                }
                File blobFile = server.getStorageLocation(jobId, key);
                Assert.assertTrue((boolean)blobFile.delete());
            } else {
                File blobFile = server.getStorageLocation(jobId, key);
                Assert.assertTrue((boolean)blobFile.exists());
                FileUtils.writeByteArrayToFile((File)blobFile, (byte[])data2);
            }
            Assertions.assertThatThrownBy(() -> BlobServerGetTest.get((BlobService)cache, jobId, key)).satisfies(FlinkAssertions.anyCauseMatches(IOException.class, (String)"data corruption"));
        }
    }
}

