/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.zookeeper;

import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.HighAvailabilityOptions;
import org.apache.flink.runtime.highavailability.zookeeper.CuratorFrameworkWithUnhandledErrorListener;
import org.apache.flink.runtime.persistence.IntegerResourceVersion;
import org.apache.flink.runtime.persistence.PossibleInconsistentStateException;
import org.apache.flink.runtime.persistence.RetrievableStateStorageHelper;
import org.apache.flink.runtime.persistence.StateHandleStore;
import org.apache.flink.runtime.persistence.TestingLongStateHandleHelper;
import org.apache.flink.runtime.rest.util.NoOpFatalErrorHandler;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.state.RetrievableStateHandle;
import org.apache.flink.runtime.util.ZooKeeperUtils;
import org.apache.flink.runtime.zookeeper.ZooKeeperStateHandleStore;
import org.apache.flink.runtime.zookeeper.ZooKeeperTestEnvironment;
import org.apache.flink.shaded.curator4.org.apache.curator.framework.CuratorFramework;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.KeeperException;
import org.apache.flink.shaded.zookeeper3.org.apache.zookeeper.data.Stat;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsInstanceOf;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class ZooKeeperStateHandleStoreTest
extends TestLogger {
    private static final ZooKeeperTestEnvironment ZOOKEEPER = new ZooKeeperTestEnvironment(1);

    @AfterClass
    public static void tearDown() throws Exception {
        ZOOKEEPER.shutdown();
    }

    @Before
    public void cleanUp() throws Exception {
        ZOOKEEPER.deleteAll();
        TestingLongStateHandleHelper.clearGlobalState();
    }

    @Test
    public void testAddAndLock() throws Exception {
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)longStateStorage);
        String pathInZooKeeper = "/testAdd";
        long state = 1239712317L;
        store.addAndLock("/testAdd", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1239712317L)));
        Assert.assertEquals((long)1L, (long)store.getAllAndLock().size());
        Assert.assertEquals((long)1239712317L, (long)((TestingLongStateHandleHelper.LongStateHandle)((Object)store.getAndLock("/testAdd").retrieveState())).getValue());
        Stat stat = (Stat)ZOOKEEPER.getClient().checkExists().forPath("/testAdd");
        Assert.assertNotNull((Object)stat);
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        List children = (List)ZOOKEEPER.getClient().getChildren().forPath("/testAdd");
        Assert.assertEquals((long)1L, (long)children.size());
        stat = (Stat)ZOOKEEPER.getClient().checkExists().forPath("/testAdd/" + (String)children.get(0));
        Assert.assertNotNull((Object)stat);
        Assert.assertNotEquals((long)0L, (long)stat.getEphemeralOwner());
        long actual = ((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)InstantiationUtil.deserializeObject((byte[])((byte[])ZOOKEEPER.getClient().getData().forPath("/testAdd")), (ClassLoader)ClassLoader.getSystemClassLoader())).retrieveState())).getValue();
        Assert.assertEquals((long)1239712317L, (long)actual);
    }

    @Test
    public void testFailingAddWithPossiblyInconsistentState() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        CuratorFramework client = (CuratorFramework)Mockito.spy((Object)ZOOKEEPER.getClient());
        Mockito.when((Object)client.inTransaction()).thenThrow(new Throwable[]{new RuntimeException("Expected test Exception.")});
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testAddDiscardStateHandleAfterFailure";
        long state = 81282227L;
        try {
            store.addAndLock("/testAddDiscardStateHandleAfterFailure", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(81282227L)));
            Assert.fail((String)"PossibleInconsistentStateException should have been thrown.");
        }
        catch (PossibleInconsistentStateException possibleInconsistentStateException) {
            // empty catch block
        }
        Assert.assertEquals((long)1L, (long)TestingLongStateHandleHelper.getGlobalStorageSize());
        Assert.assertEquals((long)81282227L, (long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0));
        Assert.assertEquals((long)0L, (long)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0));
    }

    @Test
    public void testAddAndLockExistingNode() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        CuratorFramework client = ZOOKEEPER.getClient();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)stateHandleProvider);
        String path = "/test";
        long firstState = 1337L;
        long secondState = 7331L;
        store.addAndLock("/test", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1337L)));
        Assert.assertThrows(StateHandleStore.AlreadyExistException.class, () -> store.addAndLock("/test", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(7331L))));
        Assert.assertEquals((long)1L, (long)TestingLongStateHandleHelper.getGlobalStorageSize());
        Assert.assertEquals((long)1337L, (long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0));
        Assert.assertEquals((long)0L, (long)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0));
        Assert.assertEquals((long)1337L, (long)((TestingLongStateHandleHelper.LongStateHandle)((Object)store.getAndLock("/test").retrieveState())).getValue());
    }

    @Test
    public void testAddAndLockRetrySuccessfulTransaction() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        CuratorFramework client = ZOOKEEPER.getClient();
        ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle> store = new ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle>(client, (RetrievableStateStorageHelper)stateHandleProvider){

            protected void writeStoreHandleTransactionally(String path, byte[] serializedStoreHandle) throws Exception {
                super.writeStoreHandleTransactionally(path, serializedStoreHandle);
                throw new KeeperException.NodeExistsException("Committed transaction has been retried.");
            }
        };
        String path = "/test";
        long firstState = 1337L;
        store.addAndLock("/test", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1337L)));
        Assert.assertEquals((long)1L, (long)TestingLongStateHandleHelper.getGlobalStorageSize());
        Assert.assertEquals((long)1337L, (long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0));
        Assert.assertEquals((long)0L, (long)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0));
        Assert.assertEquals((long)1337L, (long)((TestingLongStateHandleHelper.LongStateHandle)((Object)store.getAndLock("/test").retrieveState())).getValue());
    }

    @Test
    public void testAddFailureHandlingForBadArgumentsException() {
        ZooKeeperStateHandleStoreTest.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.BadArgumentsException());
    }

    @Test
    public void testAddFailureHandlingForNoNodeException() {
        ZooKeeperStateHandleStoreTest.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.NoNodeException());
    }

    @Test
    public void testAddFailureHandlingForNoAuthException() {
        ZooKeeperStateHandleStoreTest.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.NoAuthException());
    }

    @Test
    public void testAddFailureHandlingForBadVersionException() {
        ZooKeeperStateHandleStoreTest.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.BadVersionException());
    }

    @Test
    public void testAddFailureHandlingForAuthFailedException() {
        ZooKeeperStateHandleStoreTest.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.AuthFailedException());
    }

    @Test
    public void testAddFailureHandlingForInvalidACLException() {
        ZooKeeperStateHandleStoreTest.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.InvalidACLException());
    }

    @Test
    public void testAddFailureHandlingForSessionMovedException() {
        ZooKeeperStateHandleStoreTest.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.SessionMovedException());
    }

    @Test
    public void testAddFailureHandlingForNotReadOnlyException() {
        ZooKeeperStateHandleStoreTest.testFailingAddWithStateDiscardTriggeredFor((Exception)new KeeperException.NotReadOnlyException());
    }

    private static void testFailingAddWithStateDiscardTriggeredFor(Exception actualException) {
        ZooKeeperStateHandleStoreTest.testFailingAddWithStateDiscardTriggeredFor(actualException, actualException.getClass());
    }

    private static void testFailingAddWithStateDiscardTriggeredFor(final Exception actualException, Class<? extends Throwable> expectedException) {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle> store = new ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle>(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)stateHandleProvider){

            protected void writeStoreHandleTransactionally(String path, byte[] serializedStoreHandle) throws Exception {
                throw actualException;
            }
        };
        String pathInZooKeeper = "/testAddDiscardStateHandleAfterFailure-" + expectedException.getSimpleName();
        long state = 81282227L;
        try {
            store.addAndLock(pathInZooKeeper, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(81282227L)));
            Assert.fail((String)(expectedException.getSimpleName() + " should have been thrown."));
        }
        catch (Exception ex) {
            Assert.assertThat((Object)ex, (Matcher)IsInstanceOf.instanceOf(expectedException));
        }
        Assert.assertEquals((long)1L, (long)TestingLongStateHandleHelper.getGlobalStorageSize());
        Assert.assertEquals((long)81282227L, (long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0));
        Assert.assertEquals((long)1L, (long)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0));
    }

    @Test
    public void testReplace() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testReplace";
        long initialState = 30968470898L;
        long replaceState = 88383776661L;
        store.addAndLock("/testReplace", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(30968470898L)));
        store.replace("/testReplace", IntegerResourceVersion.valueOf((int)0), (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(88383776661L)));
        Assert.assertEquals((long)2L, (long)TestingLongStateHandleHelper.getGlobalStorageSize());
        Assert.assertEquals((long)30968470898L, (long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0));
        Assert.assertEquals((long)88383776661L, (long)TestingLongStateHandleHelper.getStateHandleValueByIndex(1));
        Stat stat = (Stat)ZOOKEEPER.getClient().checkExists().forPath("/testReplace");
        Assert.assertNotNull((Object)stat);
        Assert.assertEquals((long)0L, (long)stat.getEphemeralOwner());
        long actual = ((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)InstantiationUtil.deserializeObject((byte[])((byte[])ZOOKEEPER.getClient().getData().forPath("/testReplace")), (ClassLoader)ClassLoader.getSystemClassLoader())).retrieveState())).getValue();
        Assert.assertEquals((long)88383776661L, (long)actual);
    }

    @Test(expected=Exception.class)
    public void testReplaceNonExistingPath() throws Exception {
        TestingLongStateHandleHelper stateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)stateStorage);
        store.replace("/testReplaceNonExistingPath", IntegerResourceVersion.valueOf((int)0), (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1L)));
    }

    @Test
    public void testReplaceDiscardStateHandleAfterFailure() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        CuratorFramework client = (CuratorFramework)Mockito.spy((Object)ZOOKEEPER.getClient());
        Mockito.when((Object)client.setData()).thenThrow(new Throwable[]{new RuntimeException("Expected test Exception.")});
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testReplaceDiscardStateHandleAfterFailure";
        long initialState = 30968470898L;
        long replaceState = 88383776661L;
        store.addAndLock("/testReplaceDiscardStateHandleAfterFailure", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(30968470898L)));
        try {
            store.replace("/testReplaceDiscardStateHandleAfterFailure", IntegerResourceVersion.valueOf((int)0), (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(88383776661L)));
            Assert.fail((String)"Did not throw expected exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertEquals((long)2L, (long)TestingLongStateHandleHelper.getGlobalStorageSize());
        Assert.assertEquals((long)30968470898L, (long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0));
        Assert.assertEquals((long)88383776661L, (long)TestingLongStateHandleHelper.getStateHandleValueByIndex(1));
        Assert.assertThat((Object)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(1), (Matcher)Matchers.is((Object)0));
        long actual = ((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)InstantiationUtil.deserializeObject((byte[])((byte[])ZOOKEEPER.getClient().getData().forPath("/testReplaceDiscardStateHandleAfterFailure")), (ClassLoader)ClassLoader.getSystemClassLoader())).retrieveState())).getValue();
        Assert.assertEquals((long)30968470898L, (long)actual);
    }

    @Test
    public void testDiscardAfterReplaceFailureWithNoNodeException() throws Exception {
        ZooKeeperStateHandleStoreTest.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.NoNodeException(), StateHandleStore.NotExistException.class);
    }

    @Test
    public void testDiscardAfterReplaceFailureWithNodeExistsException() throws Exception {
        ZooKeeperStateHandleStoreTest.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.NodeExistsException());
    }

    @Test
    public void testDiscardAfterReplaceFailureWithBadArgumentsException() throws Exception {
        ZooKeeperStateHandleStoreTest.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.BadArgumentsException());
    }

    @Test
    public void testDiscardAfterReplaceFailureWithNoAuthException() throws Exception {
        ZooKeeperStateHandleStoreTest.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.NoAuthException());
    }

    @Test
    public void testDiscardAfterReplaceFailureWithBadVersionException() throws Exception {
        ZooKeeperStateHandleStoreTest.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.BadVersionException());
    }

    @Test
    public void testDiscardAfterReplaceFailureWithAuthFailedException() throws Exception {
        ZooKeeperStateHandleStoreTest.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.AuthFailedException());
    }

    @Test
    public void testDiscardAfterReplaceFailureWithInvalidACLException() throws Exception {
        ZooKeeperStateHandleStoreTest.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.InvalidACLException());
    }

    @Test
    public void testDiscardAfterReplaceFailureWithSessionMovedException() throws Exception {
        ZooKeeperStateHandleStoreTest.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.SessionMovedException());
    }

    @Test
    public void testDiscardAfterReplaceFailureWithNotReadOnlyException() throws Exception {
        ZooKeeperStateHandleStoreTest.testDiscardAfterReplaceFailureWith((Exception)new KeeperException.NotReadOnlyException());
    }

    private static void testDiscardAfterReplaceFailureWith(Exception actualException) throws Exception {
        ZooKeeperStateHandleStoreTest.testDiscardAfterReplaceFailureWith(actualException, actualException.getClass());
    }

    private static void testDiscardAfterReplaceFailureWith(final Exception actualException, Class<? extends Throwable> expectedException) throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle> store = new ZooKeeperStateHandleStore<TestingLongStateHandleHelper.LongStateHandle>(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)stateHandleProvider){

            protected void setStateHandle(String path, byte[] serializedStateHandle, int expectedVersion) throws Exception {
                throw actualException;
            }
        };
        String pathInZooKeeper = "/testReplaceDiscardStateHandleAfterFailure-" + expectedException.getSimpleName();
        long initialState = 30968470898L;
        long replaceState = 88383776661L;
        store.addAndLock(pathInZooKeeper, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(30968470898L)));
        try {
            store.replace(pathInZooKeeper, IntegerResourceVersion.valueOf((int)0), (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(88383776661L)));
            Assert.fail((String)"Did not throw expected exception");
        }
        catch (Throwable t) {
            Assert.assertThat((Object)t, (Matcher)IsInstanceOf.instanceOf(expectedException));
        }
        Assert.assertEquals((long)2L, (long)TestingLongStateHandleHelper.getGlobalStorageSize());
        Assert.assertEquals((long)30968470898L, (long)TestingLongStateHandleHelper.getStateHandleValueByIndex(0));
        Assert.assertEquals((long)88383776661L, (long)TestingLongStateHandleHelper.getStateHandleValueByIndex(1));
        Assert.assertThat((Object)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(0), (Matcher)Matchers.is((Object)0));
        Assert.assertThat((Object)TestingLongStateHandleHelper.getDiscardCallCountForStateHandleByIndex(1), (Matcher)Matchers.is((Object)1));
        long actual = ((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)InstantiationUtil.deserializeObject((byte[])((byte[])ZOOKEEPER.getClient().getData().forPath(pathInZooKeeper)), (ClassLoader)ClassLoader.getSystemClassLoader())).retrieveState())).getValue();
        Assert.assertEquals((long)30968470898L, (long)actual);
    }

    @Test
    public void testGetAndExists() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testGetAndExists";
        long state = 311222268470898L;
        Assert.assertThat((Object)store.exists("/testGetAndExists").isExisting(), (Matcher)Matchers.is((Object)false));
        store.addAndLock("/testGetAndExists", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(311222268470898L)));
        RetrievableStateHandle actual = store.getAndLock("/testGetAndExists");
        Assert.assertEquals((long)311222268470898L, (long)((TestingLongStateHandleHelper.LongStateHandle)((Object)actual.retrieveState())).getValue());
        Assert.assertTrue((store.exists("/testGetAndExists").getValue() >= 0 ? 1 : 0) != 0);
    }

    @Test(expected=Exception.class)
    public void testGetNonExistingPath() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        store.getAndLock("/testGetNonExistingPath");
    }

    @Test
    public void testGetAll() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testGetAll";
        HashSet<Long> expected = new HashSet<Long>();
        expected.add(311222268470898L);
        expected.add(132812888L);
        expected.add(27255442L);
        expected.add(11122233124L);
        Iterator iterator = expected.iterator();
        while (iterator.hasNext()) {
            long val = (Long)iterator.next();
            store.addAndLock("/testGetAll" + val, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(val)));
        }
        for (Tuple2 val : store.getAllAndLock()) {
            Assert.assertTrue((boolean)expected.remove(((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)val.f0).retrieveState())).getValue()));
        }
        Assert.assertEquals((long)0L, (long)expected.size());
    }

    @Test
    public void testGetAllAndLockOnConcurrentDelete() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        CuratorFramework client = ZooKeeperUtils.useNamespaceAndEnsurePath((CuratorFramework)ZOOKEEPER.getClient(), (String)"/testGetAllAndLockOnConcurrentDelete");
        ZooKeeperStateHandleStore storeForCreationAndDeletion = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)stateHandleProvider);
        ZooKeeperStateHandleStore storeForRetrieval = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeperPrefix = "/node";
        long stateForDeletion = 42L;
        String handlePathForDeletion = "/node-for-deletion";
        storeForCreationAndDeletion.addAndLock("/node-for-deletion", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
        long stateToKeep = 44L;
        storeForCreationAndDeletion.addAndLock("/node-keep", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(44L)));
        List actuallyLockedHandles = storeForRetrieval.getAllAndLock(parentPath -> {
            List childNodes = (List)client.getChildren().forPath(parentPath);
            if (storeForCreationAndDeletion.exists("/node-for-deletion").isExisting()) {
                storeForCreationAndDeletion.releaseAndTryRemove("/node-for-deletion");
            }
            return childNodes;
        });
        Assert.assertEquals((String)"Only the StateHandle that was expected to be kept should be returned.", (long)44L, (long)((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)((Tuple2)Iterables.getOnlyElement((Iterable)actuallyLockedHandles)).f0).retrieveState())).getValue());
    }

    @Test
    public void testGetAllSortedByName() throws Exception {
        Object[] expected;
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        String basePath = "/testGetAllSortedByName";
        Object[] objectArray = expected = new Long[]{311222268470898L, 132812888L, 27255442L, 11122233124L};
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            long val = objectArray[i];
            String pathInZooKeeper = String.format("%s%016d", "/testGetAllSortedByName", val);
            store.addAndLock(pathInZooKeeper, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(val)));
        }
        List actual = store.getAllAndLock();
        Assert.assertEquals((long)expected.length, (long)actual.size());
        Arrays.sort(expected);
        Collections.sort(actual, Comparator.comparing(o -> (String)o.f1));
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((Object)expected[i], (Object)((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)((Tuple2)actual.get((int)i)).f0).retrieveState())).getValue());
        }
    }

    @Test
    public void testRemove() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testRemove";
        store.addAndLock("/testRemove", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(27255442L)));
        int numberOfGlobalDiscardCalls = TestingLongStateHandleHelper.getGlobalDiscardCount();
        store.releaseAndTryRemove("/testRemove");
        Assert.assertEquals((long)0L, (long)((List)ZOOKEEPER.getClient().getChildren().forPath("/")).size());
        Assert.assertEquals((long)(numberOfGlobalDiscardCalls + 1), (long)TestingLongStateHandleHelper.getGlobalDiscardCount());
    }

    @Test
    public void testReleaseAndTryRemoveAll() throws Exception {
        TestingLongStateHandleHelper stateHandleProvider = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)stateHandleProvider);
        String pathInZooKeeper = "/testDiscardAll";
        HashSet<Long> expected = new HashSet<Long>();
        expected.add(311222268470898L);
        expected.add(132812888L);
        expected.add(27255442L);
        expected.add(11122233124L);
        Iterator iterator = expected.iterator();
        while (iterator.hasNext()) {
            long val = (Long)iterator.next();
            store.addAndLock("/testDiscardAll" + val, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(val)));
        }
        store.releaseAndTryRemoveAll();
        Assert.assertEquals((long)0L, (long)((List)ZOOKEEPER.getClient().getChildren().forPath("/")).size());
    }

    @Test
    public void testCorruptedData() throws Exception {
        TestingLongStateHandleHelper stateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore store = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)stateStorage);
        HashSet<Long> input = new HashSet<Long>();
        input.add(1L);
        input.add(2L);
        input.add(3L);
        for (Long aLong : input) {
            store.addAndLock("/" + aLong, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(aLong)));
        }
        ZOOKEEPER.getClient().setData().forPath("/2", new byte[2]);
        List allEntries = store.getAllAndLock();
        HashSet expected = new HashSet(input);
        expected.remove(2L);
        HashSet<Long> actual = new HashSet<Long>(expected.size());
        for (Tuple2 entry : allEntries) {
            actual.add(((TestingLongStateHandleHelper.LongStateHandle)((Object)((RetrievableStateHandle)entry.f0).retrieveState())).getValue());
        }
        Assert.assertEquals(expected, actual);
    }

    @Test
    public void testConcurrentDeleteOperation() throws Exception {
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore zkStore1 = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)longStateStorage);
        ZooKeeperStateHandleStore zkStore2 = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)longStateStorage);
        String statePath = "/state";
        zkStore1.addAndLock("/state", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
        RetrievableStateHandle stateHandle = zkStore2.getAndLock("/state");
        zkStore1.releaseAndTryRemove("/state");
        Assert.assertEquals((long)42L, (long)((TestingLongStateHandleHelper.LongStateHandle)((Object)stateHandle.retrieveState())).getValue());
        Stat nodeStat = (Stat)ZOOKEEPER.getClient().checkExists().forPath("/state");
        Assert.assertNotNull((String)"NodeStat should not be null, otherwise the referenced node does not exist.", (Object)nodeStat);
        zkStore2.releaseAndTryRemove("/state");
        nodeStat = (Stat)ZOOKEEPER.getClient().checkExists().forPath("/state");
        Assert.assertNull((String)"NodeState should be null, because the referenced node should no longer exist.", (Object)nodeStat);
    }

    @Test
    public void testLockCleanupWhenGetAndLockFails() throws Exception {
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore zkStore1 = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)longStateStorage);
        ZooKeeperStateHandleStore zkStore2 = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)longStateStorage);
        String path = "/state";
        zkStore1.addAndLock("/state", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
        byte[] corruptedData = new byte[]{1, 2};
        ZOOKEEPER.getClient().setData().forPath("/state", corruptedData);
        try {
            zkStore2.getAndLock("/state");
            Assert.fail((String)"Should fail because we cannot deserialize the node's data");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String lockNodePath = zkStore2.getLockPath("/state");
        Stat stat = (Stat)ZOOKEEPER.getClient().checkExists().forPath(lockNodePath);
        Assert.assertNull((String)"zkStore2 should not have created a lock node.", (Object)stat);
        Collection children = (Collection)ZOOKEEPER.getClient().getChildren().forPath("/state");
        Assert.assertEquals((long)1L, (long)children.size());
        zkStore1.releaseAndTryRemove("/state");
        stat = (Stat)ZOOKEEPER.getClient().checkExists().forPath("/state");
        Assert.assertNull((String)"The state node should have been removed.", (Object)stat);
    }

    @Test
    public void testLockCleanupWhenClientTimesOut() throws Exception {
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        Configuration configuration = new Configuration();
        configuration.setString(HighAvailabilityOptions.HA_ZOOKEEPER_QUORUM, ZOOKEEPER.getConnectString());
        configuration.setInteger(HighAvailabilityOptions.ZOOKEEPER_SESSION_TIMEOUT, 100);
        configuration.setString(HighAvailabilityOptions.HA_ZOOKEEPER_ROOT, "timeout");
        try (CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper = ZooKeeperUtils.startCuratorFramework((Configuration)configuration, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);
             CuratorFrameworkWithUnhandledErrorListener curatorFrameworkWrapper2 = ZooKeeperUtils.startCuratorFramework((Configuration)configuration, (FatalErrorHandler)NoOpFatalErrorHandler.INSTANCE);){
            CuratorFramework client = curatorFrameworkWrapper.asCuratorFramework();
            CuratorFramework client2 = curatorFrameworkWrapper2.asCuratorFramework();
            ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(client, (RetrievableStateStorageHelper)longStateStorage);
            String path = "/state";
            zkStore.addAndLock("/state", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
            client.close();
            Stat stat = (Stat)client2.checkExists().forPath("/state");
            Assert.assertNotNull((Object)stat);
            Collection children = (Collection)client2.getChildren().forPath("/state");
            Assert.assertEquals((long)0L, (long)children.size());
        }
    }

    @Test
    public void testRelease() throws Exception {
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)longStateStorage);
        String path = "/state";
        zkStore.addAndLock("/state", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
        String lockPath = zkStore.getLockPath("/state");
        Stat stat = (Stat)ZOOKEEPER.getClient().checkExists().forPath(lockPath);
        Assert.assertNotNull((String)"Expected an existing lock", (Object)stat);
        zkStore.release("/state");
        stat = (Stat)ZOOKEEPER.getClient().checkExists().forPath("/state");
        Assert.assertEquals((String)"Expected no lock nodes as children", (long)0L, (long)stat.getNumChildren());
        zkStore.releaseAndTryRemove("/state");
        stat = (Stat)ZOOKEEPER.getClient().checkExists().forPath("/state");
        Assert.assertNull((String)"State node should have been removed.", (Object)stat);
    }

    @Test
    public void testReleaseAll() throws Exception {
        Stat stat;
        TestingLongStateHandleHelper longStateStorage = new TestingLongStateHandleHelper();
        ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(ZOOKEEPER.getClient(), (RetrievableStateStorageHelper)longStateStorage);
        List<String> paths = Arrays.asList("/state1", "/state2", "/state3");
        for (String path : paths) {
            zkStore.addAndLock(path, (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(42L)));
        }
        for (String path : paths) {
            stat = (Stat)ZOOKEEPER.getClient().checkExists().forPath(zkStore.getLockPath(path));
            Assert.assertNotNull((String)"Expecte and existing lock.", (Object)stat);
        }
        zkStore.releaseAll();
        for (String path : paths) {
            stat = (Stat)ZOOKEEPER.getClient().checkExists().forPath(path);
            Assert.assertEquals((long)0L, (long)stat.getNumChildren());
        }
        zkStore.releaseAndTryRemoveAll();
        Stat stat2 = (Stat)ZOOKEEPER.getClient().checkExists().forPath("/");
        Assert.assertEquals((long)0L, (long)stat2.getNumChildren());
    }

    @Test
    public void testRemoveAllHandlesShouldRemoveAllPaths() throws Exception {
        ZooKeeperStateHandleStore zkStore = new ZooKeeperStateHandleStore(ZooKeeperUtils.useNamespaceAndEnsurePath((CuratorFramework)ZOOKEEPER.getClient(), (String)"/path"), (RetrievableStateStorageHelper)new TestingLongStateHandleHelper());
        zkStore.addAndLock("/state", (Serializable)((Object)new TestingLongStateHandleHelper.LongStateHandle(1L)));
        zkStore.clearEntries();
        Assert.assertThat((Object)zkStore.getAllHandles(), (Matcher)Matchers.is((Matcher)Matchers.empty()));
    }
}

