/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util;

import org.apache.flink.runtime.util.BoundedFIFOQueue;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.collection.IsIterableContainingInOrder;
import org.hamcrest.collection.IsIterableWithSize;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Test;

public class BoundedFIFOQueueTest
extends TestLogger {
    @Test(expected=IllegalArgumentException.class)
    public void testConstructorFailing() {
        new BoundedFIFOQueue(-1);
    }

    @Test
    public void testQueueWithMaxSize0() {
        BoundedFIFOQueue testInstance = new BoundedFIFOQueue(0);
        Assert.assertThat((Object)testInstance, (Matcher)IsIterableWithSize.iterableWithSize((int)0));
        testInstance.add((Object)1);
        Assert.assertThat((Object)testInstance, (Matcher)IsIterableWithSize.iterableWithSize((int)0));
    }

    @Test
    public void testQueueWithMaxSize2() {
        BoundedFIFOQueue testInstance = new BoundedFIFOQueue(2);
        Assert.assertThat((Object)testInstance, (Matcher)IsIterableWithSize.iterableWithSize((int)0));
        testInstance.add((Object)1);
        Assert.assertThat((Object)testInstance, (Matcher)IsIterableContainingInOrder.contains((Object[])new Integer[]{1}));
        testInstance.add((Object)2);
        Assert.assertThat((Object)testInstance, (Matcher)IsIterableContainingInOrder.contains((Object[])new Integer[]{1, 2}));
        testInstance.add((Object)3);
        Assert.assertThat((Object)testInstance, (Matcher)IsIterableContainingInOrder.contains((Object[])new Integer[]{2, 3}));
    }

    @Test
    public void testAddNullHandling() {
        BoundedFIFOQueue testInstance = new BoundedFIFOQueue(1);
        try {
            testInstance.add(null);
            Assert.fail((String)"A NullPointerException is expected to be thrown.");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        Assert.assertThat((Object)testInstance, (Matcher)IsIterableWithSize.iterableWithSize((int)0));
    }

    @Test
    public void testSizeWithMaxSize0() {
        BoundedFIFOQueue testInstance = new BoundedFIFOQueue(0);
        Assert.assertThat((Object)testInstance.size(), (Matcher)Is.is((Object)0));
        testInstance.add((Object)1);
        Assert.assertThat((Object)testInstance.size(), (Matcher)Is.is((Object)0));
    }

    @Test
    public void testSizeWithMaxSize2() {
        BoundedFIFOQueue testInstance = new BoundedFIFOQueue(2);
        Assert.assertThat((Object)testInstance.size(), (Matcher)Is.is((Object)0));
        testInstance.add((Object)5);
        Assert.assertThat((Object)testInstance.size(), (Matcher)Is.is((Object)1));
        testInstance.add((Object)6);
        Assert.assertThat((Object)testInstance.size(), (Matcher)Is.is((Object)2));
        testInstance.add((Object)7);
        Assert.assertThat((Object)testInstance.size(), (Matcher)Is.is((Object)2));
    }
}

