/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.testutils;

import java.time.Duration;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.util.concurrent.ScheduledExecutor;
import org.apache.flink.util.concurrent.ScheduledExecutorServiceAdapter;

public class TestingUtils {
    public static final Duration TESTING_DURATION = Duration.ofMinutes(2L);
    public static final Time TIMEOUT = Time.minutes((long)1L);
    public static final Duration DEFAULT_AKKA_ASK_TIMEOUT = Duration.ofSeconds(200L);
    private static ScheduledExecutorService sharedExecutorInstance;

    public static Time infiniteTime() {
        return Time.milliseconds((long)Integer.MAX_VALUE);
    }

    public static synchronized ScheduledExecutorService defaultExecutor() {
        if (sharedExecutorInstance == null || sharedExecutorInstance.isShutdown()) {
            sharedExecutorInstance = Executors.newSingleThreadScheduledExecutor();
        }
        return sharedExecutorInstance;
    }

    public static ScheduledExecutor defaultScheduledExecutor() {
        return new ScheduledExecutorServiceAdapter(TestingUtils.defaultExecutor());
    }
}

