/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.metrics;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeutils.base.IntSerializer;
import org.apache.flink.runtime.state.AbstractKeyedStateBackend;
import org.apache.flink.runtime.state.VoidNamespace;
import org.apache.flink.runtime.state.metrics.LatencyTrackingStateTestBase;
import org.apache.flink.runtime.state.metrics.LatencyTrackingValueState;
import org.junit.Assert;
import org.junit.Test;

public class LatencyTrackingValueStateTest
extends LatencyTrackingStateTestBase<Integer> {
    ValueStateDescriptor<Long> getStateDescriptor() {
        return new ValueStateDescriptor("value", Long.class);
    }

    IntSerializer getKeySerializer() {
        return IntSerializer.INSTANCE;
    }

    @Override
    void setCurrentKey(AbstractKeyedStateBackend<Integer> keyedBackend) {
        keyedBackend.setCurrentKey((Object)1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLatencyTrackingValueState() throws Exception {
        AbstractKeyedStateBackend keyedBackend = this.createKeyedBackend(this.getKeySerializer());
        try {
            LatencyTrackingValueState latencyTrackingState = (LatencyTrackingValueState)this.createLatencyTrackingState(keyedBackend, this.getStateDescriptor());
            latencyTrackingState.setCurrentNamespace((Object)VoidNamespace.INSTANCE);
            LatencyTrackingValueState.ValueStateLatencyMetrics latencyTrackingStateMetric = (LatencyTrackingValueState.ValueStateLatencyMetrics)latencyTrackingState.getLatencyTrackingStateMetric();
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getUpdateCount());
            Assert.assertEquals((long)0L, (long)latencyTrackingStateMetric.getGetCount());
            this.setCurrentKey((AbstractKeyedStateBackend<Integer>)keyedBackend);
            for (int index = 1; index <= 10; ++index) {
                int expectedResult = index == 10 ? 0 : index;
                latencyTrackingState.update((Object)ThreadLocalRandom.current().nextLong());
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getUpdateCount());
                latencyTrackingState.value();
                Assert.assertEquals((long)expectedResult, (long)latencyTrackingStateMetric.getGetCount());
            }
        }
        finally {
            if (keyedBackend != null) {
                keyedBackend.close();
                keyedBackend.dispose();
            }
        }
    }
}

