/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.filesystem;

import java.util.Random;
import org.apache.flink.core.fs.Path;
import org.apache.flink.runtime.state.CheckpointStorageLocationReference;
import org.apache.flink.runtime.state.filesystem.AbstractFsCheckpointStorageAccess;
import org.apache.flink.util.StringUtils;
import org.apache.flink.util.TestLogger;
import org.junit.Assert;
import org.junit.Test;

public class FsStorageLocationReferenceTest
extends TestLogger {
    @Test
    public void testEncodeAndDecode() throws Exception {
        Path path = FsStorageLocationReferenceTest.randomPath(new Random());
        try {
            CheckpointStorageLocationReference ref = AbstractFsCheckpointStorageAccess.encodePathAsReference((Path)path);
            Path decoded = AbstractFsCheckpointStorageAccess.decodePathFromReference((CheckpointStorageLocationReference)ref);
            Assert.assertEquals((Object)path, (Object)decoded);
        }
        catch (Error | Exception e) {
            this.log.error("ERROR FOR PATH " + path);
            throw e;
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDecodingTooShortReference() {
        AbstractFsCheckpointStorageAccess.decodePathFromReference((CheckpointStorageLocationReference)new CheckpointStorageLocationReference(new byte[2]));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDecodingGarbage() {
        byte[] bytes = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        AbstractFsCheckpointStorageAccess.decodePathFromReference((CheckpointStorageLocationReference)new CheckpointStorageLocationReference(bytes));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDecodingDefaultReference() {
        AbstractFsCheckpointStorageAccess.decodePathFromReference((CheckpointStorageLocationReference)CheckpointStorageLocationReference.getDefault());
    }

    private static Path randomPath(Random rnd) {
        while (true) {
            try {
                StringBuilder path = new StringBuilder();
                path.append(StringUtils.getRandomString((Random)rnd, (int)1, (int)5, (char)'a', (char)'z'));
                path.append("://");
                path.append(StringUtils.getRandomString((Random)rnd, (int)10, (int)20));
                path.append(":");
                path.append(rnd.nextInt(50000) + 1);
                for (int j = rnd.nextInt(5) + 1; j > 0; --j) {
                    path.append('/');
                    path.append(StringUtils.getRandomString((Random)rnd, (int)3, (int)15));
                }
                return new Path(path.toString());
            }
            catch (Throwable throwable) {
                continue;
            }
            break;
        }
    }
}

