/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.scheduler;

import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.executiongraph.ErrorInfo;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.scheduler.exceptionhistory.RootExceptionHistoryEntry;
import org.apache.flink.shaded.guava30.com.google.common.collect.Iterables;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Test;

public class ExecutionGraphInfoTest {
    @Test
    public void testExecutionGraphHistoryBeingDerivedFromFailedExecutionGraph() {
        ArchivedExecutionGraph executionGraph = ArchivedExecutionGraph.createFromInitializingJob((JobID)new JobID(), (String)"test job name", (JobStatus)JobStatus.FAILED, (Throwable)new RuntimeException("Expected RuntimeException"), null, (long)System.currentTimeMillis());
        ExecutionGraphInfo executionGraphInfo = new ExecutionGraphInfo(executionGraph);
        ErrorInfo failureInfo = executionGraphInfo.getArchivedExecutionGraph().getFailureInfo();
        RootExceptionHistoryEntry actualEntry = (RootExceptionHistoryEntry)Iterables.getOnlyElement((Iterable)executionGraphInfo.getExceptionHistory());
        MatcherAssert.assertThat((Object)failureInfo, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        MatcherAssert.assertThat((Object)failureInfo.getException(), (Matcher)CoreMatchers.is((Object)actualEntry.getException()));
        MatcherAssert.assertThat((Object)failureInfo.getTimestamp(), (Matcher)CoreMatchers.is((Object)actualEntry.getTimestamp()));
        MatcherAssert.assertThat((Object)actualEntry.isGlobal(), (Matcher)CoreMatchers.is((Object)true));
        MatcherAssert.assertThat((Object)actualEntry.getFailingTaskName(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)actualEntry.getTaskManagerLocation(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }
}

