/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.testutils;

import java.util.Collection;
import java.util.Map;
import org.apache.flink.api.common.functions.FlatJoinFunction;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.operators.testutils.Match;
import org.apache.flink.util.Collector;
import org.junit.Assert;

public final class MatchRemovingJoiner
implements FlatJoinFunction<Tuple2<Integer, String>, Tuple2<Integer, String>, Tuple2<Integer, String>> {
    private static final long serialVersionUID = 1L;
    private final Map<Integer, Collection<Match>> toRemoveFrom;

    public MatchRemovingJoiner(Map<Integer, Collection<Match>> map) {
        this.toRemoveFrom = map;
    }

    public void join(Tuple2<Integer, String> rec1, Tuple2<Integer, String> rec2, Collector<Tuple2<Integer, String>> out) throws Exception {
        boolean contained;
        Integer key = rec1 != null ? (Integer)rec1.getField(0) : (Integer)rec2.getField(0);
        String value1 = rec1 != null ? (String)rec1.getField(1) : null;
        String value2 = rec2 != null ? (String)rec2.getField(1) : null;
        Collection<Match> matches = this.toRemoveFrom.get(key);
        if (matches == null) {
            Assert.fail((String)("Match " + key + " - " + value1 + ":" + value2 + " is unexpected."));
        }
        if (!(contained = matches.remove(new Match(value1, value2)))) {
            Assert.fail((String)("Produced match was not contained: " + key + " - " + value1 + ":" + value2));
        }
        if (matches.isEmpty()) {
            this.toRemoveFrom.remove(key);
        }
    }
}

