/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.hash;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypePairComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.base.LongComparator;
import org.apache.flink.api.common.typeutils.base.LongSerializer;
import org.apache.flink.api.common.typeutils.base.StringSerializer;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.api.java.typeutils.runtime.TupleComparator;
import org.apache.flink.api.java.typeutils.runtime.TupleSerializer;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.operators.hash.AbstractHashTableProber;
import org.apache.flink.runtime.operators.hash.AbstractMutableHashTable;
import org.apache.flink.runtime.operators.testutils.UniformStringPairGenerator;
import org.apache.flink.runtime.operators.testutils.types.IntList;
import org.apache.flink.runtime.operators.testutils.types.IntListComparator;
import org.apache.flink.runtime.operators.testutils.types.IntListPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntListSerializer;
import org.apache.flink.runtime.operators.testutils.types.IntPair;
import org.apache.flink.runtime.operators.testutils.types.IntPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntPairListPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntPairPairComparator;
import org.apache.flink.runtime.operators.testutils.types.IntPairSerializer;
import org.apache.flink.runtime.operators.testutils.types.StringPair;
import org.apache.flink.runtime.operators.testutils.types.StringPairComparator;
import org.apache.flink.runtime.operators.testutils.types.StringPairPairComparator;
import org.apache.flink.runtime.operators.testutils.types.StringPairSerializer;
import org.apache.flink.util.MutableObjectIterator;
import org.junit.Assert;
import org.junit.Test;

public abstract class MutableHashTableTestBase {
    protected static final long RANDOM_SEED = 76518743207143L;
    private static final int KEY_VALUE_DIFF = 1021;
    public final int PAGE_SIZE = 16384;
    public final TypeSerializer<IntPair> intPairSerializer = new IntPairSerializer();
    public final TypeComparator<IntPair> intPairComparator = new IntPairComparator();
    public final TypePairComparator<IntPair, IntPair> pairComparator = new IntPairPairComparator();
    private static final int MAX_LIST_SIZE = 8;
    public final TypeSerializer<IntList> serializerV = new IntListSerializer();
    public final TypeComparator<IntList> comparatorV = new IntListComparator();
    public final TypePairComparator<IntList, IntList> pairComparatorV = new IntListPairComparator();
    public final TypePairComparator<IntPair, IntList> pairComparatorPL = new IntPairListPairComparator();
    protected TupleSerializer<Tuple2<Long, String>> tuple2LongStringSerializer = new TupleSerializer(Tuple2.class, new TypeSerializer[]{LongSerializer.INSTANCE, StringSerializer.INSTANCE});
    protected TupleComparator<Tuple2<Long, String>> tuple2LongStringComparator = new TupleComparator(new int[]{0}, new TypeComparator[]{new LongComparator(true)}, new TypeSerializer[]{LongSerializer.INSTANCE});
    public final int SIZE = 75;
    public final int NUM_PAIRS = 100000;
    public final int NUM_LISTS = 100000;
    protected final int ADDITIONAL_MEM = 100;
    private final int NUM_REWRITES = 10;
    public final TypeSerializer<StringPair> serializerS = new StringPairSerializer();
    public final TypeComparator<StringPair> comparatorS = new StringPairComparator();
    private final TypePairComparator<StringPair, StringPair> pairComparatorS = new StringPairPairComparator();

    protected abstract <T> AbstractMutableHashTable<T> getHashTable(TypeSerializer<T> var1, TypeComparator<T> var2, List<MemorySegment> var3);

    @Test
    public void testDifferentProbers() {
        AbstractHashTableProber prober2;
        int NUM_MEM_PAGES = 195;
        AbstractMutableHashTable<IntPair> table = this.getHashTable(this.intPairSerializer, this.intPairComparator, this.getMemory(195));
        AbstractHashTableProber prober1 = table.getProber(this.intPairComparator, this.pairComparator);
        Assert.assertFalse((prober1 == (prober2 = table.getProber(this.intPairComparator, this.pairComparator)) ? 1 : 0) != 0);
        table.close();
        Assert.assertEquals((String)"Memory lost", (long)195L, (long)table.getFreeMemory().size());
    }

    @Test
    public void testBuildAndRetrieve() throws Exception {
        int NUM_MEM_PAGES = 195;
        AbstractMutableHashTable<IntPair> table = this.getHashTable(this.intPairSerializer, this.intPairComparator, this.getMemory(195));
        Random rnd = new Random(76518743207143L);
        IntPair[] pairs = MutableHashTableTestBase.getRandomizedIntPairs(100000, rnd);
        table.open();
        for (int i = 0; i < 100000; ++i) {
            table.insert((Object)pairs[i]);
        }
        AbstractHashTableProber prober = table.getProber(this.intPairComparator, this.pairComparator);
        IntPair target = new IntPair();
        for (int i = 0; i < 100000; ++i) {
            Assert.assertNotNull((Object)prober.getMatchFor((Object)pairs[i], (Object)target));
            Assert.assertEquals((long)pairs[i].getValue(), (long)target.getValue());
        }
        table.close();
        Assert.assertEquals((String)"Memory lost", (long)195L, (long)table.getFreeMemory().size());
    }

    @Test
    public void testEntryIterator() throws Exception {
        int NUM_MEM_PAGES = 457;
        AbstractMutableHashTable<IntList> table = this.getHashTable(this.serializerV, this.comparatorV, this.getMemory(457));
        Random rnd = new Random(76518743207143L);
        IntList[] lists = MutableHashTableTestBase.getRandomizedIntLists(100000, rnd);
        table.open();
        int result = 0;
        for (int i = 0; i < 100000; ++i) {
            table.insert((Object)lists[i]);
            result += lists[i].getKey();
        }
        MutableObjectIterator iter = table.getEntryIterator();
        IntList target = new IntList();
        int sum = 0;
        while ((target = (IntList)iter.next((Object)target)) != null) {
            sum += target.getKey();
        }
        table.close();
        Assert.assertTrue((sum == result ? 1 : 0) != 0);
        Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
    }

    @Test
    public void testMultipleProbers() throws Exception {
        int NUM_MEM_PAGES = 457;
        AbstractMutableHashTable<IntList> table = this.getHashTable(this.serializerV, this.comparatorV, this.getMemory(457));
        Random rnd = new Random(76518743207143L);
        IntList[] lists = MutableHashTableTestBase.getRandomizedIntLists(100000, rnd);
        IntPair[] pairs = MutableHashTableTestBase.getRandomizedIntPairs(100000, rnd);
        table.open();
        for (int i = 0; i < 100000; ++i) {
            table.insert((Object)lists[i]);
        }
        AbstractHashTableProber listProber = table.getProber(this.comparatorV, this.pairComparatorV);
        AbstractHashTableProber pairProber = table.getProber(this.intPairComparator, this.pairComparatorPL);
        IntList target = new IntList();
        for (int i = 0; i < 100000; ++i) {
            Assert.assertNotNull((Object)pairProber.getMatchFor((Object)pairs[i], (Object)target));
            Assert.assertNotNull((Object)listProber.getMatchFor((Object)lists[i], (Object)target));
            Assert.assertArrayEquals((int[])lists[i].getValue(), (int[])target.getValue());
        }
        table.close();
        Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
    }

    @Test
    public void testVariableLengthBuildAndRetrieve() throws Exception {
        int i;
        int NUM_MEM_PAGES = 457;
        AbstractMutableHashTable<IntList> table = this.getHashTable(this.serializerV, this.comparatorV, this.getMemory(457));
        Random rnd = new Random(76518743207143L);
        IntList[] lists = MutableHashTableTestBase.getRandomizedIntLists(100000, rnd);
        table.open();
        for (int i2 = 0; i2 < 100000; ++i2) {
            table.insert((Object)lists[i2]);
            continue;
        }
        AbstractHashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
        IntList target = new IntList();
        for (int i3 = 0; i3 < 100000; ++i3) {
            Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i3], (Object)target));
            Assert.assertArrayEquals((int[])lists[i3].getValue(), (int[])target.getValue());
        }
        IntList[] overwriteLists = MutableHashTableTestBase.getRandomizedIntLists(100000, rnd);
        for (i = 0; i < 100000; ++i) {
            table.insertOrReplaceRecord((Object)overwriteLists[i]);
        }
        for (i = 0; i < 100000; ++i) {
            Assert.assertNotNull((String)("" + i), (Object)prober.getMatchFor((Object)overwriteLists[i], (Object)target));
            Assert.assertArrayEquals((int[])overwriteLists[i].getValue(), (int[])target.getValue());
        }
        table.close();
        Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
    }

    @Test
    public void testVariableLengthBuildAndRetrieveMajorityUpdated() throws Exception {
        int i;
        int NUM_MEM_PAGES = 457;
        AbstractMutableHashTable<IntList> table = this.getHashTable(this.serializerV, this.comparatorV, this.getMemory(457));
        Random rnd = new Random(76518743207143L);
        IntList[] lists = MutableHashTableTestBase.getRandomizedIntLists(100000, rnd);
        table.open();
        for (int i2 = 0; i2 < 100000; ++i2) {
            table.insert((Object)lists[i2]);
        }
        AbstractHashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
        IntList target = new IntList();
        for (int i3 = 0; i3 < 100000; ++i3) {
            Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i3], (Object)target));
            Assert.assertArrayEquals((int[])lists[i3].getValue(), (int[])target.getValue());
        }
        IntList[] overwriteLists = MutableHashTableTestBase.getRandomizedIntLists(100000, rnd);
        for (i = 0; i < 100000; ++i) {
            if (i % 100 == 0) continue;
            table.insertOrReplaceRecord((Object)overwriteLists[i]);
            lists[i] = overwriteLists[i];
        }
        for (i = 0; i < 100000; ++i) {
            Assert.assertNotNull((String)("" + i), (Object)prober.getMatchFor((Object)lists[i], (Object)target));
            Assert.assertArrayEquals((int[])lists[i].getValue(), (int[])target.getValue());
        }
        table.close();
        Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
    }

    @Test
    public void testVariableLengthBuildAndRetrieveMinorityUpdated() throws Exception {
        int i;
        int NUM_LISTS = 20000;
        int NUM_MEM_PAGES = 91;
        AbstractMutableHashTable<IntList> table = this.getHashTable(this.serializerV, this.comparatorV, this.getMemory(91));
        int STEP_SIZE = 100;
        Random rnd = new Random(76518743207143L);
        IntList[] lists = MutableHashTableTestBase.getRandomizedIntLists(20000, rnd);
        table.open();
        for (int i2 = 0; i2 < 20000; ++i2) {
            table.insert((Object)lists[i2]);
        }
        AbstractHashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
        IntList target = new IntList();
        for (int i3 = 0; i3 < 20000; ++i3) {
            Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i3], (Object)target));
            Assert.assertArrayEquals((int[])lists[i3].getValue(), (int[])target.getValue());
        }
        IntList[] overwriteLists = MutableHashTableTestBase.getRandomizedIntLists(200, rnd);
        for (i = 0; i < 20000; i += 100) {
            overwriteLists[i / 100].setKey(overwriteLists[i / 100].getKey() * 100);
            table.insertOrReplaceRecord((Object)overwriteLists[i / 100]);
            lists[i] = overwriteLists[i / 100];
        }
        for (i = 0; i < 20000; ++i) {
            Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i], (Object)target));
            Assert.assertArrayEquals((int[])lists[i].getValue(), (int[])target.getValue());
        }
        table.close();
        Assert.assertEquals((String)"Memory lost", (long)91L, (long)table.getFreeMemory().size());
    }

    @Test
    public void testRepeatedBuildAndRetrieve() throws Exception {
        int NUM_MEM_PAGES = 457;
        AbstractMutableHashTable<IntList> table = this.getHashTable(this.serializerV, this.comparatorV, this.getMemory(457));
        Random rnd = new Random(76518743207143L);
        IntList[] lists = MutableHashTableTestBase.getRandomizedIntLists(100000, rnd);
        table.open();
        for (int i = 0; i < 100000; ++i) {
            table.insert((Object)lists[i]);
            continue;
        }
        AbstractHashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
        IntList target = new IntList();
        for (int i = 0; i < 100000; ++i) {
            Assert.assertNotNull((Object)prober.getMatchFor((Object)lists[i], (Object)target));
            Assert.assertArrayEquals((int[])lists[i].getValue(), (int[])target.getValue());
        }
        for (int k = 0; k < 10; ++k) {
            int i;
            IntList[] overwriteLists = MutableHashTableTestBase.getRandomizedIntLists(100000, rnd);
            for (i = 0; i < 100000; ++i) {
                table.insertOrReplaceRecord((Object)overwriteLists[i]);
            }
            for (i = 0; i < 100000; ++i) {
                Assert.assertNotNull((String)("" + i), (Object)prober.getMatchFor((Object)overwriteLists[i], (Object)target));
                Assert.assertArrayEquals((int[])overwriteLists[i].getValue(), (int[])target.getValue());
            }
        }
        table.close();
        Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
    }

    @Test
    public void testProberUpdate() throws Exception {
        int i;
        int NUM_MEM_PAGES = 457;
        AbstractMutableHashTable<IntList> table = this.getHashTable(this.serializerV, this.comparatorV, this.getMemory(457));
        Random rnd = new Random(76518743207143L);
        IntList[] lists = MutableHashTableTestBase.getRandomizedIntLists(100000, rnd);
        table.open();
        for (int i2 = 0; i2 < 100000; ++i2) {
            table.insert((Object)lists[i2]);
        }
        IntList[] overwriteLists = MutableHashTableTestBase.getRandomizedIntLists(100000, rnd);
        AbstractHashTableProber prober = table.getProber(this.comparatorV, this.pairComparatorV);
        IntList target = new IntList();
        for (i = 0; i < 100000; ++i) {
            Assert.assertNotNull((String)("" + i), (Object)prober.getMatchFor((Object)lists[i], (Object)target));
            Assert.assertArrayEquals((int[])lists[i].getValue(), (int[])target.getValue());
            prober.updateMatch((Object)overwriteLists[i]);
        }
        for (i = 0; i < 100000; ++i) {
            Assert.assertNotNull((String)("" + i), (Object)prober.getMatchFor((Object)overwriteLists[i], (Object)target));
            Assert.assertArrayEquals((int[])overwriteLists[i].getValue(), (int[])target.getValue());
        }
        table.close();
        Assert.assertEquals((String)"Memory lost", (long)457L, (long)table.getFreeMemory().size());
    }

    @Test
    public void testVariableLengthStringBuildAndRetrieve() throws IOException {
        int NUM_MEM_PAGES = 244;
        AbstractMutableHashTable<StringPair> table = this.getHashTable(this.serializerS, this.comparatorS, this.getMemory(244));
        UniformStringPairGenerator buildInput = new UniformStringPairGenerator(100000, 1, false);
        UniformStringPairGenerator probeTester = new UniformStringPairGenerator(100000, 1, false);
        UniformStringPairGenerator updater = new UniformStringPairGenerator(100000, 1, false);
        UniformStringPairGenerator updateTester = new UniformStringPairGenerator(100000, 1, false);
        table.open();
        StringPair target = new StringPair();
        while (buildInput.next(target) != null) {
            table.insert((Object)target);
        }
        AbstractHashTableProber prober = table.getProber(this.comparatorS, this.pairComparatorS);
        StringPair temp = new StringPair();
        while (probeTester.next(target) != null) {
            Assert.assertNotNull((String)("" + target.getKey()), (Object)prober.getMatchFor((Object)target, (Object)temp));
            Assert.assertEquals((Object)temp.getValue(), (Object)target.getValue());
        }
        while (updater.next(target) != null) {
            target.setValue(target.getValue());
            table.insertOrReplaceRecord((Object)target);
        }
        while (updateTester.next(target) != null) {
            Assert.assertNotNull((Object)prober.getMatchFor((Object)target, (Object)temp));
            Assert.assertEquals((Object)target.getValue(), (Object)temp.getValue());
        }
        table.close();
        Assert.assertEquals((String)"Memory lost", (long)244L, (long)table.getFreeMemory().size());
    }

    protected static IntPair[] getRandomizedIntPairs(int num, Random rnd) {
        int i;
        IntPair[] pairs = new IntPair[num];
        for (i = 0; i < num; ++i) {
            pairs[i] = new IntPair(i, i + 1021);
        }
        for (i = 0; i < 2 * num; ++i) {
            int pos1 = rnd.nextInt(num);
            int pos2 = rnd.nextInt(num);
            IntPair tmp = pairs[pos1];
            pairs[pos1] = pairs[pos2];
            pairs[pos2] = tmp;
        }
        return pairs;
    }

    protected static IntList[] getRandomizedIntLists(int num, Random rnd) {
        IntList[] lists = new IntList[num];
        for (int i = 0; i < num; ++i) {
            int[] value = new int[rnd.nextInt(8) + 1];
            for (int j = 0; j < value.length; ++j) {
                value[j] = -rnd.nextInt(Integer.MAX_VALUE);
            }
            lists[i] = new IntList(i, value);
        }
        return lists;
    }

    public List<MemorySegment> getMemory(int numPages) {
        return MutableHashTableTestBase.getMemory(numPages, 16384);
    }

    private static List<MemorySegment> getMemory(int numSegments, int segmentSize) {
        ArrayList<MemorySegment> list = new ArrayList<MemorySegment>(numSegments);
        for (int i = 0; i < numSegments; ++i) {
            list.add(MemorySegmentFactory.allocateUnpooledSegment((int)segmentSize));
        }
        return list;
    }
}

