/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.operators.coordination;

import java.time.Duration;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flink.core.testutils.ManuallyTriggeredScheduledExecutorService;
import org.apache.flink.runtime.operators.coordination.ComponentClosingUtils;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.ManualClock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ComponentClosingUtilsTest {
    private ManualClock clock;

    @Before
    public void setup() {
        this.clock = new ManualClock();
        ComponentClosingUtils.setClock((Clock)this.clock);
    }

    @Test
    public void testTryShutdownExecutorElegantlyWithoutForcefulShutdown() {
        MockExecutorService executor = new MockExecutorService(0);
        Assert.assertTrue((boolean)ComponentClosingUtils.tryShutdownExecutorElegantly((ExecutorService)((Object)executor), (Duration)Duration.ofDays(1L)));
        Assert.assertEquals((long)0L, (long)executor.forcefullyShutdownCount);
    }

    @Test
    public void testTryShutdownExecutorElegantlyWithForcefulShutdown() {
        MockExecutorService executor = new MockExecutorService(5);
        Assert.assertFalse((boolean)ComponentClosingUtils.tryShutdownExecutorElegantly((ExecutorService)((Object)executor), (Duration)Duration.ofDays(1L)));
        Assert.assertEquals((long)1L, (long)executor.forcefullyShutdownCount);
    }

    @Test
    public void testTryShutdownExecutorElegantlyTimeoutWithForcefulShutdown() {
        MockExecutorService executor = new MockExecutorService(5);
        executor.timeoutAfterNumForcefulShutdown(this.clock, 0);
        Assert.assertFalse((boolean)ComponentClosingUtils.tryShutdownExecutorElegantly((ExecutorService)((Object)executor), (Duration)Duration.ofDays(1L)));
        Assert.assertEquals((long)1L, (long)executor.forcefullyShutdownCount);
    }

    @Test
    public void testTryShutdownExecutorElegantlyInterruptedWithForcefulShutdown() {
        MockExecutorService executor = new MockExecutorService(5);
        executor.interruptAfterNumForcefulShutdown(0);
        Assert.assertFalse((boolean)ComponentClosingUtils.tryShutdownExecutorElegantly((ExecutorService)((Object)executor), (Duration)Duration.ofDays(1L)));
        Assert.assertEquals((long)1L, (long)executor.forcefullyShutdownCount);
    }

    @Test
    public void testShutdownExecutorForcefully() {
        MockExecutorService executor = new MockExecutorService(5);
        Assert.assertTrue((boolean)ComponentClosingUtils.shutdownExecutorForcefully((ExecutorService)((Object)executor), (Duration)Duration.ofDays(1L), (boolean)false));
        Assert.assertEquals((long)5L, (long)executor.forcefullyShutdownCount);
    }

    @Test
    public void testShutdownExecutorForcefullyReachesTimeout() {
        MockExecutorService executor = new MockExecutorService(5);
        executor.timeoutAfterNumForcefulShutdown(this.clock, 1);
        Assert.assertFalse((boolean)ComponentClosingUtils.shutdownExecutorForcefully((ExecutorService)((Object)executor), (Duration)Duration.ofDays(1L), (boolean)false));
        Assert.assertEquals((long)1L, (long)executor.forcefullyShutdownCount);
    }

    @Test
    public void testShutdownExecutorForcefullyNotInterruptable() {
        MockExecutorService executor = new MockExecutorService(5);
        executor.interruptAfterNumForcefulShutdown(1);
        Assert.assertTrue((boolean)ComponentClosingUtils.shutdownExecutorForcefully((ExecutorService)((Object)executor), (Duration)Duration.ofDays(1L), (boolean)false));
        Assert.assertEquals((long)5L, (long)executor.forcefullyShutdownCount);
    }

    @Test
    public void testShutdownExecutorForcefullyInterruptable() {
        MockExecutorService executor = new MockExecutorService(5);
        executor.interruptAfterNumForcefulShutdown(1);
        Assert.assertFalse((boolean)ComponentClosingUtils.shutdownExecutorForcefully((ExecutorService)((Object)executor), (Duration)Duration.ofDays(1L), (boolean)true));
        Assert.assertEquals((long)1L, (long)executor.forcefullyShutdownCount);
    }

    private static final class MockExecutorService
    extends ManuallyTriggeredScheduledExecutorService {
        private final int numRequiredForcefullyShutdown;
        private ManualClock clock;
        private int forcefullyShutdownCount;
        private int interruptAfterNumForcefulShutdown = Integer.MAX_VALUE;
        private int timeoutAfterNumForcefulShutdown = Integer.MAX_VALUE;

        private MockExecutorService(int numRequiredForcefullyShutdown) {
            this.numRequiredForcefullyShutdown = numRequiredForcefullyShutdown;
            this.forcefullyShutdownCount = 0;
        }

        public List<Runnable> shutdownNow() {
            ++this.forcefullyShutdownCount;
            return super.shutdownNow();
        }

        public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
            if (this.forcefullyShutdownCount < this.numRequiredForcefullyShutdown) {
                if (this.forcefullyShutdownCount >= this.timeoutAfterNumForcefulShutdown) {
                    this.clock.advanceTime(Duration.ofDays(100L));
                }
                if (this.forcefullyShutdownCount >= this.interruptAfterNumForcefulShutdown) {
                    throw new InterruptedException();
                }
            }
            return super.awaitTermination(timeout, unit) && this.reachedForcefulShutdownCount();
        }

        public boolean isTerminated() {
            return super.isTerminated() && this.reachedForcefulShutdownCount();
        }

        public void interruptAfterNumForcefulShutdown(int interruptAfterNumForcefulShutdown) {
            this.interruptAfterNumForcefulShutdown = interruptAfterNumForcefulShutdown;
        }

        public void timeoutAfterNumForcefulShutdown(ManualClock clock, int timeoutAfterNumForcefulShutdown) {
            this.clock = clock;
            this.timeoutAfterNumForcefulShutdown = timeoutAfterNumForcefulShutdown;
        }

        private boolean reachedForcefulShutdownCount() {
            return this.forcefullyShutdownCount >= this.numRequiredForcefullyShutdown;
        }
    }
}

