/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.network.partition;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.BufferBuilderTestUtils;
import org.apache.flink.runtime.io.network.buffer.BufferConsumer;
import org.apache.flink.runtime.io.network.partition.BufferAvailabilityListener;
import org.apache.flink.runtime.io.network.partition.NoOpBufferAvailablityListener;
import org.apache.flink.runtime.io.network.partition.PartitionTestUtils;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartition;
import org.apache.flink.runtime.io.network.partition.PipelinedSubpartitionView;
import org.apache.flink.runtime.io.network.partition.ResultPartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartition;
import org.apache.flink.runtime.io.network.partition.ResultSubpartitionView;
import org.apache.flink.runtime.io.network.partition.SubpartitionTestBase;
import org.apache.flink.runtime.io.network.util.TestConsumerCallback;
import org.apache.flink.runtime.io.network.util.TestProducerSource;
import org.apache.flink.runtime.io.network.util.TestSubpartitionConsumer;
import org.apache.flink.runtime.io.network.util.TestSubpartitionProducer;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.CheckedSupplier;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class PipelinedSubpartitionTest
extends SubpartitionTestBase {
    private static final ExecutorService executorService = Executors.newCachedThreadPool();

    @AfterClass
    public static void shutdownExecutorService() throws Exception {
        executorService.shutdownNow();
    }

    PipelinedSubpartition createSubpartition() throws Exception {
        return PipelinedSubpartitionTest.createPipelinedSubpartition();
    }

    @Override
    ResultSubpartition createFailingWritesSubpartition() throws Exception {
        Assume.assumeTrue((boolean)false);
        return null;
    }

    @Test
    public void testIllegalReadViewRequest() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        Assert.assertNotNull((Object)subpartition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener()));
        try {
            subpartition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
            Assert.fail((String)"Did not throw expected exception after duplicate notifyNonEmpty view request.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testIsReleasedChecksParent() {
        PipelinedSubpartition subpartition = (PipelinedSubpartition)Mockito.mock(PipelinedSubpartition.class);
        PipelinedSubpartitionView reader = new PipelinedSubpartitionView(subpartition, (BufferAvailabilityListener)Mockito.mock(BufferAvailabilityListener.class));
        Assert.assertFalse((boolean)reader.isReleased());
        ((PipelinedSubpartition)Mockito.verify((Object)subpartition, (VerificationMode)Mockito.times((int)1))).isReleased();
        Mockito.when((Object)subpartition.isReleased()).thenReturn((Object)true);
        Assert.assertTrue((boolean)reader.isReleased());
        ((PipelinedSubpartition)Mockito.verify((Object)subpartition, (VerificationMode)Mockito.times((int)2))).isReleased();
    }

    @Test
    public void testConcurrentFastProduceAndFastConsume() throws Exception {
        this.testProduceConsume(false, false);
    }

    @Test
    public void testConcurrentFastProduceAndSlowConsume() throws Exception {
        this.testProduceConsume(false, true);
    }

    @Test
    public void testConcurrentSlowProduceAndFastConsume() throws Exception {
        this.testProduceConsume(true, false);
    }

    @Test
    public void testConcurrentSlowProduceAndSlowConsume() throws Exception {
        this.testProduceConsume(true, true);
    }

    private void testProduceConsume(boolean isSlowProducer, boolean isSlowConsumer) throws Exception {
        int producerNumberOfBuffersToProduce = 128;
        int bufferSize = 32768;
        TestProducerSource producerSource = new TestProducerSource(){
            private int numberOfBuffers;

            @Override
            public TestProducerSource.BufferAndChannel getNextBuffer() throws Exception {
                if (this.numberOfBuffers == 128) {
                    return null;
                }
                MemorySegment segment = MemorySegmentFactory.allocateUnpooledSegment((int)32768);
                int next = this.numberOfBuffers * 8192;
                for (int i = 0; i < 32768; i += 4) {
                    segment.putInt(i, next);
                    ++next;
                }
                ++this.numberOfBuffers;
                return new TestProducerSource.BufferAndChannel(segment.getArray(), 0);
            }
        };
        TestConsumerCallback consumerCallback = new TestConsumerCallback(){
            private int numberOfBuffers;

            @Override
            public void onBuffer(Buffer buffer) {
                MemorySegment segment = buffer.getMemorySegment();
                Assert.assertEquals((long)segment.size(), (long)buffer.getSize());
                int expected = this.numberOfBuffers * (segment.size() / 4);
                for (int i = 0; i < segment.size(); i += 4) {
                    Assert.assertEquals((long)expected, (long)segment.getInt(i));
                    ++expected;
                }
                ++this.numberOfBuffers;
                buffer.recycleBuffer();
            }

            @Override
            public void onEvent(AbstractEvent event) {
            }
        };
        PipelinedSubpartition subpartition = this.createSubpartition();
        TestSubpartitionProducer producer = new TestSubpartitionProducer((ResultSubpartition)subpartition, isSlowProducer, producerSource);
        TestSubpartitionConsumer consumer = new TestSubpartitionConsumer(isSlowConsumer, consumerCallback);
        PipelinedSubpartitionView view = subpartition.createReadView((BufferAvailabilityListener)consumer);
        consumer.setSubpartitionView((ResultSubpartitionView)view);
        CompletableFuture producerResult = CompletableFuture.supplyAsync(CheckedSupplier.unchecked(producer::call), executorService);
        CompletableFuture consumerResult = CompletableFuture.supplyAsync(CheckedSupplier.unchecked(consumer::call), executorService);
        FutureUtils.waitForAll(Arrays.asList(producerResult, consumerResult)).get(60000L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void testCleanupReleasedPartitionNoView() throws Exception {
        this.testCleanupReleasedPartition(false);
    }

    @Test
    public void testCleanupReleasedPartitionWithView() throws Exception {
        this.testCleanupReleasedPartition(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCleanupReleasedPartition(boolean createView) throws Exception {
        boolean buffer2Recycled;
        boolean buffer1Recycled;
        PipelinedSubpartition partition = this.createSubpartition();
        BufferConsumer buffer1 = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096);
        BufferConsumer buffer2 = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096);
        try {
            partition.add(buffer1);
            partition.add(buffer2);
            Assert.assertEquals((long)2L, (long)partition.getNumberOfQueuedBuffers());
            PipelinedSubpartitionView view = null;
            if (createView) {
                view = partition.createReadView((BufferAvailabilityListener)new NoOpBufferAvailablityListener());
            }
            partition.release();
            Assert.assertEquals((long)0L, (long)partition.getNumberOfQueuedBuffers());
            Assert.assertTrue((boolean)partition.isReleased());
            if (createView) {
                Assert.assertTrue((boolean)view.isReleased());
            }
            Assert.assertTrue((boolean)buffer1.isRecycled());
        }
        finally {
            buffer1Recycled = buffer1.isRecycled();
            if (!buffer1Recycled) {
                buffer1.close();
            }
            if (!(buffer2Recycled = buffer2.isRecycled())) {
                buffer2.close();
            }
        }
        if (!buffer1Recycled) {
            Assert.fail((String)"buffer 1 not recycled");
        }
        if (!buffer2Recycled) {
            Assert.fail((String)"buffer 2 not recycled");
        }
        Assert.assertEquals((long)2L, (long)partition.getTotalNumberOfBuffers());
        Assert.assertEquals((long)0L, (long)partition.getTotalNumberOfBytes());
    }

    @Test
    public void testReleaseParent() throws Exception {
        PipelinedSubpartition partition = this.createSubpartition();
        this.verifyViewReleasedAfterParentRelease((ResultSubpartition)partition);
    }

    @Test
    public void testNumberOfQueueBuffers() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096));
        Assert.assertEquals((long)1L, (long)subpartition.getNumberOfQueuedBuffers());
        subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4096));
        Assert.assertEquals((long)2L, (long)subpartition.getNumberOfQueuedBuffers());
        subpartition.getNextBuffer();
        Assert.assertEquals((long)1L, (long)subpartition.getNumberOfQueuedBuffers());
    }

    @Test
    public void testNewBufferSize() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4)));
        subpartition.bufferSize(42);
        Assert.assertEquals((long)42L, (long)subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegativeNewBufferSize() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4)));
        subpartition.bufferSize(-1);
    }

    @Test
    public void testNegativeBufferSizeAsSignOfAddingFail() throws Exception {
        PipelinedSubpartition subpartition = this.createSubpartition();
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4)));
        subpartition.finish();
        Assert.assertEquals((long)-1L, (long)subpartition.add(BufferBuilderTestUtils.createFilledFinishedBufferConsumer(4)));
    }

    private void verifyViewReleasedAfterParentRelease(ResultSubpartition partition) throws Exception {
        BufferConsumer bufferConsumer = BufferBuilderTestUtils.createFilledFinishedBufferConsumer(32768);
        partition.add(bufferConsumer);
        partition.finish();
        BufferAvailabilityListener listener = (BufferAvailabilityListener)Mockito.mock(BufferAvailabilityListener.class);
        ResultSubpartitionView view = partition.createReadView(listener);
        Assert.assertNotNull((Object)view.getNextBuffer());
        Assert.assertNotNull((Object)view.getNextBuffer());
        Assert.assertFalse((boolean)view.isReleased());
        partition.release();
        Assert.assertTrue((boolean)view.isReleased());
    }

    public static PipelinedSubpartition createPipelinedSubpartition() {
        ResultPartition parent = PartitionTestUtils.createPartition();
        return new PipelinedSubpartition(0, 2, parent);
    }

    public static PipelinedSubpartition createPipelinedSubpartition(ResultPartition parent) {
        return new PipelinedSubpartition(0, 2, parent);
    }
}

