/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.AkkaOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.groups.UnregisteredMetricsGroup;
import org.apache.flink.runtime.JobException;
import org.apache.flink.runtime.blob.BlobWriter;
import org.apache.flink.runtime.blob.VoidBlobWriter;
import org.apache.flink.runtime.checkpoint.CheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.CheckpointsCleaner;
import org.apache.flink.runtime.checkpoint.CompletedCheckpointStore;
import org.apache.flink.runtime.checkpoint.StandaloneCheckpointIDCounter;
import org.apache.flink.runtime.checkpoint.StandaloneCompletedCheckpointStore;
import org.apache.flink.runtime.client.JobExecutionException;
import org.apache.flink.runtime.deployment.TaskDeploymentDescriptorFactory;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraph;
import org.apache.flink.runtime.executiongraph.DefaultExecutionGraphBuilder;
import org.apache.flink.runtime.executiongraph.DefaultVertexAttemptNumberStore;
import org.apache.flink.runtime.executiongraph.ExecutionDeploymentListener;
import org.apache.flink.runtime.executiongraph.ExecutionStateUpdateListener;
import org.apache.flink.runtime.executiongraph.NoOpExecutionDeploymentListener;
import org.apache.flink.runtime.executiongraph.VertexAttemptNumberStore;
import org.apache.flink.runtime.io.network.partition.JobMasterPartitionTracker;
import org.apache.flink.runtime.io.network.partition.NoOpJobMasterPartitionTracker;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.JobGraphTestUtils;
import org.apache.flink.runtime.jobgraph.JobType;
import org.apache.flink.runtime.scheduler.SchedulerBase;
import org.apache.flink.runtime.scheduler.VertexParallelismStore;
import org.apache.flink.runtime.shuffle.ShuffleMaster;
import org.apache.flink.runtime.shuffle.ShuffleTestUtils;
import org.apache.flink.runtime.testutils.TestingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestingDefaultExecutionGraphBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(TestingDefaultExecutionGraphBuilder.class);
    private ScheduledExecutorService futureExecutor = TestingUtils.defaultExecutor();
    private Executor ioExecutor = TestingUtils.defaultExecutor();
    private Time rpcTimeout = Time.fromDuration((Duration)((Duration)AkkaOptions.ASK_TIMEOUT_DURATION.defaultValue()));
    private ClassLoader userClassLoader = DefaultExecutionGraph.class.getClassLoader();
    private BlobWriter blobWriter = VoidBlobWriter.getInstance();
    private ShuffleMaster<?> shuffleMaster = ShuffleTestUtils.DEFAULT_SHUFFLE_MASTER;
    private JobMasterPartitionTracker partitionTracker = NoOpJobMasterPartitionTracker.INSTANCE;
    private Configuration jobMasterConfig = new Configuration();
    private JobGraph jobGraph = JobGraphTestUtils.emptyJobGraph();
    private MetricGroup metricGroup = new UnregisteredMetricsGroup();
    private CompletedCheckpointStore completedCheckpointStore = new StandaloneCompletedCheckpointStore(1);
    private CheckpointIDCounter checkpointIdCounter = new StandaloneCheckpointIDCounter();
    private ExecutionDeploymentListener executionDeploymentListener = NoOpExecutionDeploymentListener.get();
    private ExecutionStateUpdateListener executionStateUpdateListener = (execution, newState) -> {};
    private VertexParallelismStore vertexParallelismStore;

    public static TestingDefaultExecutionGraphBuilder newBuilder() {
        return new TestingDefaultExecutionGraphBuilder();
    }

    private TestingDefaultExecutionGraphBuilder() {
    }

    public TestingDefaultExecutionGraphBuilder setJobMasterConfig(Configuration jobMasterConfig) {
        this.jobMasterConfig = jobMasterConfig;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setJobGraph(JobGraph jobGraph) {
        this.jobGraph = jobGraph;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setFutureExecutor(ScheduledExecutorService futureExecutor) {
        this.futureExecutor = futureExecutor;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setIoExecutor(Executor ioExecutor) {
        this.ioExecutor = ioExecutor;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setRpcTimeout(Time rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setUserClassLoader(ClassLoader userClassLoader) {
        this.userClassLoader = userClassLoader;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setBlobWriter(BlobWriter blobWriter) {
        this.blobWriter = blobWriter;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setShuffleMaster(ShuffleMaster<?> shuffleMaster) {
        this.shuffleMaster = shuffleMaster;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setPartitionTracker(JobMasterPartitionTracker partitionTracker) {
        this.partitionTracker = partitionTracker;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setMetricGroup(MetricGroup metricGroup) {
        this.metricGroup = metricGroup;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setCompletedCheckpointStore(CompletedCheckpointStore completedCheckpointStore) {
        this.completedCheckpointStore = completedCheckpointStore;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setCheckpointIdCounter(CheckpointIDCounter checkpointIdCounter) {
        this.checkpointIdCounter = checkpointIdCounter;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setExecutionDeploymentListener(ExecutionDeploymentListener executionDeploymentListener) {
        this.executionDeploymentListener = executionDeploymentListener;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setExecutionStateUpdateListener(ExecutionStateUpdateListener executionStateUpdateListener) {
        this.executionStateUpdateListener = executionStateUpdateListener;
        return this;
    }

    public TestingDefaultExecutionGraphBuilder setVertexParallelismStore(VertexParallelismStore store) {
        this.vertexParallelismStore = store;
        return this;
    }

    public DefaultExecutionGraph build() throws JobException, JobExecutionException {
        return DefaultExecutionGraphBuilder.buildGraph((JobGraph)this.jobGraph, (Configuration)this.jobMasterConfig, (ScheduledExecutorService)this.futureExecutor, (Executor)this.ioExecutor, (ClassLoader)this.userClassLoader, (CompletedCheckpointStore)this.completedCheckpointStore, (CheckpointsCleaner)new CheckpointsCleaner(), (CheckpointIDCounter)this.checkpointIdCounter, (Time)this.rpcTimeout, (MetricGroup)this.metricGroup, (BlobWriter)this.blobWriter, (Logger)LOG, this.shuffleMaster, (JobMasterPartitionTracker)this.partitionTracker, (TaskDeploymentDescriptorFactory.PartitionLocationConstraint)TaskDeploymentDescriptorFactory.PartitionLocationConstraint.fromJobType((JobType)this.jobGraph.getJobType()), (ExecutionDeploymentListener)this.executionDeploymentListener, (ExecutionStateUpdateListener)this.executionStateUpdateListener, (long)System.currentTimeMillis(), (VertexAttemptNumberStore)new DefaultVertexAttemptNumberStore(), (VertexParallelismStore)Optional.ofNullable(this.vertexParallelismStore).orElseGet(() -> SchedulerBase.computeVertexParallelismStore((JobGraph)this.jobGraph)));
    }
}

