/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.webmonitor;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.runtime.clusterframework.ApplicationStatus;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.DispatcherId;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobmaster.JobResult;
import org.apache.flink.runtime.messages.Acknowledge;
import org.apache.flink.runtime.messages.webmonitor.ClusterOverview;
import org.apache.flink.runtime.messages.webmonitor.MultipleJobsDetails;
import org.apache.flink.runtime.operators.coordination.CoordinationRequest;
import org.apache.flink.runtime.operators.coordination.CoordinationResponse;
import org.apache.flink.runtime.rpc.RpcTimeout;
import org.apache.flink.runtime.scheduler.ExecutionGraphInfo;
import org.apache.flink.runtime.webmonitor.TestingRestfulGateway;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.function.TriFunction;

public final class TestingDispatcherGateway
extends TestingRestfulGateway
implements DispatcherGateway {
    static final Function<JobGraph, CompletableFuture<Acknowledge>> DEFAULT_SUBMIT_FUNCTION = jobGraph -> CompletableFuture.completedFuture(Acknowledge.get());
    static final Supplier<CompletableFuture<Collection<JobID>>> DEFAULT_LIST_FUNCTION = () -> CompletableFuture.completedFuture(Collections.emptyList());
    static final int DEFAULT_BLOB_SERVER_PORT = 1234;
    static final DispatcherId DEFAULT_FENCING_TOKEN = DispatcherId.generate();
    static final Function<JobID, CompletableFuture<ArchivedExecutionGraph>> DEFAULT_REQUEST_ARCHIVED_JOB_FUNCTION = jobID -> CompletableFuture.completedFuture(null);
    static final Function<ApplicationStatus, CompletableFuture<Acknowledge>> DEFAULT_SHUTDOWN_WITH_STATUS_FUNCTION = status -> CompletableFuture.completedFuture(Acknowledge.get());
    private Function<JobGraph, CompletableFuture<Acknowledge>> submitFunction;
    private Supplier<CompletableFuture<Collection<JobID>>> listFunction;
    private int blobServerPort;
    private DispatcherId fencingToken;
    private Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestArchivedJobFunction;
    private Function<ApplicationStatus, CompletableFuture<Acknowledge>> clusterShutdownWithStatusFunction;

    public TestingDispatcherGateway() {
        this.submitFunction = DEFAULT_SUBMIT_FUNCTION;
        this.listFunction = DEFAULT_LIST_FUNCTION;
        this.blobServerPort = 1234;
        this.fencingToken = DEFAULT_FENCING_TOKEN;
        this.requestArchivedJobFunction = DEFAULT_REQUEST_ARCHIVED_JOB_FUNCTION;
        this.clusterShutdownWithStatusFunction = DEFAULT_SHUTDOWN_WITH_STATUS_FUNCTION;
    }

    public TestingDispatcherGateway(String address, String hostname, Function<JobID, CompletableFuture<Acknowledge>> cancelJobFunction, Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestJobFunction, Function<JobID, CompletableFuture<ExecutionGraphInfo>> requestExecutionGraphInfoFunction, Function<JobID, CompletableFuture<JobResult>> requestJobResultFunction, Function<JobID, CompletableFuture<JobStatus>> requestJobStatusFunction, Supplier<CompletableFuture<MultipleJobsDetails>> requestMultipleJobDetailsSupplier, Supplier<CompletableFuture<ClusterOverview>> requestClusterOverviewSupplier, Supplier<CompletableFuture<Collection<String>>> requestMetricQueryServiceAddressesSupplier, Supplier<CompletableFuture<Collection<Tuple2<ResourceID, String>>>> requestTaskManagerMetricQueryServiceGatewaysSupplier, BiFunction<JobID, String, CompletableFuture<String>> triggerSavepointFunction, BiFunction<JobID, String, CompletableFuture<String>> stopWithSavepointFunction, Function<JobGraph, CompletableFuture<Acknowledge>> submitFunction, Supplier<CompletableFuture<Collection<JobID>>> listFunction, int blobServerPort, DispatcherId fencingToken, Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestArchivedJobFunction, Supplier<CompletableFuture<Acknowledge>> clusterShutdownSupplier, Function<ApplicationStatus, CompletableFuture<Acknowledge>> clusterShutdownWithStatusFunction, TriFunction<JobID, OperatorID, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>> deliverCoordinationRequestToCoordinatorFunction) {
        super(address, hostname, cancelJobFunction, requestJobFunction, requestExecutionGraphInfoFunction, requestJobResultFunction, requestJobStatusFunction, requestMultipleJobDetailsSupplier, requestClusterOverviewSupplier, requestMetricQueryServiceAddressesSupplier, requestTaskManagerMetricQueryServiceGatewaysSupplier, triggerSavepointFunction, stopWithSavepointFunction, clusterShutdownSupplier, deliverCoordinationRequestToCoordinatorFunction);
        this.submitFunction = submitFunction;
        this.listFunction = listFunction;
        this.blobServerPort = blobServerPort;
        this.fencingToken = fencingToken;
        this.requestArchivedJobFunction = requestArchivedJobFunction;
        this.clusterShutdownWithStatusFunction = clusterShutdownWithStatusFunction;
    }

    public CompletableFuture<Acknowledge> submitJob(JobGraph jobGraph, Time timeout) {
        return this.submitFunction.apply(jobGraph);
    }

    public CompletableFuture<Collection<JobID>> listJobs(Time timeout) {
        return this.listFunction.get();
    }

    public CompletableFuture<Integer> getBlobServerPort(Time timeout) {
        return CompletableFuture.completedFuture(this.blobServerPort);
    }

    public DispatcherId getFencingToken() {
        return DEFAULT_FENCING_TOKEN;
    }

    @Override
    public CompletableFuture<ArchivedExecutionGraph> requestJob(JobID jobId, @RpcTimeout Time timeout) {
        return this.requestArchivedJobFunction.apply(jobId);
    }

    public CompletableFuture<Acknowledge> shutDownCluster(ApplicationStatus applicationStatus) {
        return this.clusterShutdownWithStatusFunction.apply(applicationStatus);
    }

    public static final class Builder
    extends TestingRestfulGateway.AbstractBuilder<Builder> {
        private Function<JobGraph, CompletableFuture<Acknowledge>> submitFunction;
        private Supplier<CompletableFuture<Collection<JobID>>> listFunction;
        private int blobServerPort;
        private DispatcherId fencingToken;
        private Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestArchivedJobFunction;
        private Function<ApplicationStatus, CompletableFuture<Acknowledge>> clusterShutdownWithStatusFunction = DEFAULT_SHUTDOWN_WITH_STATUS_FUNCTION;

        public Builder setSubmitFunction(Function<JobGraph, CompletableFuture<Acknowledge>> submitFunction) {
            this.submitFunction = submitFunction;
            return this;
        }

        public Builder setListFunction(Supplier<CompletableFuture<Collection<JobID>>> listFunction) {
            this.listFunction = listFunction;
            return this;
        }

        public Builder setRequestArchivedJobFunction(Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestJobFunction) {
            this.requestArchivedJobFunction = requestJobFunction;
            return this;
        }

        public Builder setClusterShutdownFunction(Function<ApplicationStatus, CompletableFuture<Acknowledge>> clusterShutdownFunction) {
            this.clusterShutdownWithStatusFunction = clusterShutdownFunction;
            return this;
        }

        @Override
        public Builder setRequestJobFunction(Function<JobID, CompletableFuture<ArchivedExecutionGraph>> requestJobFunction) {
            throw new UnsupportedOperationException("Use setRequestArchivedJobFunction() instead.");
        }

        @Override
        protected Builder self() {
            return this;
        }

        public Builder setBlobServerPort(int blobServerPort) {
            this.blobServerPort = blobServerPort;
            return this;
        }

        public Builder setFencingToken(DispatcherId fencingToken) {
            this.fencingToken = fencingToken;
            return this;
        }

        @Override
        public TestingDispatcherGateway build() {
            return new TestingDispatcherGateway(this.address, this.hostname, this.cancelJobFunction, this.requestJobFunction, this.requestExecutionGraphInfoFunction, this.requestJobResultFunction, this.requestJobStatusFunction, this.requestMultipleJobDetailsSupplier, this.requestClusterOverviewSupplier, this.requestMetricQueryServiceGatewaysSupplier, this.requestTaskManagerMetricQueryServiceGatewaysSupplier, this.triggerSavepointFunction, this.stopWithSavepointFunction, this.submitFunction, this.listFunction, this.blobServerPort, this.fencingToken, this.requestArchivedJobFunction, this.clusterShutdownSupplier, this.clusterShutdownWithStatusFunction, (TriFunction<JobID, OperatorID, SerializedValue<CoordinationRequest>, CompletableFuture<CoordinationResponse>>)this.deliverCoordinationRequestToCoordinatorFunction);
        }
    }
}

