/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;

public class TestingTaskManagerActions
implements TaskManagerActions {
    private final BiConsumer<String, Throwable> notifyFatalErrorConsumer;
    private final BiConsumer<ExecutionAttemptID, Throwable> failTaskConsumer;
    private final Consumer<TaskExecutionState> updateTaskExecutionStateConsumer;

    private TestingTaskManagerActions(BiConsumer<String, Throwable> notifyFatalErrorConsumer, BiConsumer<ExecutionAttemptID, Throwable> failTaskConsumer, Consumer<TaskExecutionState> updateTaskExecutionStateConsumer) {
        this.notifyFatalErrorConsumer = notifyFatalErrorConsumer;
        this.failTaskConsumer = failTaskConsumer;
        this.updateTaskExecutionStateConsumer = updateTaskExecutionStateConsumer;
    }

    public void notifyFatalError(String message, Throwable cause) {
        this.notifyFatalErrorConsumer.accept(message, cause);
    }

    public void failTask(ExecutionAttemptID executionAttemptID, Throwable cause) {
        this.failTaskConsumer.accept(executionAttemptID, cause);
    }

    public void updateTaskExecutionState(TaskExecutionState taskExecutionState) {
        this.updateTaskExecutionStateConsumer.accept(taskExecutionState);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private BiConsumer<String, Throwable> notifyFatalErrorConsumer = (ignoredA, ignoredB) -> {};
        private BiConsumer<ExecutionAttemptID, Throwable> failTaskConsumer = (ignoredA, ignoredB) -> {};
        private Consumer<TaskExecutionState> updateTaskExecutionStateConsumer = ignored -> {};

        private Builder() {
        }

        public Builder setNotifyFatalErrorConsumer(BiConsumer<String, Throwable> notifyFatalErrorConsumer) {
            this.notifyFatalErrorConsumer = notifyFatalErrorConsumer;
            return this;
        }

        public Builder setFailTaskConsumer(BiConsumer<ExecutionAttemptID, Throwable> failTaskConsumer) {
            this.failTaskConsumer = failTaskConsumer;
            return this;
        }

        public Builder setUpdateTaskExecutionStateConsumer(Consumer<TaskExecutionState> updateTaskExecutionStateConsumer) {
            this.updateTaskExecutionStateConsumer = updateTaskExecutionStateConsumer;
            return this;
        }

        public TestingTaskManagerActions build() {
            return new TestingTaskManagerActions(this.notifyFatalErrorConsumer, this.failTaskConsumer, this.updateTaskExecutionStateConsumer);
        }
    }
}

