/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.factories;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.runtime.executiongraph.ArchivedExecutionGraph;
import org.apache.flink.runtime.jobmanager.OnCompletionActions;
import org.apache.flink.runtime.jobmaster.DefaultJobMasterServiceProcess;
import org.apache.flink.runtime.jobmaster.JobMasterService;
import org.apache.flink.runtime.jobmaster.JobMasterServiceProcess;
import org.apache.flink.runtime.jobmaster.TestingJobMasterService;
import org.apache.flink.runtime.jobmaster.factories.JobMasterServiceFactory;
import org.apache.flink.runtime.jobmaster.factories.JobMasterServiceProcessFactory;

public class TestingJobMasterServiceProcessFactoryOld
implements JobMasterServiceProcessFactory {
    private final CompletableFuture<JobMasterService> jobMasterServiceFuture;
    private final JobID jobId;
    private final JobMasterServiceFactory jobMasterServiceFactoryNg;

    public TestingJobMasterServiceProcessFactoryOld(JobID jobId, CompletableFuture<JobMasterService> jobMasterServiceFuture) {
        this.jobId = jobId;
        this.jobMasterServiceFuture = jobMasterServiceFuture;
        this.jobMasterServiceFactoryNg = new TestingFutureJobMasterServiceFactory(jobMasterServiceFuture);
    }

    public TestingJobMasterServiceProcessFactoryOld(JobID jobId) {
        this(jobId, CompletableFuture.completedFuture(new TestingJobMasterService()));
    }

    public JobMasterServiceProcess create(UUID leaderSessionID) {
        return new DefaultJobMasterServiceProcess(this.jobId, leaderSessionID, this.jobMasterServiceFactoryNg, cause -> this.createArchivedExecutionGraph(JobStatus.FAILED, (Throwable)cause));
    }

    public JobID getJobId() {
        return this.jobId;
    }

    public ArchivedExecutionGraph createArchivedExecutionGraph(JobStatus jobStatus, @Nullable Throwable cause) {
        return ArchivedExecutionGraph.createFromInitializingJob((JobID)this.jobId, (String)"test-job", (JobStatus)jobStatus, (Throwable)cause, null, (long)System.currentTimeMillis());
    }

    public static class TestingFutureJobMasterServiceFactory
    implements JobMasterServiceFactory {
        final CompletableFuture<JobMasterService> jobMasterServiceFuture;

        public TestingFutureJobMasterServiceFactory(CompletableFuture<JobMasterService> jobMasterServiceFuture) {
            this.jobMasterServiceFuture = jobMasterServiceFuture;
        }

        public CompletableFuture<JobMasterService> createJobMasterService(UUID leaderSessionId, OnCompletionActions onCompletionActions) {
            return this.jobMasterServiceFuture;
        }
    }
}

