/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.concurrent;

import java.time.Duration;
import org.apache.flink.util.TestLogger;
import org.apache.flink.util.concurrent.ExponentialBackoffRetryStrategy;
import org.apache.flink.util.concurrent.RetryStrategy;
import org.junit.Assert;
import org.junit.Test;

public class ExponentialBackoffRetryStrategyTest
extends TestLogger {
    @Test
    public void testGettersNotCapped() throws Exception {
        ExponentialBackoffRetryStrategy retryStrategy = new ExponentialBackoffRetryStrategy(10, Duration.ofMillis(5L), Duration.ofMillis(20L));
        Assert.assertEquals((long)10L, (long)retryStrategy.getNumRemainingRetries());
        Assert.assertEquals((Object)Duration.ofMillis(5L), (Object)retryStrategy.getRetryDelay());
        RetryStrategy nextRetryStrategy = retryStrategy.getNextRetryStrategy();
        Assert.assertEquals((long)9L, (long)nextRetryStrategy.getNumRemainingRetries());
        Assert.assertEquals((Object)Duration.ofMillis(10L), (Object)nextRetryStrategy.getRetryDelay());
    }

    @Test
    public void testGettersHitCapped() throws Exception {
        ExponentialBackoffRetryStrategy retryStrategy = new ExponentialBackoffRetryStrategy(5, Duration.ofMillis(15L), Duration.ofMillis(20L));
        Assert.assertEquals((long)5L, (long)retryStrategy.getNumRemainingRetries());
        Assert.assertEquals((Object)Duration.ofMillis(15L), (Object)retryStrategy.getRetryDelay());
        RetryStrategy nextRetryStrategy = retryStrategy.getNextRetryStrategy();
        Assert.assertEquals((long)4L, (long)nextRetryStrategy.getNumRemainingRetries());
        Assert.assertEquals((Object)Duration.ofMillis(20L), (Object)nextRetryStrategy.getRetryDelay());
    }

    @Test
    public void testGettersAtCap() throws Exception {
        ExponentialBackoffRetryStrategy retryStrategy = new ExponentialBackoffRetryStrategy(5, Duration.ofMillis(20L), Duration.ofMillis(20L));
        Assert.assertEquals((long)5L, (long)retryStrategy.getNumRemainingRetries());
        Assert.assertEquals((Object)Duration.ofMillis(20L), (Object)retryStrategy.getRetryDelay());
        RetryStrategy nextRetryStrategy = retryStrategy.getNextRetryStrategy();
        Assert.assertEquals((long)4L, (long)nextRetryStrategy.getNumRemainingRetries());
        Assert.assertEquals((Object)Duration.ofMillis(20L), (Object)nextRetryStrategy.getRetryDelay());
    }

    @Test(expected=IllegalStateException.class)
    public void testRetryFailure() throws Throwable {
        new ExponentialBackoffRetryStrategy(0, Duration.ofMillis(20L), Duration.ofMillis(20L)).getNextRetryStrategy();
    }
}

