/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.checkpoint;

import org.apache.flink.runtime.checkpoint.CheckpointStatsCounts;
import org.junit.Assert;
import org.junit.Test;

public class CheckpointStatsCountsTest {
    @Test
    public void testCounts() {
        CheckpointStatsCounts counts = new CheckpointStatsCounts();
        Assert.assertEquals((long)0L, (long)counts.getNumberOfRestoredCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfInProgressCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfFailedCheckpoints());
        counts.incrementRestoredCheckpoints();
        Assert.assertEquals((long)1L, (long)counts.getNumberOfRestoredCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfInProgressCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfFailedCheckpoints());
        counts.incrementInProgressCheckpoints();
        Assert.assertEquals((long)1L, (long)counts.getNumberOfRestoredCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getNumberOfInProgressCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfFailedCheckpoints());
        counts.incrementCompletedCheckpoints();
        Assert.assertEquals((long)1L, (long)counts.getNumberOfRestoredCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfInProgressCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfFailedCheckpoints());
        counts.incrementInProgressCheckpoints();
        Assert.assertEquals((long)1L, (long)counts.getNumberOfRestoredCheckpoints());
        Assert.assertEquals((long)2L, (long)counts.getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getNumberOfInProgressCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfFailedCheckpoints());
        counts.incrementFailedCheckpoints();
        Assert.assertEquals((long)1L, (long)counts.getNumberOfRestoredCheckpoints());
        Assert.assertEquals((long)2L, (long)counts.getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)0L, (long)counts.getNumberOfInProgressCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)1L, (long)counts.getNumberOfFailedCheckpoints());
    }

    @Test
    public void testCompleteOrFailWithoutInProgressCheckpoint() {
        CheckpointStatsCounts counts = new CheckpointStatsCounts();
        counts.incrementCompletedCheckpoints();
        Assert.assertTrue((String)"Number of checkpoints in progress should never be negative", (counts.getNumberOfInProgressCheckpoints() >= 0 ? 1 : 0) != 0);
        counts.incrementFailedCheckpoints();
        Assert.assertTrue((String)"Number of checkpoints in progress should never be negative", (counts.getNumberOfInProgressCheckpoints() >= 0 ? 1 : 0) != 0);
    }

    @Test
    public void testCreateSnapshot() {
        CheckpointStatsCounts counts = new CheckpointStatsCounts();
        counts.incrementRestoredCheckpoints();
        counts.incrementRestoredCheckpoints();
        counts.incrementRestoredCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementFailedCheckpoints();
        long restored = counts.getNumberOfRestoredCheckpoints();
        long total = counts.getTotalNumberOfCheckpoints();
        long inProgress = counts.getNumberOfInProgressCheckpoints();
        long completed = counts.getNumberOfCompletedCheckpoints();
        long failed = counts.getNumberOfFailedCheckpoints();
        CheckpointStatsCounts snapshot = counts.createSnapshot();
        Assert.assertEquals((long)restored, (long)snapshot.getNumberOfRestoredCheckpoints());
        Assert.assertEquals((long)total, (long)snapshot.getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)inProgress, (long)snapshot.getNumberOfInProgressCheckpoints());
        Assert.assertEquals((long)completed, (long)snapshot.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)failed, (long)snapshot.getNumberOfFailedCheckpoints());
        counts.incrementRestoredCheckpoints();
        counts.incrementRestoredCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementCompletedCheckpoints();
        counts.incrementInProgressCheckpoints();
        counts.incrementFailedCheckpoints();
        Assert.assertEquals((long)restored, (long)snapshot.getNumberOfRestoredCheckpoints());
        Assert.assertEquals((long)total, (long)snapshot.getTotalNumberOfCheckpoints());
        Assert.assertEquals((long)inProgress, (long)snapshot.getNumberOfInProgressCheckpoints());
        Assert.assertEquals((long)completed, (long)snapshot.getNumberOfCompletedCheckpoints());
        Assert.assertEquals((long)failed, (long)snapshot.getNumberOfFailedCheckpoints());
    }
}

