/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.blob.BlobServerConnection;
import org.apache.flink.runtime.blob.BlobStore;
import org.apache.flink.util.NetUtils;

public class TestingFailingBlobServer
extends BlobServer {
    private final int numAccept;
    private final int numFailures;

    public TestingFailingBlobServer(Configuration config, BlobStore blobStore, int numFailures) throws IOException {
        this(config, blobStore, 1, numFailures);
    }

    public TestingFailingBlobServer(Configuration config, BlobStore blobStore, int numAccept, int numFailures) throws IOException {
        super(config, blobStore);
        this.numAccept = numAccept;
        this.numFailures = numFailures;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int num;
        try {
            for (num = 0; num < this.numAccept && !this.isShutdown(); ++num) {
                new BlobServerConnection(NetUtils.acceptWithoutTimeout((ServerSocket)this.getServerSocket()), (BlobServer)this).start();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        for (num = 0; num < this.numFailures && !this.isShutdown(); ++num) {
            Socket socket = null;
            try {
                socket = NetUtils.acceptWithoutTimeout((ServerSocket)this.getServerSocket());
                InputStream is = socket.getInputStream();
                OutputStream os = socket.getOutputStream();
                is.close();
                os.close();
                socket.close();
                continue;
            }
            catch (IOException iOException) {
                continue;
            }
            finally {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        super.run();
    }
}

