/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.blob;

import java.io.File;
import java.io.IOException;
import org.apache.flink.configuration.BlobServerOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.runtime.blob.BlobUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class BlobUtilsTest {
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testDefaultBlobStorageDirectory() throws IOException {
        Configuration config = new Configuration();
        String blobStorageDir = this.temporaryFolder.newFolder().getAbsolutePath();
        config.setString(BlobServerOptions.STORAGE_DIRECTORY, blobStorageDir);
        config.setString(CoreOptions.TMP_DIRS, this.temporaryFolder.newFolder().getAbsolutePath());
        File dir = BlobUtils.initLocalStorageDirectory((Configuration)config);
        MatcherAssert.assertThat((Object)dir.getAbsolutePath(), (Matcher)CoreMatchers.startsWith((String)blobStorageDir));
    }

    @Test
    public void testTaskManagerFallbackBlobStorageDirectory1() throws IOException {
        Configuration config = new Configuration();
        String blobStorageDir = this.temporaryFolder.getRoot().getAbsolutePath();
        config.setString(CoreOptions.TMP_DIRS, blobStorageDir);
        File dir = BlobUtils.initLocalStorageDirectory((Configuration)config);
        MatcherAssert.assertThat((Object)dir.getAbsolutePath(), (Matcher)CoreMatchers.startsWith((String)blobStorageDir));
    }

    @Test
    public void testTaskManagerFallbackBlobStorageDirectory2a() throws IOException {
        Configuration config = new Configuration();
        String blobStorageDirs = this.temporaryFolder.newFolder().getAbsolutePath() + "," + this.temporaryFolder.newFolder().getAbsolutePath();
        config.setString(CoreOptions.TMP_DIRS, blobStorageDirs);
        File dir = BlobUtils.initLocalStorageDirectory((Configuration)config);
        MatcherAssert.assertThat((Object)dir.getAbsolutePath(), (Matcher)CoreMatchers.startsWith((String)this.temporaryFolder.getRoot().getAbsolutePath()));
    }

    @Test
    public void testTaskManagerFallbackBlobStorageDirectory2b() throws IOException {
        Configuration config = new Configuration();
        String blobStorageDirs = this.temporaryFolder.newFolder().getAbsolutePath() + File.pathSeparator + this.temporaryFolder.newFolder().getAbsolutePath();
        config.setString(CoreOptions.TMP_DIRS, blobStorageDirs);
        File dir = BlobUtils.initLocalStorageDirectory((Configuration)config);
        MatcherAssert.assertThat((Object)dir.getAbsolutePath(), (Matcher)CoreMatchers.startsWith((String)this.temporaryFolder.getRoot().getAbsolutePath()));
    }

    @Test
    public void testTaskManagerFallbackFallbackBlobStorageDirectory1() throws IOException {
        Configuration config = new Configuration();
        File dir = BlobUtils.initLocalStorageDirectory((Configuration)config);
        MatcherAssert.assertThat((Object)dir.getAbsolutePath(), (Matcher)CoreMatchers.startsWith((String)((String)CoreOptions.TMP_DIRS.defaultValue())));
    }
}

