/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskmanager;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.TaskInfo;
import org.apache.flink.api.common.cache.DistributedCache;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.TaskManagerOptions;
import org.apache.flink.core.fs.FileSystemSafetyNet;
import org.apache.flink.core.fs.Path;
import org.apache.flink.core.security.FlinkSecurityManager;
import org.apache.flink.runtime.accumulators.AccumulatorRegistry;
import org.apache.flink.runtime.blob.PermanentBlobKey;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.checkpoint.CheckpointException;
import org.apache.flink.runtime.checkpoint.CheckpointFailureReason;
import org.apache.flink.runtime.checkpoint.CheckpointMetaData;
import org.apache.flink.runtime.checkpoint.CheckpointOptions;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.deployment.InputGateDeploymentDescriptor;
import org.apache.flink.runtime.deployment.ResultPartitionDeploymentDescriptor;
import org.apache.flink.runtime.execution.CancelTaskException;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.runtime.execution.ExecutionState;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.executiongraph.ExecutionAttemptID;
import org.apache.flink.runtime.executiongraph.JobInformation;
import org.apache.flink.runtime.executiongraph.TaskInformation;
import org.apache.flink.runtime.externalresource.ExternalResourceInfoProvider;
import org.apache.flink.runtime.filecache.FileCache;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.network.NettyShuffleEnvironment;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.io.network.api.writer.ResultPartitionWriter;
import org.apache.flink.runtime.io.network.partition.PartitionProducerStateProvider;
import org.apache.flink.runtime.io.network.partition.ResultPartitionConsumableNotifier;
import org.apache.flink.runtime.io.network.partition.ResultPartitionID;
import org.apache.flink.runtime.io.network.partition.consumer.IndexedInputGate;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.jobgraph.IntermediateDataSetID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.runtime.jobgraph.tasks.CheckpointableTask;
import org.apache.flink.runtime.jobgraph.tasks.CoordinatedTask;
import org.apache.flink.runtime.jobgraph.tasks.InputSplitProvider;
import org.apache.flink.runtime.jobgraph.tasks.TaskInvokable;
import org.apache.flink.runtime.jobgraph.tasks.TaskOperatorEventGateway;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.flink.runtime.operators.coordination.TaskNotRunningException;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.shuffle.ShuffleIOOwnerContext;
import org.apache.flink.runtime.state.TaskStateManager;
import org.apache.flink.runtime.taskexecutor.GlobalAggregateManager;
import org.apache.flink.runtime.taskexecutor.KvStateService;
import org.apache.flink.runtime.taskexecutor.PartitionProducerStateChecker;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotPayload;
import org.apache.flink.runtime.taskmanager.CheckpointResponder;
import org.apache.flink.runtime.taskmanager.ConsumableNotifyingResultPartitionWriterDecorator;
import org.apache.flink.runtime.taskmanager.InputGateWithMetrics;
import org.apache.flink.runtime.taskmanager.RuntimeEnvironment;
import org.apache.flink.runtime.taskmanager.TaskActions;
import org.apache.flink.runtime.taskmanager.TaskExecutionState;
import org.apache.flink.runtime.taskmanager.TaskManagerActions;
import org.apache.flink.runtime.taskmanager.TaskManagerRuntimeInfo;
import org.apache.flink.runtime.throughput.ThroughputCalculator;
import org.apache.flink.types.Either;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FatalExitExceptionHandler;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.SerializedValue;
import org.apache.flink.util.TaskManagerExceptionUtils;
import org.apache.flink.util.UserCodeClassLoader;
import org.apache.flink.util.WrappingRuntimeException;
import org.apache.flink.util.clock.Clock;
import org.apache.flink.util.clock.SystemClock;
import org.apache.flink.util.concurrent.FutureUtils;
import org.apache.flink.util.function.RunnableWithException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Task
implements Runnable,
TaskSlotPayload,
TaskActions,
PartitionProducerStateProvider {
    private static final Logger LOG = LoggerFactory.getLogger(Task.class);
    private static final ThreadGroup TASK_THREADS_GROUP = new ThreadGroup("Flink Task Threads");
    private static final AtomicReferenceFieldUpdater<Task, ExecutionState> STATE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(Task.class, ExecutionState.class, "executionState");
    private final JobID jobId;
    private final JobVertexID vertexId;
    private final ExecutionAttemptID executionId;
    private final AllocationID allocationId;
    private final TaskInfo taskInfo;
    private final String taskNameWithSubtask;
    private final Configuration jobConfiguration;
    private final Configuration taskConfiguration;
    private final Collection<PermanentBlobKey> requiredJarFiles;
    private final Collection<URL> requiredClasspaths;
    private final String nameOfInvokableClass;
    private final TaskManagerRuntimeInfo taskManagerConfig;
    private final MemoryManager memoryManager;
    private final IOManager ioManager;
    private final BroadcastVariableManager broadcastVariableManager;
    private final TaskEventDispatcher taskEventDispatcher;
    private final ExternalResourceInfoProvider externalResourceInfoProvider;
    private final TaskStateManager taskStateManager;
    private final SerializedValue<ExecutionConfig> serializedExecutionConfig;
    private final ResultPartitionWriter[] consumableNotifyingPartitionWriters;
    private final IndexedInputGate[] inputGates;
    private final TaskManagerActions taskManagerActions;
    private final InputSplitProvider inputSplitProvider;
    private final CheckpointResponder checkpointResponder;
    private final TaskOperatorEventGateway operatorCoordinatorEventGateway;
    private final GlobalAggregateManager aggregateManager;
    private final LibraryCacheManager.ClassLoaderHandle classLoaderHandle;
    private final FileCache fileCache;
    private final KvStateService kvStateService;
    private final AccumulatorRegistry accumulatorRegistry;
    private final Thread executingThread;
    private final TaskMetricGroup metrics;
    private final PartitionProducerStateChecker partitionProducerStateChecker;
    private final Executor executor;
    private final CompletableFuture<ExecutionState> terminationFuture = new CompletableFuture();
    private final AtomicBoolean invokableHasBeenCanceled;
    @Nullable
    private volatile TaskInvokable invokable;
    private volatile ExecutionState executionState = ExecutionState.CREATED;
    private volatile Throwable failureCause;
    private long taskCancellationInterval;
    private long taskCancellationTimeout;
    private UserCodeClassLoader userCodeClassLoader;
    private ThroughputCalculator throughputCalculator;

    public Task(JobInformation jobInformation, TaskInformation taskInformation, ExecutionAttemptID executionAttemptID, AllocationID slotAllocationId, int subtaskIndex, int attemptNumber, List<ResultPartitionDeploymentDescriptor> resultPartitionDeploymentDescriptors, List<InputGateDeploymentDescriptor> inputGateDeploymentDescriptors, MemoryManager memManager, IOManager ioManager, ShuffleEnvironment<?, ?> shuffleEnvironment, KvStateService kvStateService, BroadcastVariableManager bcVarManager, TaskEventDispatcher taskEventDispatcher, ExternalResourceInfoProvider externalResourceInfoProvider, TaskStateManager taskStateManager, TaskManagerActions taskManagerActions, InputSplitProvider inputSplitProvider, CheckpointResponder checkpointResponder, TaskOperatorEventGateway operatorCoordinatorEventGateway, GlobalAggregateManager aggregateManager, LibraryCacheManager.ClassLoaderHandle classLoaderHandle, FileCache fileCache, TaskManagerRuntimeInfo taskManagerConfig, @Nonnull TaskMetricGroup metricGroup, ResultPartitionConsumableNotifier resultPartitionConsumableNotifier, PartitionProducerStateChecker partitionProducerStateChecker, Executor executor) {
        Preconditions.checkNotNull((Object)jobInformation);
        Preconditions.checkNotNull((Object)taskInformation);
        Preconditions.checkArgument((0 <= subtaskIndex ? 1 : 0) != 0, (Object)"The subtask index must be positive.");
        Preconditions.checkArgument((0 <= attemptNumber ? 1 : 0) != 0, (Object)"The attempt number must be positive.");
        this.taskInfo = new TaskInfo(taskInformation.getTaskName(), taskInformation.getMaxNumberOfSubtasks(), subtaskIndex, taskInformation.getNumberOfSubtasks(), attemptNumber, String.valueOf((Object)slotAllocationId));
        this.jobId = jobInformation.getJobId();
        this.vertexId = taskInformation.getJobVertexId();
        this.executionId = (ExecutionAttemptID)Preconditions.checkNotNull((Object)executionAttemptID);
        this.allocationId = (AllocationID)((Object)Preconditions.checkNotNull((Object)((Object)slotAllocationId)));
        this.taskNameWithSubtask = this.taskInfo.getTaskNameWithSubtasks();
        this.jobConfiguration = jobInformation.getJobConfiguration();
        this.taskConfiguration = taskInformation.getTaskConfiguration();
        this.requiredJarFiles = jobInformation.getRequiredJarFileBlobKeys();
        this.requiredClasspaths = jobInformation.getRequiredClasspathURLs();
        this.nameOfInvokableClass = taskInformation.getInvokableClassName();
        this.serializedExecutionConfig = jobInformation.getSerializedExecutionConfig();
        Configuration tmConfig = taskManagerConfig.getConfiguration();
        this.taskCancellationInterval = tmConfig.getLong(TaskManagerOptions.TASK_CANCELLATION_INTERVAL);
        this.taskCancellationTimeout = tmConfig.getLong(TaskManagerOptions.TASK_CANCELLATION_TIMEOUT);
        this.memoryManager = (MemoryManager)Preconditions.checkNotNull((Object)memManager);
        this.ioManager = (IOManager)Preconditions.checkNotNull((Object)ioManager);
        this.broadcastVariableManager = (BroadcastVariableManager)Preconditions.checkNotNull((Object)bcVarManager);
        this.taskEventDispatcher = (TaskEventDispatcher)Preconditions.checkNotNull((Object)taskEventDispatcher);
        this.taskStateManager = (TaskStateManager)Preconditions.checkNotNull((Object)taskStateManager);
        this.accumulatorRegistry = new AccumulatorRegistry(this.jobId, this.executionId);
        this.inputSplitProvider = (InputSplitProvider)Preconditions.checkNotNull((Object)inputSplitProvider);
        this.checkpointResponder = (CheckpointResponder)Preconditions.checkNotNull((Object)checkpointResponder);
        this.operatorCoordinatorEventGateway = (TaskOperatorEventGateway)Preconditions.checkNotNull((Object)operatorCoordinatorEventGateway);
        this.aggregateManager = (GlobalAggregateManager)Preconditions.checkNotNull((Object)aggregateManager);
        this.taskManagerActions = (TaskManagerActions)Preconditions.checkNotNull((Object)taskManagerActions);
        this.externalResourceInfoProvider = (ExternalResourceInfoProvider)Preconditions.checkNotNull((Object)externalResourceInfoProvider);
        this.classLoaderHandle = (LibraryCacheManager.ClassLoaderHandle)Preconditions.checkNotNull((Object)classLoaderHandle);
        this.fileCache = (FileCache)Preconditions.checkNotNull((Object)fileCache);
        this.kvStateService = (KvStateService)Preconditions.checkNotNull((Object)kvStateService);
        this.taskManagerConfig = (TaskManagerRuntimeInfo)Preconditions.checkNotNull((Object)taskManagerConfig);
        this.metrics = metricGroup;
        this.partitionProducerStateChecker = (PartitionProducerStateChecker)Preconditions.checkNotNull((Object)partitionProducerStateChecker);
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor);
        String taskNameWithSubtaskAndId = this.taskNameWithSubtask + " (" + this.executionId + ')';
        ShuffleIOOwnerContext taskShuffleContext = shuffleEnvironment.createShuffleIOOwnerContext(taskNameWithSubtaskAndId, this.executionId, this.metrics.getIOMetricGroup());
        ResultPartitionWriter[] resultPartitionWriters = shuffleEnvironment.createResultPartitionWriters(taskShuffleContext, resultPartitionDeploymentDescriptors).toArray(new ResultPartitionWriter[0]);
        this.consumableNotifyingPartitionWriters = ConsumableNotifyingResultPartitionWriterDecorator.decorate(resultPartitionDeploymentDescriptors, resultPartitionWriters, this, this.jobId, resultPartitionConsumableNotifier);
        InputGate[] gates = shuffleEnvironment.createInputGates(taskShuffleContext, this, inputGateDeploymentDescriptors).toArray(new IndexedInputGate[0]);
        this.inputGates = new IndexedInputGate[gates.length];
        this.throughputCalculator = new ThroughputCalculator((Clock)SystemClock.getInstance(), (Integer)this.taskConfiguration.get(TaskManagerOptions.BUFFER_DEBLOAT_SAMPLES));
        int counter = 0;
        for (IndexedInputGate indexedInputGate : gates) {
            this.inputGates[counter++] = new InputGateWithMetrics(indexedInputGate, this.metrics.getIOMetricGroup().getNumBytesInCounter(), this.throughputCalculator);
        }
        if (shuffleEnvironment instanceof NettyShuffleEnvironment) {
            ((NettyShuffleEnvironment)shuffleEnvironment).registerLegacyNetworkMetrics(this.metrics.getIOMetricGroup(), resultPartitionWriters, gates);
        }
        this.invokableHasBeenCanceled = new AtomicBoolean(false);
        this.executingThread = new Thread(TASK_THREADS_GROUP, this, this.taskNameWithSubtask);
    }

    @Override
    public JobID getJobID() {
        return this.jobId;
    }

    public JobVertexID getJobVertexId() {
        return this.vertexId;
    }

    @Override
    public ExecutionAttemptID getExecutionId() {
        return this.executionId;
    }

    @Override
    public AllocationID getAllocationId() {
        return this.allocationId;
    }

    public TaskInfo getTaskInfo() {
        return this.taskInfo;
    }

    public Configuration getJobConfiguration() {
        return this.jobConfiguration;
    }

    public Configuration getTaskConfiguration() {
        return this.taskConfiguration;
    }

    public AccumulatorRegistry getAccumulatorRegistry() {
        return this.accumulatorRegistry;
    }

    public TaskMetricGroup getMetricGroup() {
        return this.metrics;
    }

    public Thread getExecutingThread() {
        return this.executingThread;
    }

    public CompletableFuture<ExecutionState> getTerminationFuture() {
        return this.terminationFuture;
    }

    @VisibleForTesting
    long getTaskCancellationInterval() {
        return this.taskCancellationInterval;
    }

    @VisibleForTesting
    long getTaskCancellationTimeout() {
        return this.taskCancellationTimeout;
    }

    @Nullable
    @VisibleForTesting
    TaskInvokable getInvokable() {
        return this.invokable;
    }

    public boolean isBackPressured() {
        if (this.invokable == null || this.consumableNotifyingPartitionWriters.length == 0 || this.executionState != ExecutionState.INITIALIZING && this.executionState != ExecutionState.RUNNING) {
            return false;
        }
        for (int i = 0; i < this.consumableNotifyingPartitionWriters.length; ++i) {
            if (this.consumableNotifyingPartitionWriters[i].isAvailable()) continue;
            return true;
        }
        return false;
    }

    public ExecutionState getExecutionState() {
        return this.executionState;
    }

    public boolean isCanceledOrFailed() {
        return this.executionState == ExecutionState.CANCELING || this.executionState == ExecutionState.CANCELED || this.executionState == ExecutionState.FAILED;
    }

    public Throwable getFailureCause() {
        return this.failureCause;
    }

    public void startTaskThread() {
        this.executingThread.start();
    }

    @Override
    public void run() {
        try {
            this.doRun();
        }
        finally {
            this.terminationFuture.complete(this.executionState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRun() {
        block48: {
            while (true) {
                block51: {
                    if ((current = this.executionState) != ExecutionState.CREATED) break block51;
                    if (!this.transitionState(ExecutionState.CREATED, ExecutionState.DEPLOYING)) continue;
                    distributedCacheEntries = new HashMap<String, Future<Path>>();
                    invokable = null;
                    ** try [egrp 0[TRYBLOCK] [5, 11 : 152->813)] { 
lbl7:
                    // 1 sources

                    ** GOTO lbl-1000
                }
                if (current == ExecutionState.FAILED) {
                    this.notifyFinalState();
                    if (this.metrics == null) return;
                    this.metrics.close();
                    return;
                }
                if (current != ExecutionState.CANCELING) {
                    if (this.metrics == null) throw new IllegalStateException("Invalid state for beginning of operation of task " + this + '.');
                    this.metrics.close();
                    throw new IllegalStateException("Invalid state for beginning of operation of task " + this + '.');
                }
                if (this.transitionState(ExecutionState.CANCELING, ExecutionState.CANCELED)) break;
            }
            this.notifyFinalState();
            if (this.metrics == null) return;
            this.metrics.close();
            return;
lbl-1000:
            // 1 sources

            {
                Task.LOG.debug("Creating FileSystem stream leak safety net for task {}", (Object)this);
                FileSystemSafetyNet.initializeSafetyNetForThread();
                Task.LOG.info("Loading JAR files for task {}.", (Object)this);
                this.userCodeClassLoader = this.createUserCodeClassloader();
                executionConfig = (ExecutionConfig)this.serializedExecutionConfig.deserializeValue(this.userCodeClassLoader.asClassLoader());
                if (executionConfig.getTaskCancellationInterval() >= 0L) {
                    this.taskCancellationInterval = executionConfig.getTaskCancellationInterval();
                }
                if (executionConfig.getTaskCancellationTimeout() >= 0L) {
                    this.taskCancellationTimeout = executionConfig.getTaskCancellationTimeout();
                }
                if (this.isCanceledOrFailed()) {
                    throw new CancelTaskException();
                }
                Task.LOG.debug("Registering task at network: {}.", (Object)this);
                Task.setupPartitionsAndGates(this.consumableNotifyingPartitionWriters, this.inputGates);
                for (ResultPartitionWriter partitionWriter : this.consumableNotifyingPartitionWriters) {
                    this.taskEventDispatcher.registerPartition(partitionWriter.getPartitionId());
                }
                try {
                    for (Map.Entry entry : DistributedCache.readFileInfoFromConfig((Configuration)this.jobConfiguration)) {
                        Task.LOG.info("Obtaining local cache file for '{}'.", entry.getKey());
                        cp = this.fileCache.createTmpFile((String)entry.getKey(), (DistributedCache.DistributedCacheEntry)entry.getValue(), this.jobId, this.executionId);
                        distributedCacheEntries.put((String)entry.getKey(), cp);
                    }
                }
                catch (Exception e) {
                    throw new Exception(String.format("Exception while adding files to distributed cache of task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}), e);
                }
                if (this.isCanceledOrFailed()) {
                    throw new CancelTaskException();
                }
                kvStateRegistry = this.kvStateService.createKvStateTaskRegistry(this.jobId, this.getJobVertexId());
                env = new RuntimeEnvironment(this.jobId, this.vertexId, this.executionId, executionConfig, this.taskInfo, this.jobConfiguration, this.taskConfiguration, this.userCodeClassLoader, this.memoryManager, this.ioManager, this.broadcastVariableManager, this.taskStateManager, this.aggregateManager, this.accumulatorRegistry, kvStateRegistry, this.inputSplitProvider, distributedCacheEntries, this.consumableNotifyingPartitionWriters, this.inputGates, this.taskEventDispatcher, this.checkpointResponder, this.operatorCoordinatorEventGateway, this.taskManagerConfig, this.metrics, this, this.externalResourceInfoProvider, this.throughputCalculator);
                this.executingThread.setContextClassLoader(this.userCodeClassLoader.asClassLoader());
                FlinkSecurityManager.monitorUserSystemExitForCurrentThread();
                try {
                    invokable = Task.loadAndInstantiateInvokable(this.userCodeClassLoader.asClassLoader(), this.nameOfInvokableClass, env);
                }
                finally {
                    FlinkSecurityManager.unmonitorUserSystemExitForCurrentThread();
                }
                this.invokable = invokable;
                if (!this.transitionState(ExecutionState.DEPLOYING, ExecutionState.INITIALIZING)) {
                    throw new CancelTaskException();
                }
                this.taskManagerActions.updateTaskExecutionState(new TaskExecutionState(this.executionId, ExecutionState.INITIALIZING));
                this.executingThread.setContextClassLoader(this.userCodeClassLoader.asClassLoader());
                this.restoreAndInvoke(invokable);
                if (this.isCanceledOrFailed()) {
                    throw new CancelTaskException();
                }
                for (ResultPartitionWriter partitionWriter : this.consumableNotifyingPartitionWriters) {
                    if (partitionWriter == null) continue;
                    partitionWriter.finish();
                }
                if (this.transitionState(ExecutionState.RUNNING, ExecutionState.FINISHED)) break block48;
                throw new CancelTaskException();
            }
        }
        try {
            Task.LOG.info("Freeing task resources for {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
            this.invokable = null;
            this.releaseResources();
            if (invokable != null) {
                this.memoryManager.releaseAll(invokable);
            }
            this.fileCache.releaseJob(this.jobId, this.executionId);
            Task.LOG.debug("Ensuring all FileSystem streams are closed for task {}", (Object)this);
            FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
            this.notifyFinalState();
        }
        catch (Throwable t) {
            message = String.format("FATAL - exception in resource cleanup of task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId});
            Task.LOG.error(message, t);
            this.notifyFatalError(message, t);
        }
        try {
            this.metrics.close();
            return;
        }
        catch (Throwable t) {
            Task.LOG.error("Error during metrics de-registration of task {} ({}).", new Object[]{this.taskNameWithSubtask, this.executionId, t});
            return;
        }
lbl99:
        // 1 sources

        catch (Throwable t) {
            block50: {
                block49: {
                    try {
                        if (t instanceof WrappingRuntimeException) {
                            t = ((WrappingRuntimeException)t).unwrap();
                        }
                        TaskManagerExceptionUtils.tryEnrichTaskManagerError((Throwable)t);
                        try {
                            if (!ExceptionUtils.isJvmFatalError((Throwable)t) && (!(t instanceof OutOfMemoryError) || !this.taskManagerConfig.shouldExitJvmOnOutOfMemoryError())) break block49;
                            try {
                                Task.LOG.error("Encountered fatal error {} - terminating the JVM", (Object)t.getClass().getName(), (Object)t);
                            }
                            finally {
                                Runtime.getRuntime().halt(-1);
                            }
                        }
                        catch (Throwable tt) {
                            message = String.format("FATAL - exception in exception handler of task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId});
                            Task.LOG.error(message, tt);
                            this.notifyFatalError(message, tt);
                            break block50;
                        }
                    }
lbl117:
                    // 2 sources

                    catch (Throwable var11_27) {
                        try {
                            Task.LOG.info("Freeing task resources for {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
                            this.invokable = null;
                            this.releaseResources();
                            if (invokable != null) {
                                this.memoryManager.releaseAll(invokable);
                            }
                            this.fileCache.releaseJob(this.jobId, this.executionId);
                            Task.LOG.debug("Ensuring all FileSystem streams are closed for task {}", (Object)this);
                            FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
                            this.notifyFinalState();
                        }
                        catch (Throwable t) {
                            message = String.format("FATAL - exception in resource cleanup of task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId});
                            Task.LOG.error(message, t);
                            this.notifyFatalError(message, t);
                        }
                        try {
                            this.metrics.close();
                            throw var11_27;
                        }
                        catch (Throwable t) {
                            Task.LOG.error("Error during metrics de-registration of task {} ({}).", new Object[]{this.taskNameWithSubtask, this.executionId, t});
                        }
                        throw var11_27;
                    }
                }
                while (true) {
                    if ((current = this.executionState) == ExecutionState.RUNNING || current == ExecutionState.INITIALIZING || current == ExecutionState.DEPLOYING) {
                        if (t instanceof CancelTaskException) {
                            if (!this.transitionState(current, ExecutionState.CANCELED)) continue;
                            this.cancelInvokable(invokable);
                            break block50;
                        } else {
                            if (!this.transitionState(current, ExecutionState.FAILED, t)) continue;
                            this.failureCause = t;
                            this.cancelInvokable(invokable);
                        }
                        break block50;
                    }
                    if (current == ExecutionState.CANCELING) {
                        if (!this.transitionState(current, ExecutionState.CANCELED)) continue;
                        break block50;
                    }
                    if (current == ExecutionState.FAILED) break block50;
                    if (this.transitionState(current, ExecutionState.FAILED, t)) break;
                }
                Task.LOG.error("Unexpected state in task {} ({}) during an exception: {}.", new Object[]{this.taskNameWithSubtask, this.executionId, current});
            }
            try {
                Task.LOG.info("Freeing task resources for {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
                this.invokable = null;
                this.releaseResources();
                if (invokable != null) {
                    this.memoryManager.releaseAll(invokable);
                }
                this.fileCache.releaseJob(this.jobId, this.executionId);
                Task.LOG.debug("Ensuring all FileSystem streams are closed for task {}", (Object)this);
                FileSystemSafetyNet.closeSafetyNetAndGuardedResourcesForThread();
                this.notifyFinalState();
            }
            catch (Throwable t) {
                message = String.format("FATAL - exception in resource cleanup of task %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId});
                Task.LOG.error(message, t);
                this.notifyFatalError(message, t);
            }
            try {
                this.metrics.close();
                return;
            }
            catch (Throwable t) {
                Task.LOG.error("Error during metrics de-registration of task {} ({}).", new Object[]{this.taskNameWithSubtask, this.executionId, t});
                return;
            }
        }
    }

    private void restoreAndInvoke(TaskInvokable finalInvokable) throws Exception {
        try {
            this.runWithSystemExitMonitoring(finalInvokable::restore);
            if (!this.transitionState(ExecutionState.INITIALIZING, ExecutionState.RUNNING)) {
                throw new CancelTaskException();
            }
            this.taskManagerActions.updateTaskExecutionState(new TaskExecutionState(this.executionId, ExecutionState.RUNNING));
            this.runWithSystemExitMonitoring(finalInvokable::invoke);
        }
        catch (Throwable throwable) {
            try {
                this.runWithSystemExitMonitoring(() -> finalInvokable.cleanUp(throwable));
            }
            catch (Throwable cleanUpThrowable) {
                throwable.addSuppressed(cleanUpThrowable);
            }
            throw throwable;
        }
        this.runWithSystemExitMonitoring(() -> finalInvokable.cleanUp(null));
    }

    private void runWithSystemExitMonitoring(RunnableWithException action) throws Exception {
        FlinkSecurityManager.monitorUserSystemExitForCurrentThread();
        try {
            action.run();
        }
        finally {
            FlinkSecurityManager.unmonitorUserSystemExitForCurrentThread();
        }
    }

    @VisibleForTesting
    public static void setupPartitionsAndGates(ResultPartitionWriter[] producedPartitions, InputGate[] inputGates) throws IOException {
        for (ResultPartitionWriter resultPartitionWriter : producedPartitions) {
            resultPartitionWriter.setup();
        }
        for (AutoCloseable autoCloseable : inputGates) {
            ((InputGate)autoCloseable).setup();
        }
    }

    private void releaseResources() {
        LOG.debug("Release task {} network resources (state: {}).", (Object)this.taskNameWithSubtask, (Object)this.getExecutionState());
        for (ResultPartitionWriter partitionWriter : this.consumableNotifyingPartitionWriters) {
            this.taskEventDispatcher.unregisterPartition(partitionWriter.getPartitionId());
        }
        if (this.isCanceledOrFailed()) {
            this.failAllResultPartitions();
        }
        this.closeAllResultPartitions();
        this.closeAllInputGates();
        try {
            this.taskStateManager.close();
        }
        catch (Exception e) {
            LOG.error("Failed to close task state manager for task {}.", (Object)this.taskNameWithSubtask, (Object)e);
        }
    }

    private void failAllResultPartitions() {
        for (ResultPartitionWriter partitionWriter : this.consumableNotifyingPartitionWriters) {
            partitionWriter.fail(this.getFailureCause());
        }
    }

    private void closeAllResultPartitions() {
        for (ResultPartitionWriter partitionWriter : this.consumableNotifyingPartitionWriters) {
            try {
                partitionWriter.close();
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalError((Throwable)t);
                LOG.error("Failed to release result partition for task {}.", (Object)this.taskNameWithSubtask, (Object)t);
            }
        }
    }

    private void closeAllInputGates() {
        TaskInvokable invokable = this.invokable;
        if (invokable == null || !invokable.isUsingNonBlockingInput()) {
            for (IndexedInputGate inputGate : this.inputGates) {
                try {
                    inputGate.close();
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrowIfFatalError((Throwable)t);
                    LOG.error("Failed to release input gate for task {}.", (Object)this.taskNameWithSubtask, (Object)t);
                }
            }
        }
    }

    private UserCodeClassLoader createUserCodeClassloader() throws Exception {
        long startDownloadTime = System.currentTimeMillis();
        UserCodeClassLoader userCodeClassLoader = this.classLoaderHandle.getOrResolveClassLoader(this.requiredJarFiles, this.requiredClasspaths);
        LOG.debug("Getting user code class loader for task {} at library cache manager took {} milliseconds", (Object)this.executionId, (Object)(System.currentTimeMillis() - startDownloadTime));
        return userCodeClassLoader;
    }

    private void notifyFinalState() {
        Preconditions.checkState((boolean)this.executionState.isTerminal());
        this.taskManagerActions.updateTaskExecutionState(new TaskExecutionState(this.executionId, this.executionState, this.failureCause));
    }

    private void notifyFatalError(String message, Throwable cause) {
        this.taskManagerActions.notifyFatalError(message, cause);
    }

    private boolean transitionState(ExecutionState currentState, ExecutionState newState) {
        return this.transitionState(currentState, newState, null);
    }

    private boolean transitionState(ExecutionState currentState, ExecutionState newState, Throwable cause) {
        if (STATE_UPDATER.compareAndSet(this, currentState, newState)) {
            if (cause == null) {
                LOG.info("{} ({}) switched from {} to {}.", new Object[]{this.taskNameWithSubtask, this.executionId, currentState, newState});
            } else {
                LOG.warn("{} ({}) switched from {} to {} with failure cause: {}", new Object[]{this.taskNameWithSubtask, this.executionId, currentState, newState, ExceptionUtils.stringifyException((Throwable)cause)});
            }
            return true;
        }
        return false;
    }

    public void cancelExecution() {
        LOG.info("Attempting to cancel task {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
        this.cancelOrFailAndCancelInvokable(ExecutionState.CANCELING, null);
    }

    @Override
    public void failExternally(Throwable cause) {
        LOG.info("Attempting to fail task externally {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
        this.cancelOrFailAndCancelInvokable(ExecutionState.FAILED, cause);
    }

    private void cancelOrFailAndCancelInvokable(ExecutionState targetState, Throwable cause) {
        try {
            this.cancelOrFailAndCancelInvokableInternal(targetState, cause);
        }
        catch (Throwable t) {
            if (ExceptionUtils.isJvmFatalOrOutOfMemoryError((Throwable)t)) {
                String message = String.format("FATAL - exception in cancelling task %s (%s).", this.taskNameWithSubtask, this.executionId);
                this.notifyFatalError(message, t);
            }
            throw t;
        }
    }

    /*
     * Unable to fully structure code
     */
    @VisibleForTesting
    void cancelOrFailAndCancelInvokableInternal(ExecutionState targetState, Throwable cause) {
        block4: {
            do lbl-1000:
            // 3 sources

            {
                block5: {
                    if ((current = this.executionState).isTerminal() || current == ExecutionState.CANCELING) {
                        Task.LOG.info("Task {} is already in state {}", (Object)this.taskNameWithSubtask, (Object)current);
                        return;
                    }
                    if (current != ExecutionState.DEPLOYING && current != ExecutionState.CREATED) break block5;
                    if (!this.transitionState(current, targetState, cause)) ** GOTO lbl-1000
                    this.failureCause = cause;
                    return;
                }
                if (current != ExecutionState.INITIALIZING && current != ExecutionState.RUNNING) break block4;
            } while (!this.transitionState(current, targetState, cause));
            invokable = this.invokable;
            if (invokable != null && this.invokableHasBeenCanceled.compareAndSet(false, true)) {
                this.failureCause = cause;
                Task.LOG.info("Triggering cancellation of task code {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
                canceler = new TaskCanceler(Task.LOG, this.taskCancellationTimeout > 0L ? this.taskCancellationTimeout : (Long)TaskManagerOptions.TASK_CANCELLATION_TIMEOUT.defaultValue(), invokable, this.executingThread, this.taskNameWithSubtask);
                cancelThread = new Thread(this.executingThread.getThreadGroup(), canceler, String.format("Canceler for %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}));
                cancelThread.setDaemon(true);
                cancelThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE);
                cancelThread.start();
                interrupter = new TaskInterrupter(Task.LOG, invokable, this.executingThread, this.taskNameWithSubtask, this.taskCancellationInterval);
                interruptingThread = new Thread(this.executingThread.getThreadGroup(), interrupter, String.format("Canceler/Interrupts for %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}));
                interruptingThread.setDaemon(true);
                interruptingThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE);
                interruptingThread.start();
                if (this.taskCancellationTimeout > 0L) {
                    cancelWatchdog = new TaskCancelerWatchDog(this.taskInfo, this.executingThread, this.taskManagerActions, this.taskCancellationTimeout);
                    watchDogThread = new Thread(this.executingThread.getThreadGroup(), cancelWatchdog, String.format("Cancellation Watchdog for %s (%s).", new Object[]{this.taskNameWithSubtask, this.executionId}));
                    watchDogThread.setDaemon(true);
                    watchDogThread.setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)FatalExitExceptionHandler.INSTANCE);
                    watchDogThread.start();
                }
            }
            return;
        }
        throw new IllegalStateException(String.format("Unexpected state: %s of task %s (%s).", new Object[]{current, this.taskNameWithSubtask, this.executionId}));
    }

    @Override
    public void requestPartitionProducerState(IntermediateDataSetID intermediateDataSetId, ResultPartitionID resultPartitionId, Consumer<? super PartitionProducerStateProvider.ResponseHandle> responseConsumer) {
        CompletableFuture<ExecutionState> futurePartitionState = this.partitionProducerStateChecker.requestPartitionProducerState(this.jobId, intermediateDataSetId, resultPartitionId);
        FutureUtils.assertNoException((CompletableFuture)((CompletableFuture)futurePartitionState.handle((x$0, x$1) -> new PartitionProducerStateResponseHandle((ExecutionState)((Object)x$0), (Throwable)x$1))).thenAcceptAsync(responseConsumer, this.executor));
    }

    public void triggerCheckpointBarrier(long checkpointID, long checkpointTimestamp, CheckpointOptions checkpointOptions) {
        block6: {
            TaskInvokable invokable = this.invokable;
            CheckpointMetaData checkpointMetaData = new CheckpointMetaData(checkpointID, checkpointTimestamp, System.currentTimeMillis());
            if (this.executionState == ExecutionState.RUNNING) {
                Preconditions.checkState((boolean)(invokable instanceof CheckpointableTask), (Object)"invokable is not checkpointable");
                try {
                    ((CheckpointableTask)((Object)invokable)).triggerCheckpointAsync(checkpointMetaData, checkpointOptions).handle((triggerResult, exception) -> {
                        if (exception != null || !triggerResult.booleanValue()) {
                            this.declineCheckpoint(checkpointID, CheckpointFailureReason.TASK_FAILURE, (Throwable)exception);
                            return false;
                        }
                        return true;
                    });
                }
                catch (RejectedExecutionException ex) {
                    LOG.debug("Triggering checkpoint {} for {} ({}) was rejected by the mailbox", new Object[]{checkpointID, this.taskNameWithSubtask, this.executionId});
                    this.declineCheckpoint(checkpointID, CheckpointFailureReason.CHECKPOINT_DECLINED_TASK_CLOSING);
                }
                catch (Throwable t) {
                    if (this.getExecutionState() == ExecutionState.RUNNING) {
                        this.failExternally(new Exception("Error while triggering checkpoint " + checkpointID + " for " + this.taskNameWithSubtask, t));
                        break block6;
                    }
                    LOG.debug("Encountered error while triggering checkpoint {} for {} ({}) while being not in state running.", new Object[]{checkpointID, this.taskNameWithSubtask, this.executionId, t});
                }
            } else {
                LOG.debug("Declining checkpoint request for non-running task {} ({}).", (Object)this.taskNameWithSubtask, (Object)this.executionId);
                this.declineCheckpoint(checkpointID, CheckpointFailureReason.CHECKPOINT_DECLINED_TASK_NOT_READY);
            }
        }
    }

    private void declineCheckpoint(long checkpointID, CheckpointFailureReason failureReason) {
        this.declineCheckpoint(checkpointID, failureReason, null);
    }

    private void declineCheckpoint(long checkpointID, CheckpointFailureReason failureReason, @Nullable Throwable failureCause) {
        this.checkpointResponder.declineCheckpoint(this.jobId, this.executionId, checkpointID, new CheckpointException("Task name with subtask : " + this.taskNameWithSubtask, failureReason, failureCause));
    }

    public void notifyCheckpointComplete(long checkpointID) {
        TaskInvokable invokable = this.invokable;
        if (this.executionState == ExecutionState.RUNNING) {
            Preconditions.checkState((boolean)(invokable instanceof CheckpointableTask), (Object)"invokable is not checkpointable");
            try {
                ((CheckpointableTask)((Object)invokable)).notifyCheckpointCompleteAsync(checkpointID);
            }
            catch (RejectedExecutionException ex) {
                LOG.debug("Notify checkpoint complete {} for {} ({}) was rejected by the mailbox", new Object[]{checkpointID, this.taskNameWithSubtask, this.executionId});
            }
            catch (Throwable t) {
                if (this.getExecutionState() == ExecutionState.RUNNING) {
                    this.failExternally(new RuntimeException("Error while confirming checkpoint", t));
                }
            }
        } else {
            LOG.debug("Ignoring checkpoint commit notification for non-running task {}.", (Object)this.taskNameWithSubtask);
        }
    }

    public void notifyCheckpointAborted(long checkpointID, long latestCompletedCheckpointId) {
        TaskInvokable invokable = this.invokable;
        if (this.executionState == ExecutionState.RUNNING) {
            Preconditions.checkState((boolean)(invokable instanceof CheckpointableTask), (Object)"invokable is not checkpointable");
            try {
                ((CheckpointableTask)((Object)invokable)).notifyCheckpointAbortAsync(checkpointID, latestCompletedCheckpointId);
            }
            catch (RejectedExecutionException ex) {
                LOG.debug("Notify checkpoint abort {} for {} ({}) was rejected by the mailbox", new Object[]{checkpointID, this.taskNameWithSubtask, this.executionId});
            }
            catch (Throwable t) {
                if (this.getExecutionState() == ExecutionState.RUNNING) {
                    this.failExternally(new RuntimeException("Error while aborting checkpoint", t));
                }
            }
        } else {
            LOG.info("Ignoring checkpoint aborted notification for non-running task {}.", (Object)this.taskNameWithSubtask);
        }
    }

    public void deliverOperatorEvent(OperatorID operator, SerializedValue<OperatorEvent> evt) throws FlinkException {
        block4: {
            TaskInvokable invokable = this.invokable;
            ExecutionState currentState = this.executionState;
            if (invokable == null || currentState != ExecutionState.RUNNING && currentState != ExecutionState.INITIALIZING) {
                throw new TaskNotRunningException("Task is not running, but in state " + (Object)((Object)currentState));
            }
            if (invokable instanceof CoordinatedTask) {
                try {
                    ((CoordinatedTask)((Object)invokable)).dispatchOperatorEvent(operator, evt);
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrowIfFatalErrorOrOOM((Throwable)t);
                    if (this.getExecutionState() != ExecutionState.RUNNING && this.getExecutionState() != ExecutionState.INITIALIZING) break block4;
                    FlinkException e = new FlinkException("Error while handling operator event", t);
                    this.failExternally(e);
                    throw e;
                }
            }
        }
    }

    private void cancelInvokable(TaskInvokable invokable) {
        if (invokable != null && this.invokableHasBeenCanceled.compareAndSet(false, true)) {
            try {
                invokable.cancel();
            }
            catch (Throwable t) {
                LOG.error("Error while canceling task {}.", (Object)this.taskNameWithSubtask, (Object)t);
            }
        }
    }

    public String toString() {
        return String.format("%s (%s) [%s]", new Object[]{this.taskNameWithSubtask, this.executionId, this.executionState});
    }

    private static TaskInvokable loadAndInstantiateInvokable(ClassLoader classLoader, String className, Environment environment) throws Throwable {
        Constructor<TaskInvokable> statelessCtor;
        Class<TaskInvokable> invokableClass;
        try {
            invokableClass = Class.forName(className, true, classLoader).asSubclass(TaskInvokable.class);
        }
        catch (Throwable t) {
            throw new Exception("Could not load the task's invokable class.", t);
        }
        try {
            statelessCtor = invokableClass.getConstructor(Environment.class);
        }
        catch (NoSuchMethodException ee) {
            throw new FlinkException("Task misses proper constructor", (Throwable)ee);
        }
        try {
            return statelessCtor.newInstance(environment);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        catch (Exception e) {
            throw new FlinkException("Could not instantiate the task's invokable class.", (Throwable)e);
        }
    }

    public static void logTaskThreadStackTrace(Thread thread, String taskName, long timeoutMs, String action) {
        StackTraceElement[] stack = thread.getStackTrace();
        StringBuilder stackTraceStr = new StringBuilder();
        for (StackTraceElement e : stack) {
            stackTraceStr.append(e).append('\n');
        }
        LOG.warn("Task '{}' did not react to cancelling signal - {}; it is stuck for {} seconds in method:\n {}", new Object[]{taskName, action, timeoutMs / 1000L, stackTraceStr});
    }

    private static class TaskCancelerWatchDog
    implements Runnable {
        private final Thread executerThread;
        private final TaskManagerActions taskManager;
        private final long timeoutMillis;
        private final TaskInfo taskInfo;

        TaskCancelerWatchDog(TaskInfo taskInfo, Thread executerThread, TaskManagerActions taskManager, long timeoutMillis) {
            Preconditions.checkArgument((timeoutMillis > 0L ? 1 : 0) != 0);
            this.taskInfo = taskInfo;
            this.executerThread = executerThread;
            this.taskManager = taskManager;
            this.timeoutMillis = timeoutMillis;
        }

        @Override
        public void run() {
            try {
                long millisLeft;
                long hardKillDeadline = System.nanoTime() + this.timeoutMillis * 1000000L;
                while (this.executerThread.isAlive() && (millisLeft = (hardKillDeadline - System.nanoTime()) / 1000000L) > 0L) {
                    try {
                        this.executerThread.join(millisLeft);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.executerThread.isAlive()) {
                    Task.logTaskThreadStackTrace(this.executerThread, this.taskInfo.getTaskNameWithSubtasks(), this.timeoutMillis, "notifying TM");
                    String msg = "Task did not exit gracefully within " + this.timeoutMillis / 1000L + " + seconds.";
                    this.taskManager.notifyFatalError(msg, (Throwable)new FlinkRuntimeException(msg));
                }
            }
            catch (Throwable t) {
                throw new FlinkRuntimeException("Error in Task Cancellation Watch Dog", t);
            }
        }
    }

    private static final class TaskInterrupter
    implements Runnable {
        private final Logger log;
        private final TaskInvokable task;
        private final Thread executerThread;
        private final String taskName;
        private final long interruptIntervalMillis;

        TaskInterrupter(Logger log, TaskInvokable task, Thread executerThread, String taskName, long interruptIntervalMillis) {
            this.log = log;
            this.task = task;
            this.executerThread = executerThread;
            this.taskName = taskName;
            this.interruptIntervalMillis = interruptIntervalMillis;
        }

        @Override
        public void run() {
            try {
                this.executerThread.join(this.interruptIntervalMillis);
                while (this.executerThread.isAlive()) {
                    this.task.maybeInterruptOnCancel(this.executerThread, this.taskName, this.interruptIntervalMillis);
                    try {
                        this.executerThread.join(this.interruptIntervalMillis);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalError((Throwable)t);
                this.log.error("Error in the task canceler for task {}.", (Object)this.taskName, (Object)t);
            }
        }
    }

    private class TaskCanceler
    implements Runnable {
        private final Logger logger;
        private final long taskCancellationTimeout;
        private final TaskInvokable invokable;
        private final Thread executer;
        private final String taskName;

        TaskCanceler(Logger logger, long taskCancellationTimeout, TaskInvokable invokable, Thread executer, String taskName) {
            this.logger = logger;
            this.taskCancellationTimeout = taskCancellationTimeout;
            this.invokable = invokable;
            this.executer = executer;
            this.taskName = taskName;
        }

        @Override
        public void run() {
            try {
                try {
                    Future<Void> cancellationFuture = this.invokable.cancel();
                    this.invokable.maybeInterruptOnCancel(this.executer, null, null);
                    try {
                        cancellationFuture.get(this.taskCancellationTimeout, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e) {
                        this.logger.debug("Error while waiting the task to terminate {}.", (Object)this.taskName, (Object)e);
                    }
                }
                catch (Throwable t) {
                    ExceptionUtils.rethrowIfFatalError((Throwable)t);
                    this.logger.error("Error while canceling the task {}.", (Object)this.taskName, (Object)t);
                }
                Task.this.failAllResultPartitions();
                Task.this.closeAllInputGates();
            }
            catch (Throwable t) {
                ExceptionUtils.rethrowIfFatalError((Throwable)t);
                this.logger.error("Error in the task canceler for task {}.", (Object)this.taskName, (Object)t);
            }
        }
    }

    @VisibleForTesting
    class PartitionProducerStateResponseHandle
    implements PartitionProducerStateProvider.ResponseHandle {
        private final Either<ExecutionState, Throwable> result;

        PartitionProducerStateResponseHandle(@Nullable ExecutionState producerState, Throwable t) {
            this.result = producerState != null ? Either.Left((Object)((Object)producerState)) : Either.Right((Object)t);
        }

        @Override
        public ExecutionState getConsumerExecutionState() {
            return Task.this.executionState;
        }

        @Override
        public Either<ExecutionState, Throwable> getProducerExecutionState() {
            return this.result;
        }

        @Override
        public void cancelConsumption() {
            Task.this.cancelExecution();
        }

        @Override
        public void failConsumption(Throwable cause) {
            Task.this.failExternally(cause);
        }
    }
}

