/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.taskexecutor;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.blob.PermanentBlobService;
import org.apache.flink.runtime.broadcast.BroadcastVariableManager;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.execution.librarycache.BlobLibraryCacheManager;
import org.apache.flink.runtime.execution.librarycache.LibraryCacheManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.flink.runtime.io.disk.iomanager.IOManagerAsync;
import org.apache.flink.runtime.io.network.TaskEventDispatcher;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.shuffle.ShuffleEnvironment;
import org.apache.flink.runtime.shuffle.ShuffleEnvironmentContext;
import org.apache.flink.runtime.shuffle.ShuffleServiceLoader;
import org.apache.flink.runtime.state.TaskExecutorLocalStateStoresManager;
import org.apache.flink.runtime.state.TaskExecutorStateChangelogStoragesManager;
import org.apache.flink.runtime.taskexecutor.DefaultJobLeaderService;
import org.apache.flink.runtime.taskexecutor.DefaultJobTable;
import org.apache.flink.runtime.taskexecutor.JobLeaderService;
import org.apache.flink.runtime.taskexecutor.JobTable;
import org.apache.flink.runtime.taskexecutor.KvStateService;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceSpec;
import org.apache.flink.runtime.taskexecutor.TaskExecutorResourceUtils;
import org.apache.flink.runtime.taskexecutor.TaskManagerServicesConfiguration;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTable;
import org.apache.flink.runtime.taskexecutor.slot.TaskSlotTableImpl;
import org.apache.flink.runtime.taskexecutor.slot.TimerService;
import org.apache.flink.runtime.taskmanager.Task;
import org.apache.flink.runtime.taskmanager.UnresolvedTaskManagerLocation;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.FlinkException;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManagerServices {
    private static final Logger LOG = LoggerFactory.getLogger(TaskManagerServices.class);
    @VisibleForTesting
    public static final String LOCAL_STATE_SUB_DIRECTORY_ROOT = "localState";
    private final UnresolvedTaskManagerLocation unresolvedTaskManagerLocation;
    private final long managedMemorySize;
    private final IOManager ioManager;
    private final ShuffleEnvironment<?, ?> shuffleEnvironment;
    private final KvStateService kvStateService;
    private final BroadcastVariableManager broadcastVariableManager;
    private final TaskSlotTable<Task> taskSlotTable;
    private final JobTable jobTable;
    private final JobLeaderService jobLeaderService;
    private final TaskExecutorLocalStateStoresManager taskManagerStateStore;
    private final TaskExecutorStateChangelogStoragesManager taskManagerChangelogManager;
    private final TaskEventDispatcher taskEventDispatcher;
    private final ExecutorService ioExecutor;
    private final LibraryCacheManager libraryCacheManager;

    TaskManagerServices(UnresolvedTaskManagerLocation unresolvedTaskManagerLocation, long managedMemorySize, IOManager ioManager, ShuffleEnvironment<?, ?> shuffleEnvironment, KvStateService kvStateService, BroadcastVariableManager broadcastVariableManager, TaskSlotTable<Task> taskSlotTable, JobTable jobTable, JobLeaderService jobLeaderService, TaskExecutorLocalStateStoresManager taskManagerStateStore, TaskExecutorStateChangelogStoragesManager taskManagerChangelogManager, TaskEventDispatcher taskEventDispatcher, ExecutorService ioExecutor, LibraryCacheManager libraryCacheManager) {
        this.unresolvedTaskManagerLocation = (UnresolvedTaskManagerLocation)Preconditions.checkNotNull((Object)unresolvedTaskManagerLocation);
        this.managedMemorySize = managedMemorySize;
        this.ioManager = (IOManager)Preconditions.checkNotNull((Object)ioManager);
        this.shuffleEnvironment = (ShuffleEnvironment)Preconditions.checkNotNull(shuffleEnvironment);
        this.kvStateService = (KvStateService)Preconditions.checkNotNull((Object)kvStateService);
        this.broadcastVariableManager = (BroadcastVariableManager)Preconditions.checkNotNull((Object)broadcastVariableManager);
        this.taskSlotTable = (TaskSlotTable)Preconditions.checkNotNull(taskSlotTable);
        this.jobTable = (JobTable)Preconditions.checkNotNull((Object)jobTable);
        this.jobLeaderService = (JobLeaderService)Preconditions.checkNotNull((Object)jobLeaderService);
        this.taskManagerStateStore = (TaskExecutorLocalStateStoresManager)Preconditions.checkNotNull((Object)taskManagerStateStore);
        this.taskManagerChangelogManager = (TaskExecutorStateChangelogStoragesManager)Preconditions.checkNotNull((Object)taskManagerChangelogManager);
        this.taskEventDispatcher = (TaskEventDispatcher)Preconditions.checkNotNull((Object)taskEventDispatcher);
        this.ioExecutor = (ExecutorService)Preconditions.checkNotNull((Object)ioExecutor);
        this.libraryCacheManager = (LibraryCacheManager)Preconditions.checkNotNull((Object)libraryCacheManager);
    }

    public long getManagedMemorySize() {
        return this.managedMemorySize;
    }

    public IOManager getIOManager() {
        return this.ioManager;
    }

    public ShuffleEnvironment<?, ?> getShuffleEnvironment() {
        return this.shuffleEnvironment;
    }

    public KvStateService getKvStateService() {
        return this.kvStateService;
    }

    public UnresolvedTaskManagerLocation getUnresolvedTaskManagerLocation() {
        return this.unresolvedTaskManagerLocation;
    }

    public BroadcastVariableManager getBroadcastVariableManager() {
        return this.broadcastVariableManager;
    }

    public TaskSlotTable<Task> getTaskSlotTable() {
        return this.taskSlotTable;
    }

    public JobTable getJobTable() {
        return this.jobTable;
    }

    public JobLeaderService getJobLeaderService() {
        return this.jobLeaderService;
    }

    public TaskExecutorLocalStateStoresManager getTaskManagerStateStore() {
        return this.taskManagerStateStore;
    }

    public TaskExecutorStateChangelogStoragesManager getTaskManagerChangelogManager() {
        return this.taskManagerChangelogManager;
    }

    public TaskEventDispatcher getTaskEventDispatcher() {
        return this.taskEventDispatcher;
    }

    public Executor getIOExecutor() {
        return this.ioExecutor;
    }

    public LibraryCacheManager getLibraryCacheManager() {
        return this.libraryCacheManager;
    }

    public void shutDown() throws FlinkException {
        Exception exception = null;
        try {
            this.taskManagerStateStore.shutdown();
        }
        catch (Exception e) {
            exception = e;
        }
        try {
            this.ioManager.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.shuffleEnvironment.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.kvStateService.shutdown();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.taskSlotTable.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.jobLeaderService.stop();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.ioExecutor.shutdown();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.jobTable.close();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        try {
            this.libraryCacheManager.shutdown();
        }
        catch (Exception e) {
            exception = (Exception)ExceptionUtils.firstOrSuppressed((Throwable)e, (Throwable)exception);
        }
        this.taskEventDispatcher.clearAll();
        if (exception != null) {
            throw new FlinkException("Could not properly shut down the TaskManager services.", (Throwable)exception);
        }
    }

    public static TaskManagerServices fromConfiguration(TaskManagerServicesConfiguration taskManagerServicesConfiguration, PermanentBlobService permanentBlobService, MetricGroup taskManagerMetricGroup, ExecutorService ioExecutor, FatalErrorHandler fatalErrorHandler) throws Exception {
        TaskManagerServices.checkTempDirs(taskManagerServicesConfiguration.getTmpDirPaths());
        TaskEventDispatcher taskEventDispatcher = new TaskEventDispatcher();
        IOManagerAsync ioManager = new IOManagerAsync(taskManagerServicesConfiguration.getTmpDirPaths());
        ShuffleEnvironment<?, ?> shuffleEnvironment = TaskManagerServices.createShuffleEnvironment(taskManagerServicesConfiguration, taskEventDispatcher, taskManagerMetricGroup, ioExecutor);
        int listeningDataPort = shuffleEnvironment.start();
        KvStateService kvStateService = KvStateService.fromConfiguration(taskManagerServicesConfiguration);
        kvStateService.start();
        UnresolvedTaskManagerLocation unresolvedTaskManagerLocation = new UnresolvedTaskManagerLocation(taskManagerServicesConfiguration.getResourceID(), taskManagerServicesConfiguration.getExternalAddress(), taskManagerServicesConfiguration.getExternalDataPort() > 0 ? taskManagerServicesConfiguration.getExternalDataPort() : listeningDataPort);
        BroadcastVariableManager broadcastVariableManager = new BroadcastVariableManager();
        TaskSlotTable<Task> taskSlotTable = TaskManagerServices.createTaskSlotTable(taskManagerServicesConfiguration.getNumberOfSlots(), taskManagerServicesConfiguration.getTaskExecutorResourceSpec(), taskManagerServicesConfiguration.getTimerServiceShutdownTimeout(), taskManagerServicesConfiguration.getPageSize(), ioExecutor);
        DefaultJobTable jobTable = DefaultJobTable.create();
        DefaultJobLeaderService jobLeaderService = new DefaultJobLeaderService(unresolvedTaskManagerLocation, taskManagerServicesConfiguration.getRetryingRegistrationConfiguration());
        String[] stateRootDirectoryStrings = taskManagerServicesConfiguration.getLocalRecoveryStateRootDirectories();
        File[] stateRootDirectoryFiles = new File[stateRootDirectoryStrings.length];
        for (int i = 0; i < stateRootDirectoryStrings.length; ++i) {
            stateRootDirectoryFiles[i] = new File(stateRootDirectoryStrings[i], LOCAL_STATE_SUB_DIRECTORY_ROOT);
        }
        TaskExecutorLocalStateStoresManager taskStateManager = new TaskExecutorLocalStateStoresManager(taskManagerServicesConfiguration.isLocalRecoveryEnabled(), stateRootDirectoryFiles, ioExecutor);
        TaskExecutorStateChangelogStoragesManager changelogStoragesManager = new TaskExecutorStateChangelogStoragesManager();
        boolean failOnJvmMetaspaceOomError = taskManagerServicesConfiguration.getConfiguration().getBoolean(CoreOptions.FAIL_ON_USER_CLASS_LOADING_METASPACE_OOM);
        boolean checkClassLoaderLeak = taskManagerServicesConfiguration.getConfiguration().getBoolean(CoreOptions.CHECK_LEAKED_CLASSLOADER);
        BlobLibraryCacheManager libraryCacheManager = new BlobLibraryCacheManager(permanentBlobService, BlobLibraryCacheManager.defaultClassLoaderFactory(taskManagerServicesConfiguration.getClassLoaderResolveOrder(), taskManagerServicesConfiguration.getAlwaysParentFirstLoaderPatterns(), (FatalErrorHandler)(failOnJvmMetaspaceOomError ? fatalErrorHandler : null), checkClassLoaderLeak));
        return new TaskManagerServices(unresolvedTaskManagerLocation, taskManagerServicesConfiguration.getManagedMemorySize().getBytes(), ioManager, shuffleEnvironment, kvStateService, broadcastVariableManager, taskSlotTable, jobTable, jobLeaderService, taskStateManager, changelogStoragesManager, taskEventDispatcher, ioExecutor, libraryCacheManager);
    }

    private static TaskSlotTable<Task> createTaskSlotTable(int numberOfSlots, TaskExecutorResourceSpec taskExecutorResourceSpec, long timerServiceShutdownTimeout, int pageSize, Executor memoryVerificationExecutor) {
        TimerService<AllocationID> timerService = new TimerService<AllocationID>(new ScheduledThreadPoolExecutor(1), timerServiceShutdownTimeout);
        return new TaskSlotTableImpl<Task>(numberOfSlots, TaskExecutorResourceUtils.generateTotalAvailableResourceProfile(taskExecutorResourceSpec), TaskExecutorResourceUtils.generateDefaultSlotResourceProfile(taskExecutorResourceSpec, numberOfSlots), pageSize, timerService, memoryVerificationExecutor);
    }

    private static ShuffleEnvironment<?, ?> createShuffleEnvironment(TaskManagerServicesConfiguration taskManagerServicesConfiguration, TaskEventDispatcher taskEventDispatcher, MetricGroup taskManagerMetricGroup, Executor ioExecutor) throws FlinkException {
        ShuffleEnvironmentContext shuffleEnvironmentContext = new ShuffleEnvironmentContext(taskManagerServicesConfiguration.getConfiguration(), taskManagerServicesConfiguration.getResourceID(), taskManagerServicesConfiguration.getNetworkMemorySize(), taskManagerServicesConfiguration.isLocalCommunicationOnly(), taskManagerServicesConfiguration.getBindAddress(), taskEventDispatcher, taskManagerMetricGroup, ioExecutor);
        return ShuffleServiceLoader.loadShuffleServiceFactory(taskManagerServicesConfiguration.getConfiguration()).createShuffleEnvironment(shuffleEnvironmentContext);
    }

    private static void checkTempDirs(String[] tmpDirs) throws IOException {
        for (String dir : tmpDirs) {
            if (dir != null && !dir.equals("")) {
                File file = new File(dir);
                if (!file.exists() && !file.mkdirs()) {
                    throw new IOException("Temporary file directory " + file.getAbsolutePath() + " does not exist and could not be created.");
                }
                if (!file.isDirectory()) {
                    throw new IOException("Temporary file directory " + file.getAbsolutePath() + " is not a directory.");
                }
                if (!file.canWrite()) {
                    throw new IOException("Temporary file directory " + file.getAbsolutePath() + " is not writable.");
                }
                if (!LOG.isInfoEnabled()) continue;
                long totalSpaceGb = file.getTotalSpace() >> 30;
                long usableSpaceGb = file.getUsableSpace() >> 30;
                double usablePercentage = (double)usableSpaceGb / (double)totalSpaceGb * 100.0;
                String path = file.getAbsolutePath();
                LOG.info(String.format("Temporary file directory '%s': total %d GB, usable %d GB (%.2f%% usable)", path, totalSpaceGb, usableSpaceGb, usablePercentage));
                continue;
            }
            throw new IllegalArgumentException("Temporary file directory #$id is null.");
        }
    }
}

