/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.util.config.memory;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ConfigurationUtils;
import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.configuration.MemorySize;
import org.apache.flink.core.testutils.CommonTestUtils;
import org.apache.flink.runtime.util.config.memory.LegacyMemoryOptions;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryOptions;
import org.apache.flink.runtime.util.config.memory.ProcessMemorySpec;
import org.apache.flink.runtime.util.config.memory.ProcessMemoryUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class ProcessMemoryUtilsTestBase<T extends ProcessMemorySpec>
extends TestLogger {
    private static Map<String, String> oldEnvVariables;
    private final ProcessMemoryOptions options;
    private final LegacyMemoryOptions legacyMemoryOptions;
    private final ConfigOption<MemorySize> newOptionForLegacyHeapOption;

    protected ProcessMemoryUtilsTestBase(ProcessMemoryOptions options, LegacyMemoryOptions legacyMemoryOptions, ConfigOption<MemorySize> newOptionForLegacyHeapOption) {
        this.options = (ProcessMemoryOptions)Preconditions.checkNotNull((Object)options);
        this.legacyMemoryOptions = (LegacyMemoryOptions)Preconditions.checkNotNull((Object)legacyMemoryOptions);
        this.newOptionForLegacyHeapOption = (ConfigOption)Preconditions.checkNotNull(newOptionForLegacyHeapOption);
    }

    @Before
    public void setup() {
        oldEnvVariables = System.getenv();
    }

    @After
    public void teardown() {
        if (oldEnvVariables != null) {
            CommonTestUtils.setEnv(oldEnvVariables, (boolean)true);
        }
    }

    @Test
    public void testGenerateJvmParameters() {
        JvmArgTestingProcessMemorySpec spec = JvmArgTestingProcessMemorySpec.generate();
        String jvmParamsStr = ProcessMemoryUtils.generateJvmParametersStr((ProcessMemorySpec)spec, (boolean)true);
        Map configs = ConfigurationUtils.parseJvmArgString((String)jvmParamsStr);
        Assert.assertThat((Object)configs.size(), (Matcher)Matchers.is((Object)4));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get("-Xmx"))), (Matcher)Matchers.is((Object)spec.getJvmHeapMemorySize()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get("-Xms"))), (Matcher)Matchers.is((Object)spec.getJvmHeapMemorySize()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get("-XX:MaxMetaspaceSize="))), (Matcher)Matchers.is((Object)spec.getJvmMetaspaceSize()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get("-XX:MaxDirectMemorySize="))), (Matcher)Matchers.is((Object)spec.getJvmDirectMemorySize()));
    }

    @Test
    public void testGenerateJvmParametersWithoutDirectMemoryLimit() {
        JvmArgTestingProcessMemorySpec spec = JvmArgTestingProcessMemorySpec.generate();
        String jvmParamsStr = ProcessMemoryUtils.generateJvmParametersStr((ProcessMemorySpec)spec, (boolean)false);
        Map configs = ConfigurationUtils.parseJvmArgString((String)jvmParamsStr);
        Assert.assertThat((Object)configs.size(), (Matcher)Matchers.is((Object)3));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get("-Xmx"))), (Matcher)Matchers.is((Object)spec.getJvmHeapMemorySize()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get("-Xms"))), (Matcher)Matchers.is((Object)spec.getJvmHeapMemorySize()));
        Assert.assertThat((Object)MemorySize.parse((String)((String)configs.get("-XX:MaxMetaspaceSize="))), (Matcher)Matchers.is((Object)spec.getJvmMetaspaceSize()));
        Assert.assertThat((Object)configs.containsKey("-XX:MaxDirectMemorySize="), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void testConfigTotalFlinkMemory() {
        MemorySize totalFlinkMemorySize = MemorySize.parse((String)"1g");
        Configuration conf = new Configuration();
        conf.set(this.options.getTotalFlinkMemoryOption(), (Object)totalFlinkMemorySize);
        T processSpec = this.processSpecFromConfig(conf);
        Assert.assertThat((Object)processSpec.getTotalFlinkMemorySize(), (Matcher)Matchers.is((Object)totalFlinkMemorySize));
    }

    @Test
    public void testConfigTotalProcessMemorySize() {
        MemorySize totalProcessMemorySize = MemorySize.parse((String)"2g");
        Configuration conf = new Configuration();
        conf.set(this.options.getTotalProcessMemoryOption(), (Object)totalProcessMemorySize);
        T processSpec = this.processSpecFromConfig(conf);
        Assert.assertThat((Object)processSpec.getTotalProcessMemorySize(), (Matcher)Matchers.is((Object)totalProcessMemorySize));
    }

    @Test
    public void testExceptionShouldContainRequiredConfigOptions() {
        try {
            this.processSpecFromConfig(new Configuration());
        }
        catch (IllegalConfigurationException e) {
            this.options.getRequiredFineGrainedOptions().forEach(option -> Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)option.key())));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)this.options.getTotalFlinkMemoryOption().key()));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)this.options.getTotalProcessMemoryOption().key()));
        }
    }

    @Test
    public void testDerivedTotalProcessMemoryGreaterThanConfiguredFailureWithFineGrainedOptions() {
        Configuration conf = this.getConfigurationWithJvmMetaspaceAndTotalFlinkMemory(100L, 200L);
        MemorySize totalFlinkMemorySize = MemorySize.ofMebiBytes((long)150L);
        this.configWithFineGrainedOptions(conf, totalFlinkMemorySize);
        this.validateFail(conf);
    }

    @Test
    public void testDerivedTotalProcessMemoryGreaterThanConfiguredFailureWithTotalFlinkMemory() {
        Configuration conf = this.getConfigurationWithJvmMetaspaceAndTotalFlinkMemory(100L, 200L);
        MemorySize totalFlinkMemorySize = MemorySize.ofMebiBytes((long)150L);
        conf.set(this.options.getTotalFlinkMemoryOption(), (Object)totalFlinkMemorySize);
        this.validateFail(conf);
    }

    private Configuration getConfigurationWithJvmMetaspaceAndTotalFlinkMemory(long jvmMetaspaceSizeMb, long totalProcessMemorySizeMb) {
        MemorySize jvmMetaspaceSize = MemorySize.ofMebiBytes((long)jvmMetaspaceSizeMb);
        MemorySize totalProcessMemorySize = MemorySize.ofMebiBytes((long)totalProcessMemorySizeMb);
        Configuration conf = new Configuration();
        conf.set(this.options.getJvmOptions().getJvmMetaspaceOption(), (Object)jvmMetaspaceSize);
        conf.set(this.options.getTotalProcessMemoryOption(), (Object)totalProcessMemorySize);
        return conf;
    }

    @Test
    public void testConfigJvmMetaspaceSize() {
        MemorySize jvmMetaspaceSize = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(this.options.getJvmOptions().getJvmMetaspaceOption(), (Object)jvmMetaspaceSize);
        this.validateInAllConfigurations(conf, processSpec -> Assert.assertThat((Object)processSpec.getJvmMetaspaceSize(), (Matcher)Matchers.is((Object)jvmMetaspaceSize)));
    }

    @Test
    public void testConfigJvmOverheadRange() {
        MemorySize minSize = MemorySize.parse((String)"50m");
        MemorySize maxSize = MemorySize.parse((String)"200m");
        Configuration conf = new Configuration();
        conf.set(this.options.getJvmOptions().getJvmOverheadMax(), (Object)maxSize);
        conf.set(this.options.getJvmOptions().getJvmOverheadMin(), (Object)minSize);
        this.validateInAllConfigurations(conf, JobManagerProcessSpec2 -> {
            Assert.assertThat((Object)JobManagerProcessSpec2.getJvmOverheadSize().getBytes(), (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(minSize.getBytes())));
            Assert.assertThat((Object)JobManagerProcessSpec2.getJvmOverheadSize().getBytes(), (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(maxSize.getBytes())));
        });
    }

    @Test
    public void testConfigJvmOverheadRangeFailure() {
        MemorySize minSize = MemorySize.parse((String)"200m");
        MemorySize maxSize = MemorySize.parse((String)"50m");
        Configuration conf = new Configuration();
        conf.set(this.options.getJvmOptions().getJvmOverheadMax(), (Object)maxSize);
        conf.set(this.options.getJvmOptions().getJvmOverheadMin(), (Object)minSize);
        this.validateFailInAllConfigurations(conf);
    }

    @Test
    public void testConfigJvmOverheadFraction() {
        MemorySize minSize = MemorySize.ZERO;
        MemorySize maxSize = MemorySize.parse((String)"1t");
        float fraction = 0.2f;
        Configuration conf = new Configuration();
        conf.set(this.options.getJvmOptions().getJvmOverheadMax(), (Object)maxSize);
        conf.set(this.options.getJvmOptions().getJvmOverheadMin(), (Object)minSize);
        conf.setFloat(this.options.getJvmOptions().getJvmOverheadFraction(), fraction);
        this.validateInAllConfigurations(conf, jobManagerProcessSpec -> Assert.assertThat((Object)jobManagerProcessSpec.getJvmOverheadSize(), (Matcher)Matchers.is((Object)jobManagerProcessSpec.getTotalProcessMemorySize().multiply((double)fraction))));
    }

    @Test
    public void testConfigJvmOverheadFractionFailureNegative() {
        Configuration conf = new Configuration();
        conf.setFloat(this.options.getJvmOptions().getJvmOverheadFraction(), -0.1f);
        this.validateFailInAllConfigurations(conf);
    }

    @Test
    public void testConfigJvmOverheadFractionFailureNoLessThanOne() {
        Configuration conf = new Configuration();
        conf.setFloat(this.options.getJvmOptions().getJvmOverheadFraction(), 1.0f);
        this.validateFailInAllConfigurations(conf);
    }

    @Test
    public void testConfigJvmOverheadDeriveFromProcessAndFlinkMemorySize() {
        Configuration conf = new Configuration();
        conf.set(this.options.getTotalProcessMemoryOption(), (Object)MemorySize.parse((String)"1000m"));
        conf.set(this.options.getTotalFlinkMemoryOption(), (Object)MemorySize.parse((String)"800m"));
        conf.set(this.options.getJvmOptions().getJvmMetaspaceOption(), (Object)MemorySize.parse((String)"100m"));
        conf.set(this.options.getJvmOptions().getJvmOverheadMin(), (Object)MemorySize.parse((String)"50m"));
        conf.set(this.options.getJvmOptions().getJvmOverheadMax(), (Object)MemorySize.parse((String)"200m"));
        conf.set(this.options.getJvmOptions().getJvmOverheadFraction(), (Object)Float.valueOf(0.5f));
        T jobManagerProcessSpec = this.processSpecFromConfig(conf);
        Assert.assertThat((Object)jobManagerProcessSpec.getJvmOverheadSize(), (Matcher)Matchers.is((Object)MemorySize.parse((String)"100m")));
    }

    @Test
    public void testConfigJvmOverheadDeriveFromProcessAndFlinkMemorySizeFailure() {
        Configuration conf = new Configuration();
        conf.set(this.options.getTotalProcessMemoryOption(), (Object)MemorySize.parse((String)"1000m"));
        conf.set(this.options.getTotalFlinkMemoryOption(), (Object)MemorySize.parse((String)"800m"));
        conf.set(this.options.getJvmOptions().getJvmMetaspaceOption(), (Object)MemorySize.parse((String)"100m"));
        conf.set(this.options.getJvmOptions().getJvmOverheadMin(), (Object)MemorySize.parse((String)"150m"));
        conf.set(this.options.getJvmOptions().getJvmOverheadMax(), (Object)MemorySize.parse((String)"200m"));
        conf.set(this.options.getJvmOptions().getJvmOverheadFraction(), (Object)Float.valueOf(0.5f));
        this.validateFail(conf);
    }

    @Test
    public void testConfigLegacyHeapSize() {
        MemorySize legacyHeapSize = MemorySize.parse((String)"1g");
        Configuration conf = new Configuration();
        conf.set(this.legacyMemoryOptions.getHeap(), (Object)legacyHeapSize);
        this.testConfigLegacyHeapMemory(conf, legacyHeapSize);
    }

    @Test
    public void testConfigLegacyHeapMB() {
        MemorySize jvmHeapSize = MemorySize.parse((String)"1g");
        Configuration conf = new Configuration();
        conf.set(this.legacyMemoryOptions.getHeapMb(), (Object)jvmHeapSize.getMebiBytes());
        this.testConfigLegacyHeapMemory(conf, jvmHeapSize);
    }

    @Test
    public void testConfigLegacyHeapEnv() {
        MemorySize jvmHeapSize = MemorySize.parse((String)"1g");
        HashMap<String, String> env = new HashMap<String, String>();
        env.put(this.legacyMemoryOptions.getEnvVar(), "1g");
        CommonTestUtils.setEnv(env);
        this.testConfigLegacyHeapMemory(new Configuration(), jvmHeapSize);
    }

    @Test
    public void testConfigBothNewOptionAndLegacyHeapSize() {
        MemorySize newOptionValue = MemorySize.parse((String)"1g");
        MemorySize legacyHeapSize = MemorySize.parse((String)"2g");
        Configuration conf = new Configuration();
        conf.set(this.getNewOptionForLegacyHeapOption(), (Object)newOptionValue);
        conf.set(this.legacyMemoryOptions.getHeap(), (Object)legacyHeapSize);
        this.testConfigLegacyHeapMemory(conf, newOptionValue);
    }

    private void testConfigLegacyHeapMemory(Configuration configuration, MemorySize expected) {
        MemorySize newOptionValue = (MemorySize)this.getConfigurationWithLegacyHeapSizeMappedToNewConfigOption(configuration).get(this.getNewOptionForLegacyHeapOption());
        Assert.assertThat((Object)newOptionValue, (Matcher)Matchers.is((Object)expected));
    }

    @Test
    public void testConfigTotalProcessMemoryAddUpFailure() {
        MemorySize totalProcessMemory = MemorySize.parse((String)"699m");
        MemorySize totalFlinkMemory = MemorySize.parse((String)"500m");
        MemorySize jvmMetaspace = MemorySize.parse((String)"100m");
        MemorySize jvmOverhead = MemorySize.parse((String)"100m");
        Configuration conf = new Configuration();
        conf.set(this.options.getTotalProcessMemoryOption(), (Object)totalProcessMemory);
        conf.set(this.options.getTotalFlinkMemoryOption(), (Object)totalFlinkMemory);
        conf.set(this.options.getJvmOptions().getJvmMetaspaceOption(), (Object)jvmMetaspace);
        conf.set(this.options.getJvmOptions().getJvmOverheadMin(), (Object)jvmOverhead);
        conf.set(this.options.getJvmOptions().getJvmOverheadMax(), (Object)jvmOverhead);
        this.validateFail(conf);
    }

    protected abstract void validateInAllConfigurations(Configuration var1, Consumer<T> var2);

    protected abstract void validateFailInAllConfigurations(Configuration var1);

    protected abstract void validateFail(Configuration var1);

    protected abstract T processSpecFromConfig(Configuration var1);

    protected abstract Configuration getConfigurationWithLegacyHeapSizeMappedToNewConfigOption(Configuration var1);

    protected abstract void configWithFineGrainedOptions(Configuration var1, MemorySize var2);

    protected ConfigOption<MemorySize> getNewOptionForLegacyHeapOption() {
        return this.newOptionForLegacyHeapOption;
    }

    private static class JvmArgTestingProcessMemorySpec
    implements ProcessMemorySpec {
        private static final long serialVersionUID = 2863985135320165745L;
        private final MemorySize heap;
        private final MemorySize directMemory;
        private final MemorySize metaspace;

        private JvmArgTestingProcessMemorySpec(MemorySize heap, MemorySize directMemory, MemorySize metaspace) {
            this.heap = heap;
            this.directMemory = directMemory;
            this.metaspace = metaspace;
        }

        public MemorySize getJvmHeapMemorySize() {
            return this.heap;
        }

        public MemorySize getJvmDirectMemorySize() {
            return this.directMemory;
        }

        public MemorySize getJvmMetaspaceSize() {
            return this.metaspace;
        }

        public MemorySize getJvmOverheadSize() {
            throw new UnsupportedOperationException();
        }

        public MemorySize getTotalFlinkMemorySize() {
            throw new UnsupportedOperationException();
        }

        public MemorySize getTotalProcessMemorySize() {
            throw new UnsupportedOperationException();
        }

        public static JvmArgTestingProcessMemorySpec generate() {
            return new JvmArgTestingProcessMemorySpec(MemorySize.ofMebiBytes((long)1L), MemorySize.ofMebiBytes((long)2L), MemorySize.ofMebiBytes((long)3L));
        }
    }
}

