/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.state.changelog.inmemory;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.flink.configuration.CheckpointingOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.core.plugin.PluginManager;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.changelog.ChangelogStateHandle;
import org.apache.flink.runtime.state.changelog.StateChangelogHandleReader;
import org.apache.flink.runtime.state.changelog.StateChangelogStorage;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageFactory;
import org.apache.flink.runtime.state.changelog.StateChangelogStorageLoader;
import org.apache.flink.runtime.state.changelog.StateChangelogWriter;
import org.apache.flink.runtime.state.changelog.inmemory.InMemoryStateChangelogStorageFactory;
import org.apache.flink.util.Preconditions;
import org.junit.Assert;
import org.junit.Test;

public class StateChangelogStorageLoaderTest {
    @Test
    public void testLoadSpiImplementation() throws IOException {
        StateChangelogStorageLoader.initialize((PluginManager)this.getPluginManager(Collections.emptyIterator()));
        Assert.assertNotNull((Object)StateChangelogStorageLoader.load((Configuration)new Configuration()));
    }

    @Test
    public void testLoadNotExist() throws IOException {
        StateChangelogStorageLoader.initialize((PluginManager)this.getPluginManager(Collections.emptyIterator()));
        Assert.assertNull((Object)StateChangelogStorageLoader.load((Configuration)new Configuration().set(CheckpointingOptions.STATE_CHANGE_LOG_STORAGE, (Object)"not_exist")));
    }

    @Test
    public void testLoadPluginImplementation() throws IOException {
        TestStateChangelogStorageFactory factory = new TestStateChangelogStorageFactory();
        PluginManager pluginManager = this.getPluginManager(Collections.singletonList(factory).iterator());
        StateChangelogStorageLoader.initialize((PluginManager)pluginManager);
        StateChangelogStorage loaded = StateChangelogStorageLoader.load((Configuration)new Configuration());
        Assert.assertTrue((boolean)(loaded instanceof TestStateChangelogStorage));
    }

    private PluginManager getPluginManager(final Iterator<? extends StateChangelogStorageFactory> iterator) {
        return new PluginManager(){

            public <P> Iterator<P> load(Class<P> service) {
                Preconditions.checkArgument((boolean)service.equals(StateChangelogStorageFactory.class));
                return iterator;
            }
        };
    }

    private static class TestStateChangelogStorageFactory
    implements StateChangelogStorageFactory {
        private TestStateChangelogStorageFactory() {
        }

        public String getIdentifier() {
            return InMemoryStateChangelogStorageFactory.identifier;
        }

        public StateChangelogStorage<?> createStorage(Configuration configuration) {
            return new TestStateChangelogStorage();
        }
    }

    private static class TestStateChangelogStorage
    implements StateChangelogStorage<ChangelogStateHandle> {
        private TestStateChangelogStorage() {
        }

        public StateChangelogWriter<ChangelogStateHandle> createWriter(String operatorID, KeyGroupRange keyGroupRange) {
            return null;
        }

        public StateChangelogHandleReader<ChangelogStateHandle> createReader() {
            return null;
        }
    }
}

