/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.rpc;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.rpc.MainThreadExecutable;
import org.apache.flink.runtime.rpc.RpcEndpoint;
import org.apache.flink.runtime.rpc.RpcGateway;
import org.apache.flink.runtime.rpc.RpcService;
import org.apache.flink.runtime.rpc.RpcSystem;
import org.apache.flink.runtime.rpc.RpcUtils;
import org.apache.flink.util.TestLogger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class RpcEndpointTest
extends TestLogger {
    private static final Time TIMEOUT = Time.seconds((long)10L);
    private static RpcService rpcService = null;

    @BeforeClass
    public static void setup() throws Exception {
        rpcService = RpcSystem.load().localServiceBuilder(new Configuration()).createAndStart();
    }

    @AfterClass
    public static void teardown() throws Exception {
        rpcService.stopService().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSelfGateway() throws Exception {
        int expectedValue = 1337;
        BaseEndpoint baseEndpoint = new BaseEndpoint(rpcService, expectedValue);
        try {
            baseEndpoint.start();
            BaseGateway baseGateway = (BaseGateway)baseEndpoint.getSelfGateway(BaseGateway.class);
            CompletableFuture<Integer> foobar = baseGateway.foobar();
            Assert.assertEquals((Object)expectedValue, (Object)foobar.get());
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)baseEndpoint, (Time)TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=RuntimeException.class)
    public void testWrongSelfGateway() throws Exception {
        int expectedValue = 1337;
        BaseEndpoint baseEndpoint = new BaseEndpoint(rpcService, expectedValue);
        try {
            baseEndpoint.start();
            DifferentGateway differentGateway = (DifferentGateway)baseEndpoint.getSelfGateway(DifferentGateway.class);
            Assert.fail((String)"Expected to fail with a RuntimeException since we requested the wrong gateway type.");
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)baseEndpoint, (Time)TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEndpointInheritance() throws Exception {
        int foobar = 1;
        int barfoo = 2;
        String foo = "foobar";
        ExtendedEndpoint endpoint = new ExtendedEndpoint(rpcService, foobar, barfoo, foo);
        try {
            endpoint.start();
            BaseGateway baseGateway = (BaseGateway)endpoint.getSelfGateway(BaseGateway.class);
            ExtendedGateway extendedGateway = (ExtendedGateway)endpoint.getSelfGateway(ExtendedGateway.class);
            DifferentGateway differentGateway = (DifferentGateway)endpoint.getSelfGateway(DifferentGateway.class);
            Assert.assertEquals((Object)foobar, (Object)baseGateway.foobar().get());
            Assert.assertEquals((Object)foobar, (Object)extendedGateway.foobar().get());
            Assert.assertEquals((Object)barfoo, (Object)extendedGateway.barfoo().get());
            Assert.assertEquals((Object)foo, (Object)differentGateway.foo().get());
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)endpoint, (Time)TIMEOUT);
        }
    }

    @Test
    public void testRunningState() throws InterruptedException, ExecutionException, TimeoutException {
        RunningStateTestingEndpoint endpoint = new RunningStateTestingEndpoint(rpcService, CompletableFuture.completedFuture(null));
        RunningStateTestingEndpointGateway gateway = (RunningStateTestingEndpointGateway)endpoint.getSelfGateway(RunningStateTestingEndpointGateway.class);
        try {
            endpoint.start();
            Assert.assertThat((Object)gateway.queryIsRunningFlag().get(), (Matcher)CoreMatchers.is((Object)true));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)endpoint, (Time)TIMEOUT);
        }
    }

    @Test
    public void testNotRunningState() throws InterruptedException, ExecutionException, TimeoutException {
        CompletableFuture<Void> stopFuture = new CompletableFuture<Void>();
        RunningStateTestingEndpoint endpoint = new RunningStateTestingEndpoint(rpcService, stopFuture);
        RunningStateTestingEndpointGateway gateway = (RunningStateTestingEndpointGateway)endpoint.getSelfGateway(RunningStateTestingEndpointGateway.class);
        endpoint.start();
        CompletableFuture<Void> terminationFuture = endpoint.closeAndWaitUntilOnStopCalled();
        Assert.assertThat((Object)gateway.queryIsRunningFlag().get(), (Matcher)CoreMatchers.is((Object)false));
        stopFuture.complete(null);
        terminationFuture.get(TIMEOUT.toMilliseconds(), TimeUnit.MILLISECONDS);
    }

    @Test
    public void testExecute() throws InterruptedException, ExecutionException, TimeoutException {
        BaseEndpoint endpoint = new BaseEndpoint(rpcService);
        CompletableFuture asyncExecutionFuture = new CompletableFuture();
        try {
            endpoint.start();
            endpoint.getMainThreadExecutor().execute(() -> {
                endpoint.validateRunsInMainThread();
                asyncExecutionFuture.complete(null);
            });
            asyncExecutionFuture.get(TIMEOUT.getSize(), TIMEOUT.getUnit());
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)endpoint, (Time)TIMEOUT);
        }
    }

    @Test
    public void testScheduleRunnableWithDelayInMilliseconds() throws Exception {
        RpcEndpointTest.testScheduleWithDelay((mainThreadExecutor, expectedDelay) -> mainThreadExecutor.schedule(() -> {}, expectedDelay.toMillis(), TimeUnit.MILLISECONDS));
    }

    @Test
    public void testScheduleRunnableWithDelayInSeconds() throws Exception {
        RpcEndpointTest.testScheduleWithDelay((mainThreadExecutor, expectedDelay) -> mainThreadExecutor.schedule(() -> {}, expectedDelay.toMillis() / 1000L, TimeUnit.SECONDS));
    }

    @Test
    public void testScheduleCallableWithDelayInMilliseconds() throws Exception {
        RpcEndpointTest.testScheduleWithDelay((mainThreadExecutor, expectedDelay) -> mainThreadExecutor.schedule(() -> 1, expectedDelay.toMillis(), TimeUnit.MILLISECONDS));
    }

    @Test
    public void testScheduleCallableWithDelayInSeconds() throws Exception {
        RpcEndpointTest.testScheduleWithDelay((mainThreadExecutor, expectedDelay) -> mainThreadExecutor.schedule(() -> 1, expectedDelay.toMillis() / 1000L, TimeUnit.SECONDS));
    }

    private static void testScheduleWithDelay(BiConsumer<RpcEndpoint.MainThreadExecutor, Duration> scheduler) throws Exception {
        CompletableFuture actualDelayMsFuture = new CompletableFuture();
        TestMainThreadExecutable mainThreadExecutable = new TestMainThreadExecutable((runnable, delay) -> actualDelayMsFuture.complete(delay));
        RpcEndpoint.MainThreadExecutor mainThreadExecutor = new RpcEndpoint.MainThreadExecutor((MainThreadExecutable)mainThreadExecutable, () -> {});
        Duration expectedDelay = Duration.ofSeconds(1L);
        scheduler.accept(mainThreadExecutor, expectedDelay);
        Assert.assertThat(actualDelayMsFuture.get(), (Matcher)CoreMatchers.is((Object)expectedDelay.toMillis()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallAsync() throws InterruptedException, ExecutionException, TimeoutException {
        BaseEndpoint endpoint = new BaseEndpoint(rpcService);
        Integer expectedInteger = 12345;
        try {
            endpoint.start();
            CompletableFuture integerFuture = endpoint.callAsync(() -> {
                endpoint.validateRunsInMainThread();
                return expectedInteger;
            }, TIMEOUT);
            Assert.assertEquals((Object)expectedInteger, integerFuture.get(TIMEOUT.getSize(), TIMEOUT.getUnit()));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)endpoint, (Time)TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCallAsyncTimeout() throws InterruptedException, ExecutionException, TimeoutException {
        BaseEndpoint endpoint = new BaseEndpoint(rpcService);
        Time timeout = Time.milliseconds((long)100L);
        try {
            endpoint.start();
            CompletionStage throwableFuture = endpoint.callAsync(() -> {
                endpoint.validateRunsInMainThread();
                TimeUnit.MILLISECONDS.sleep(timeout.toMilliseconds() * 2L);
                return 12345;
            }, timeout).handle((ignore, throwable) -> throwable);
            Throwable throwable2 = (Throwable)((CompletableFuture)throwableFuture).get(timeout.getSize() * 2L, timeout.getUnit());
            Assert.assertTrue((boolean)(throwable2 instanceof TimeoutException));
        }
        finally {
            RpcUtils.terminateRpcEndpoint((RpcEndpoint)endpoint, (Time)TIMEOUT);
        }
    }

    private static class TestMainThreadExecutable
    implements MainThreadExecutable {
        private final BiConsumer<Runnable, Long> scheduleRunAsyncConsumer;

        private TestMainThreadExecutable(BiConsumer<Runnable, Long> scheduleRunAsyncConsumer) {
            this.scheduleRunAsyncConsumer = scheduleRunAsyncConsumer;
        }

        public void runAsync(Runnable runnable) {
            throw new UnsupportedOperationException();
        }

        public <V> CompletableFuture<V> callAsync(Callable<V> callable, Time callTimeout) {
            throw new UnsupportedOperationException();
        }

        public void scheduleRunAsync(Runnable runnable, long delay) {
            this.scheduleRunAsyncConsumer.accept(runnable, delay);
        }
    }

    private static final class RunningStateTestingEndpoint
    extends RpcEndpoint
    implements RunningStateTestingEndpointGateway {
        private final CountDownLatch onStopCalled;
        private final CompletableFuture<Void> stopFuture;

        RunningStateTestingEndpoint(RpcService rpcService, CompletableFuture<Void> stopFuture) {
            super(rpcService);
            this.stopFuture = stopFuture;
            this.onStopCalled = new CountDownLatch(1);
        }

        public CompletableFuture<Void> onStop() {
            this.onStopCalled.countDown();
            return this.stopFuture;
        }

        CompletableFuture<Void> closeAndWaitUntilOnStopCalled() throws InterruptedException {
            CompletableFuture terminationFuture = this.closeAsync();
            this.onStopCalled.await();
            return terminationFuture;
        }

        @Override
        public CompletableFuture<Boolean> queryIsRunningFlag() {
            return CompletableFuture.completedFuture(this.isRunning());
        }
    }

    public static interface RunningStateTestingEndpointGateway
    extends RpcGateway {
        public CompletableFuture<Boolean> queryIsRunningFlag();
    }

    public static class ExtendedEndpoint
    extends BaseEndpoint
    implements ExtendedGateway,
    DifferentGateway {
        private final int barfooValue;
        private final String fooString;

        protected ExtendedEndpoint(RpcService rpcService, int foobarValue, int barfooValue, String fooString) {
            super(rpcService, foobarValue);
            this.barfooValue = barfooValue;
            this.fooString = fooString;
        }

        @Override
        public CompletableFuture<Integer> barfoo() {
            return CompletableFuture.completedFuture(this.barfooValue);
        }

        @Override
        public CompletableFuture<String> foo() {
            return CompletableFuture.completedFuture(this.fooString);
        }
    }

    public static class BaseEndpoint
    extends RpcEndpoint
    implements BaseGateway {
        private final int foobarValue;

        protected BaseEndpoint(RpcService rpcService) {
            super(rpcService);
            this.foobarValue = Integer.MAX_VALUE;
        }

        protected BaseEndpoint(RpcService rpcService, int foobarValue) {
            super(rpcService);
            this.foobarValue = foobarValue;
        }

        @Override
        public CompletableFuture<Integer> foobar() {
            return CompletableFuture.completedFuture(this.foobarValue);
        }
    }

    public static interface DifferentGateway
    extends RpcGateway {
        public CompletableFuture<String> foo();
    }

    public static interface ExtendedGateway
    extends BaseGateway {
        public CompletableFuture<Integer> barfoo();
    }

    public static interface BaseGateway
    extends RpcGateway {
        public CompletableFuture<Integer> foobar();
    }
}

