/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.minicluster;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.blob.BlobServer;
import org.apache.flink.runtime.dispatcher.DispatcherGateway;
import org.apache.flink.runtime.dispatcher.ExecutionGraphInfoStore;
import org.apache.flink.runtime.dispatcher.MemoryExecutionGraphInfoStore;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponent;
import org.apache.flink.runtime.entrypoint.component.DispatcherResourceManagerComponentFactory;
import org.apache.flink.runtime.heartbeat.HeartbeatServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.metrics.MetricRegistry;
import org.apache.flink.runtime.minicluster.MiniCluster;
import org.apache.flink.runtime.minicluster.MiniClusterConfiguration;
import org.apache.flink.runtime.minicluster.TestingMiniClusterConfiguration;
import org.apache.flink.runtime.rpc.FatalErrorHandler;
import org.apache.flink.runtime.webmonitor.retriever.MetricQueryServiceRetriever;

public class TestingMiniCluster
extends MiniCluster {
    private final int numberDispatcherResourceManagerComponents;
    private final boolean localCommunication;
    @Nullable
    private final Supplier<HighAvailabilityServices> highAvailabilityServicesSupplier;

    public TestingMiniCluster(TestingMiniClusterConfiguration miniClusterConfiguration, @Nullable Supplier<HighAvailabilityServices> highAvailabilityServicesSupplier) {
        super((MiniClusterConfiguration)miniClusterConfiguration);
        this.numberDispatcherResourceManagerComponents = miniClusterConfiguration.getNumberDispatcherResourceManagerComponents();
        this.highAvailabilityServicesSupplier = highAvailabilityServicesSupplier;
        this.localCommunication = miniClusterConfiguration.isLocalCommunication();
    }

    public TestingMiniCluster(TestingMiniClusterConfiguration miniClusterConfiguration) {
        this(miniClusterConfiguration, null);
    }

    protected boolean useLocalCommunication() {
        return this.localCommunication;
    }

    protected HighAvailabilityServices createHighAvailabilityServices(Configuration configuration, Executor executor) throws Exception {
        if (this.highAvailabilityServicesSupplier != null) {
            return this.highAvailabilityServicesSupplier.get();
        }
        return super.createHighAvailabilityServices(configuration, executor);
    }

    protected Collection<? extends DispatcherResourceManagerComponent> createDispatcherResourceManagerComponents(Configuration configuration, MiniCluster.RpcServiceFactory rpcServiceFactory, HighAvailabilityServices haServices, BlobServer blobServer, HeartbeatServices heartbeatServices, MetricRegistry metricRegistry, MetricQueryServiceRetriever metricQueryServiceRetriever, FatalErrorHandler fatalErrorHandler) throws Exception {
        DispatcherResourceManagerComponentFactory dispatcherResourceManagerComponentFactory = this.createDispatcherResourceManagerComponentFactory();
        ArrayList<DispatcherResourceManagerComponent> result = new ArrayList<DispatcherResourceManagerComponent>(this.numberDispatcherResourceManagerComponents);
        for (int i = 0; i < this.numberDispatcherResourceManagerComponents; ++i) {
            result.add(dispatcherResourceManagerComponentFactory.create(configuration, this.getIOExecutor(), rpcServiceFactory.createRpcService(), haServices, blobServer, heartbeatServices, metricRegistry, (ExecutionGraphInfoStore)new MemoryExecutionGraphInfoStore(), metricQueryServiceRetriever, fatalErrorHandler));
        }
        return result;
    }

    public CompletableFuture<DispatcherGateway> getDispatcherGatewayFuture() {
        return super.getDispatcherGatewayFuture();
    }
}

