/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.metrics.dump;

import org.apache.flink.runtime.metrics.dump.MetricDump;
import org.apache.flink.runtime.metrics.dump.QueryScopeInfo;
import org.junit.Assert;
import org.junit.Test;

public class MetricDumpTest {
    @Test
    public void testDumpedCounter() {
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo();
        MetricDump.CounterDump cd = new MetricDump.CounterDump((QueryScopeInfo)info, "counter", 4L);
        Assert.assertEquals((Object)"counter", (Object)cd.name);
        Assert.assertEquals((long)4L, (long)cd.count);
        Assert.assertEquals((Object)info, (Object)cd.scopeInfo);
        Assert.assertEquals((long)0L, (long)cd.getCategory());
    }

    @Test
    public void testDumpedGauge() {
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo();
        MetricDump.GaugeDump gd = new MetricDump.GaugeDump((QueryScopeInfo)info, "gauge", "hello");
        Assert.assertEquals((Object)"gauge", (Object)gd.name);
        Assert.assertEquals((Object)"hello", (Object)gd.value);
        Assert.assertEquals((Object)info, (Object)gd.scopeInfo);
        Assert.assertEquals((long)1L, (long)gd.getCategory());
    }

    @Test
    public void testDumpedHistogram() {
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo();
        MetricDump.HistogramDump hd = new MetricDump.HistogramDump((QueryScopeInfo)info, "hist", 1L, 2L, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0);
        Assert.assertEquals((Object)"hist", (Object)hd.name);
        Assert.assertEquals((long)1L, (long)hd.min);
        Assert.assertEquals((long)2L, (long)hd.max);
        Assert.assertEquals((double)3.0, (double)hd.mean, (double)0.1);
        Assert.assertEquals((double)4.0, (double)hd.median, (double)0.1);
        Assert.assertEquals((double)5.0, (double)hd.stddev, (double)0.1);
        Assert.assertEquals((double)6.0, (double)hd.p75, (double)0.1);
        Assert.assertEquals((double)7.0, (double)hd.p90, (double)0.1);
        Assert.assertEquals((double)8.0, (double)hd.p95, (double)0.1);
        Assert.assertEquals((double)9.0, (double)hd.p98, (double)0.1);
        Assert.assertEquals((double)10.0, (double)hd.p99, (double)0.1);
        Assert.assertEquals((double)11.0, (double)hd.p999, (double)0.1);
        Assert.assertEquals((Object)info, (Object)hd.scopeInfo);
        Assert.assertEquals((long)2L, (long)hd.getCategory());
    }

    @Test
    public void testDumpedMeter() {
        QueryScopeInfo.JobManagerQueryScopeInfo info = new QueryScopeInfo.JobManagerQueryScopeInfo();
        MetricDump.MeterDump md = new MetricDump.MeterDump((QueryScopeInfo)info, "meter", 5.0);
        Assert.assertEquals((Object)"meter", (Object)md.name);
        Assert.assertEquals((double)5.0, (double)md.rate, (double)0.1);
        Assert.assertEquals((Object)info, (Object)md.scopeInfo);
        Assert.assertEquals((long)3L, (long)md.getCategory());
    }
}

