/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.leaderelection;

import java.time.Duration;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Deadline;
import org.apache.flink.runtime.leaderelection.LeaderInformation;
import org.apache.flink.runtime.testutils.CommonTestUtils;
import org.apache.flink.util.ExceptionUtils;
import org.apache.flink.util.function.SupplierWithException;

public class TestingRetrievalBase {
    private final BlockingQueue<LeaderInformation> leaderEventQueue = new LinkedBlockingQueue<LeaderInformation>();
    private final BlockingQueue<Throwable> errorQueue = new LinkedBlockingQueue<Throwable>();
    private LeaderInformation leader = LeaderInformation.empty();
    private String oldAddress;
    private Throwable error;

    public String waitForNewLeader(long timeout) throws Exception {
        this.throwExceptionIfNotNull();
        String errorMsg = "Listener was not notified about a new leader within " + timeout + "ms";
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            this.leader = this.leaderEventQueue.poll(timeout, TimeUnit.MILLISECONDS);
            return this.leader != null && !this.leader.isEmpty() && !this.leader.getLeaderAddress().equals(this.oldAddress);
        }), Deadline.fromNow((Duration)Duration.ofMillis(timeout)), errorMsg);
        this.oldAddress = this.leader.getLeaderAddress();
        return this.leader.getLeaderAddress();
    }

    public void waitForEmptyLeaderInformation(long timeout) throws Exception {
        this.throwExceptionIfNotNull();
        String errorMsg = "Listener was not notified about an empty leader within " + timeout + "ms";
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            this.leader = this.leaderEventQueue.poll(timeout, TimeUnit.MILLISECONDS);
            return this.leader != null && this.leader.isEmpty();
        }), Deadline.fromNow((Duration)Duration.ofMillis(timeout)), errorMsg);
        this.oldAddress = null;
    }

    public void waitForError(long timeout) throws Exception {
        String errorMsg = "Listener did not see an exception with " + timeout + "ms";
        CommonTestUtils.waitUntilCondition((SupplierWithException<Boolean, Exception>)((SupplierWithException)() -> {
            this.error = this.errorQueue.poll(timeout, TimeUnit.MILLISECONDS);
            return this.error != null;
        }), Deadline.fromNow((Duration)Duration.ofMillis(timeout)), errorMsg);
    }

    public void handleError(Throwable ex) {
        this.errorQueue.offer(ex);
    }

    public LeaderInformation getLeader() {
        return this.leader;
    }

    public String getAddress() {
        return this.leader.getLeaderAddress();
    }

    public UUID getLeaderSessionID() {
        return this.leader.getLeaderSessionID();
    }

    public void offerToLeaderQueue(LeaderInformation leaderInformation) {
        this.leaderEventQueue.offer(leaderInformation);
        this.leader = leaderInformation;
    }

    public int getLeaderEventQueueSize() {
        return this.leaderEventQueue.size();
    }

    @Nullable
    public Throwable getError() {
        return this.error;
    }

    private void throwExceptionIfNotNull() throws Exception {
        if (this.error != null) {
            ExceptionUtils.rethrowException((Throwable)this.error);
        }
    }
}

