/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collections;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.clusterframework.types.SlotProfile;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridge;
import org.apache.flink.runtime.jobmaster.slotpool.DeclarativeSlotPoolBridgeBuilder;
import org.apache.flink.runtime.jobmaster.slotpool.LocationPreferenceSlotSelectionStrategy;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderImpl;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotProviderResource;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlotRequest;
import org.apache.flink.runtime.jobmaster.slotpool.SlotPool;
import org.apache.flink.runtime.jobmaster.slotpool.SlotSelectionStrategy;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;
import org.apache.flink.util.TestLogger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Rule;
import org.junit.Test;

public class PhysicalSlotProviderImplWithSpreadOutStrategyTest
extends TestLogger {
    @Rule
    public PhysicalSlotProviderResource physicalSlotProviderResource = new PhysicalSlotProviderResource((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createEvenlySpreadOut());

    @Test
    public void testSlotAllocationFulfilledWithWorkloadSpreadOut() throws InterruptedException, ExecutionException {
        this.physicalSlotProviderResource.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY, ResourceProfile.ANY, ResourceProfile.ANY, ResourceProfile.ANY);
        this.physicalSlotProviderResource.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY, ResourceProfile.ANY, ResourceProfile.ANY, ResourceProfile.ANY);
        PhysicalSlotRequest request0 = this.physicalSlotProviderResource.createSimpleRequest();
        PhysicalSlotRequest request1 = this.physicalSlotProviderResource.createSimpleRequest();
        PhysicalSlotRequest.Result result0 = this.physicalSlotProviderResource.allocateSlot(request0).get();
        PhysicalSlotRequest.Result result1 = this.physicalSlotProviderResource.allocateSlot(request1).get();
        MatcherAssert.assertThat((Object)result0.getPhysicalSlot().getTaskManagerLocation(), (Matcher)Matchers.not((Object)result1.getPhysicalSlot().getTaskManagerLocation()));
    }

    @Test
    public void testSlotAllocationFulfilledWithPreferredInputOverwrittingSpreadOut() throws ExecutionException, InterruptedException {
        this.physicalSlotProviderResource.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY, ResourceProfile.ANY);
        this.physicalSlotProviderResource.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY, ResourceProfile.ANY);
        PhysicalSlotRequest request0 = this.physicalSlotProviderResource.createSimpleRequest();
        PhysicalSlotRequest.Result result0 = this.physicalSlotProviderResource.allocateSlot(request0).get();
        TaskManagerLocation preferredTaskManagerLocation = result0.getPhysicalSlot().getTaskManagerLocation();
        PhysicalSlotRequest request1 = new PhysicalSlotRequest(new SlotRequestId(), SlotProfile.preferredLocality((ResourceProfile)ResourceProfile.ANY, Collections.singleton(preferredTaskManagerLocation)), false);
        PhysicalSlotRequest.Result result1 = this.physicalSlotProviderResource.allocateSlot(request1).get();
        MatcherAssert.assertThat((Object)result1.getPhysicalSlot().getTaskManagerLocation(), (Matcher)Matchers.is((Object)preferredTaskManagerLocation));
    }

    @Test
    public void testSlotAllocationFulfilledWithNewSlots() throws ExecutionException, InterruptedException {
        CompletableFuture<PhysicalSlotRequest.Result> slotFuture = this.physicalSlotProviderResource.allocateSlot(this.physicalSlotProviderResource.createSimpleRequest());
        MatcherAssert.assertThat((Object)slotFuture.isDone(), (Matcher)Matchers.is((Object)false));
        this.physicalSlotProviderResource.registerSlotOffersFromNewTaskExecutor(ResourceProfile.ANY);
        slotFuture.get();
    }

    @Test
    public void testIndividualBatchSlotRequestTimeoutCheckIsDisabledOnAllocatingNewSlots() throws Exception {
        DeclarativeSlotPoolBridge slotPool = new DeclarativeSlotPoolBridgeBuilder().buildAndStart(this.physicalSlotProviderResource.getMainThreadExecutor());
        MatcherAssert.assertThat((Object)slotPool.isBatchSlotRequestTimeoutCheckEnabled(), (Matcher)Matchers.is((Object)true));
        new PhysicalSlotProviderImpl((SlotSelectionStrategy)LocationPreferenceSlotSelectionStrategy.createEvenlySpreadOut(), (SlotPool)slotPool);
        MatcherAssert.assertThat((Object)slotPool.isBatchSlotRequestTimeoutCheckEnabled(), (Matcher)Matchers.is((Object)false));
    }
}

